<?php

use Illuminate\Http\Request;
use App\Http\Controllers\OrderPreparationController;
use App\Models\BoxReservation;

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);

$kernel->bootstrap();

try {
    // Buscar una reserva existente o crear una dummy para probar
    $reservation = BoxReservation::first();

    if (!$reservation) {
        echo "No reservations found to test.\n";
        exit;
    }

    echo "Testing with Reservation ID: " . $reservation->id . "\n";

    $controller = new OrderPreparationController();
    $request = Request::create('/api/order-preparation/start-box-reservation', 'POST', [
        'reservation_id' => $reservation->id
    ]);

    $response = $controller->startBoxReservation($request);

    echo "Response Status: " . $response->status() . "\n";
    echo "Response Content: " . $response->content() . "\n";
} catch (\Throwable $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString();
}
