<?php $__env->startSection('title', __('scanner.title')); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-barcode"></i> <?php echo e(__('scanner.title')); ?></h2>
        <a href="<?php echo e(route('inventory.index')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> <?php echo e(__('scanner.back_to_inventory')); ?>

        </a>
    </div>

    <div class="scanner-container-v2">
        <!-- Sección 1: Datos de Usuario y Ubicación -->
        <div class="card mb-3">
            <div class="card-header">
                <h5><i class="fas fa-user"></i> <?php echo e(__('scanner.sections.user_location')); ?></h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="n_id_operario" class="form-label"><?php echo e(__('scanner.fields.operator_id')); ?> <span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="n_id_operario" name="n_id_operario"
                                placeholder="ID" value="<?php echo e(Auth::user()->operario_id ?? Auth::user()->name); ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="n_carton" class="form-label"><?php echo e(__('scanner.fields.box_number')); ?> <span
                                    class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="n_carton" name="n_carton"
                                    placeholder="<?php echo e(__('scanner.fields.box_number_placeholder')); ?>" required>
                                <button type="button" class="btn btn-outline-primary" id="generate-box-number-btn"
                                    title="<?php echo e(__('scanner.buttons.auto_generate_title')); ?>">
                                    <i class="fas fa-magic"></i> <?php echo e(__('scanner.buttons.auto_generate')); ?>

                                </button>
                            </div>
                            <small class="text-muted"><?php echo e(__('scanner.buttons.auto_generate_note')); ?></small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="conteneur" class="form-label"><?php echo e(__('scanner.fields.container')); ?> <span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="conteneur" name="conteneur"
                                value="<?php echo e($assignedContainer->n_camion ?? ''); ?>"
                                <?php if(!Auth::user()->hasRole('admin')): ?> readonly <?php endif; ?>
                                style="background-color: #e9ecef; color: #495057;">
                            <small id="container_load_status_scan" class="text-muted">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($assignedContainer): ?>
                                    <span class="text-success"><i class="fas fa-check-circle"></i>
                                        <?php echo e(__('scanner.fields.container_assigned')); ?></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </small>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label for="notes" class="form-label"><?php echo e(__('scanner.fields.notes')); ?></label>
                            <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="needs_review" name="needs_review">
                            <label class="form-check-label" for="needs_review">
                                <i class="fas fa-exclamation-circle text-warning"></i> Marcar como "Sin Info" (Requiere
                                Revisión Posterior)
                            </label>
                            <small class="form-text text-muted d-block">Marque esta opción si no puede completar la
                                información del artículo en este momento.</small>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div id="manual-info-fields" class="row"
                            style="display: none; background-color: #fff3cd; padding: 10px; border-radius: 5px; border: 1px solid #ffeeba; margin-top: 10px;">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="marca_manual" class="form-label">Marca (Manual) <span
                                            class="text-danger">*</span></label>
                                    <select class="form-control" id="marca_manual" name="marca_manual">
                                        <option value=""><?php echo e(__('scanner.select2.select_option')); ?></option>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($brand->value); ?>"><?php echo e($brand->label); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="seccion_manual" class="form-label">Sección (Manual) <span
                                            class="text-danger">*</span></label>
                                    <select class="form-control" id="seccion_manual" name="seccion_manual">
                                        <option value=""><?php echo e(__('scanner.select2.select_option')); ?></option>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($section->value); ?>"><?php echo e($section->label); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <small class="text-muted">Estos datos se guardarán provisionalmente hasta la
                                    revisión.</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sección 2: Características del Artículo -->
        <div class="card mb-3">
            <div class="card-header">
                <h5><i class="fas fa-tags"></i> <?php echo e(__('scanner.sections.article_characteristics')); ?></h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group mb-3">
                            <label for="season_int_select" class="form-label"><?php echo e(__('scanner.fields.season_int')); ?> <span
                                    class="text-danger">*</span></label>
                            <select class="form-control" id="season_int_select" name="season_int_select" required>
                                <option value=""><?php echo e(__('scanner.select2.select_option')); ?></option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $seasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($season->value); ?>"><?php echo e($season->label); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group mb-3">
                            <label for="categoria_seleccionada" class="form-label"><?php echo e(__('scanner.fields.category')); ?>

                                <span class="text-danger">*</span></label>
                            <select class="form-control" id="categoria_seleccionada" name="categoria_seleccionada"
                                required>
                                <option value=""><?php echo e(__('scanner.select2.select_option')); ?></option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->value); ?>"><?php echo e($category->label); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group mb-3">
                            <label for="famillie_usuario" class="form-label"><?php echo e(__('scanner.fields.family')); ?> <span
                                    class="text-danger">*</span></label>
                            <select class="form-control" id="famillie_usuario" name="famillie_usuario" required>
                                <option value=""><?php echo e(__('scanner.select2.select_option')); ?></option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $families; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $family): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($family->value); ?>"><?php echo e($family->label); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group mb-3">
                            <label for="detail_usuario" class="form-label"><?php echo e(__('scanner.fields.detail')); ?> <span
                                    class="text-danger">*</span></label>
                            <select class="form-control" id="detail_usuario" name="detail_usuario" required>
                                <option value=""><?php echo e(__('scanner.select2.select_option')); ?></option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($detail->value); ?>"><?php echo e($detail->label); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="ubicacion" class="form-label"><?php echo e(__('scanner.fields.location')); ?></label>
                            <input type="text" class="form-control" id="ubicacion" name="ubicacion"
                                placeholder="<?php echo e(__('scanner.fields.location_placeholder')); ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <!-- Sección 3: Escaneo de Código de Barras -->
        <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5><i class="fas fa-qrcode"></i> <?php echo e(__('scanner.sections.barcode_scanning')); ?></h5>
                <button type="button" class="btn btn-danger btn-sm" id="delete-last-scanned-btn"
                    title="<?php echo e(__('scanner.buttons.delete_last_title')); ?>">
                    <i class="fas fa-undo"></i> <?php echo e(__('scanner.buttons.delete_last')); ?>

                </button>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group mb-3">
                            <label for="scan-quantity" class="form-label">
                                <i class="fas fa-sort-numeric-up"></i> Cantidad
                                <span class="text-muted">(Multiplicador)</span>
                            </label>
                            <input type="number" class="form-control" id="scan-quantity" name="scan-quantity"
                                value="1" min="1" max="999">
                            <small class="form-text text-muted">Número de veces que se registrará el escaneo</small>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="form-group mb-3">
                            <label for="barcode-input"><?php echo e(__('scanner.fields.barcode_scan')); ?></label>
                            <input type="text" class="form-control form-control-lg" id="barcode-input"
                                name="barcode-input" autofocus>
                            <div id="response-message" class="alert mt-2" style="display: none;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sección 4: INFO. ARTICULO (desde base de datos) -->
        <div class="card mb-3">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> <?php echo e(__('scanner.sections.article_info')); ?></h5>
            </div>
            <div class="card-body">
                <div class="data-display">
                    <div class="row">
                        <div class="col-md-6 mb-2"><strong>Código Barras Completo:</strong> <span
                                id="display_full_barcode"></span></div>
                        <div class="col-md-6 mb-2"><strong>Mocaco:</strong> <span id="display_mocaco"></span></div>
                        <div class="col-md-6 mb-2"><strong>🎨 Color (Código):</strong> <span id="display_extracted_color"
                                style="font-weight: bold; color: #2196F3;"></span></div>
                        <div class="col-md-6 mb-2"><strong>📏 Talla:</strong> <span id="display_extracted_size"
                                style="font-weight: bold; color: #4CAF50;"></span></div>
                        <div class="col-md-6 mb-2"><strong>Sección:</strong> <span id="display_seccion"></span></div>
                        <div class="col-md-6 mb-2"><strong>Descripción (Familia Articulo):</strong> <span
                                id="display_familia_articulo_description"></span></div>
                        <div class="col-md-6 mb-2"><strong>Cadena:</strong> <span id="display_cadena"></span></div>
                        <div class="col-md-6 mb-2"><strong>Mercado Origen Artículo:</strong> <span
                                id="display_mercado_origen_articulo"></span></div>
                        <div class="col-md-6 mb-2"><strong>Precio PVP Maximo Temporada:</strong> <span
                                id="display_precio_pvp_maximo_temporada"></span></div>
                        <div class="col-md-6 mb-2"><strong>Partida Arancelaria:</strong> <span
                                id="display_partida_arancelaria"></span></div>
                        <div class="col-md-6 mb-2"><strong>Composition:</strong> <span id="display_composition"></span>
                        </div>
                        <div class="col-md-6 mb-2"><strong>Campaña:</strong> <span id="display_campana"></span></div>
                        <div class="col-md-6 mb-2"><strong>Peso Unitario:</strong> <span
                                id="display_peso_unitario"></span></div>
                        <div class="col-md-6 mb-2"><strong>Grupo Arancelario:</strong> <span
                                id="display_grupo_arancelario"></span></div>
                    </div>
                </div>

                <div class="form-group mt-3">
                    <label><strong><?php echo e(__('scanner.display.total_units')); ?></strong></label>
                    <span id="total_unidades_caja" class="badge bg-primary" style="font-size: 1.2em;">0</span>
                </div>
            </div>
        </div>

        <hr>

        <!-- Sección 5: Contenido de la Caja Actual -->
        <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5><i class="fas fa-box"></i> <?php echo e(__('scanner.sections.box_content')); ?></h5>
                <div class="btn-group">
                    <button type="button" class="btn btn-primary btn-sm" id="print-label-btn"
                        title="<?php echo e(__('scanner.buttons.print_label_title')); ?>">
                        <i class="fas fa-print"></i> <?php echo e(__('scanner.buttons.print_label')); ?>

                    </button>
                    <button type="button" class="btn btn-success btn-sm" id="generate-pdf-btn"
                        title="<?php echo e(__('scanner.buttons.generate_pdf_title')); ?>">
                        <i class="fas fa-file-pdf"></i> <?php echo e(__('scanner.buttons.generate_pdf')); ?>

                    </button>
                    <button type="button" class="btn btn-info btn-sm" id="reprint-label-btn"
                        title="<?php echo e(__('scanner.buttons.reprint_title')); ?>">
                        <i class="fas fa-redo"></i> <?php echo e(__('scanner.buttons.reprint')); ?>

                    </button>
                </div>
            </div>
            <div class="card-body">
                <div id="caja-contenido-list"
                    style="max-height: 350px; overflow-y: auto; border: 1px solid #ddd; padding: 10px; background-color: #f9f9f9; border-radius: 5px;">
                    <p class="text-center text-muted"><?php echo e(__('scanner.messages.scan_article')); ?></p>
                </div>
            </div>
        </div>

        <!-- Sección 6: Alertas (Solo Admin) -->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
            <div class="card mb-3">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5><i class="fas fa-exclamation-triangle"></i> <?php echo e(__('scanner.sections.alerts')); ?></h5>
                    <button type="button" class="btn btn-primary btn-sm" id="add-alert-btn"
                        title="<?php echo e(__('scanner.buttons.add_alert_title')); ?>">
                        <i class="fas fa-plus"></i> <?php echo e(__('scanner.buttons.add_alert')); ?>

                    </button>
                </div>
                <div class="card-body">
                    <div id="alerts-container">
                        <p class="text-center text-muted"><?php echo e(__('scanner.messages.loading_alerts')); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <!-- Modal de Selección de Artículo -->
        <div id="selection-modal" class="modal-overlay" style="display: none;">
            <div class="modal-content">
                <h3><?php echo e(__('scanner.messages.select_article')); ?></h3>
                <p><?php echo e(__('scanner.messages.multiple_articles')); ?></p>
                <div id="article-options-container"></div>
                <div style="text-align: right; margin-top: 20px;">
                    <button type="button" class="btn btn-secondary"
                        id="cancel-selection-btn"><?php echo e(__('scanner.buttons.cancel')); ?></button>
                </div>
            </div>
        </div>

        <!-- Modal para Reimprimir Etiqueta -->
        <div id="reprint-modal" class="modal-overlay" style="display: none;">
            <div class="modal-content">
                <h3><i class="fas fa-redo"></i> <?php echo e(__('scanner.messages.reprint_title')); ?></h3>
                <p><?php echo e(__('scanner.messages.reprint_description')); ?></p>
                <div class="form-group mb-3">
                    <label for="reprint-box-number"
                        class="form-label"><?php echo e(__('scanner.messages.box_number_label')); ?></label>
                    <input type="text" class="form-control" id="reprint-box-number"
                        placeholder="<?php echo e(__('scanner.messages.box_number_placeholder')); ?>">
                </div>
                <div id="reprint-message" class="alert" style="display: none; margin-bottom: 15px;"></div>
                <div style="text-align: right; margin-top: 20px;">
                    <button type="button" class="btn btn-secondary"
                        id="cancel-reprint-btn"><?php echo e(__('scanner.buttons.cancel')); ?></button>
                    <button type="button" class="btn btn-primary" id="search-reprint-btn">
                        <i class="fas fa-search"></i> <?php echo e(__('scanner.buttons.search')); ?>

                    </button>
                    <button type="button" class="btn btn-success" id="confirm-reprint-btn" style="display: none;">
                        <i class="fas fa-print"></i> <?php echo e(__('scanner.buttons.print')); ?>

                    </button>
                </div>
            </div>
        </div>

        <!-- Modal para Gestionar Alertas (Solo Admin) -->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
            <div id="alert-modal" class="modal-overlay" style="display: none;">
                <div class="modal-content">
                    <h3><i class="fas fa-exclamation-triangle"></i> <span
                            id="alert-modal-title"><?php echo e(__('scanner.messages.new_alert')); ?></span></h3>
                    <form id="alert-form">
                        <input type="hidden" id="alert-id" name="id">
                        <div class="form-group mb-3">
                            <label for="alert-type" class="form-label"><?php echo e(__('scanner.messages.alert_type')); ?> <span
                                    class="text-danger">*</span></label>
                            <select class="form-control" id="alert-type" name="type" required>
                                <option value=""><?php echo e(__('scanner.messages.alert_type_select')); ?></option>
                                <option value="composition"><?php echo e(__('scanner.messages.alert_type_composition')); ?></option>
                                <option value="country"><?php echo e(__('scanner.messages.alert_type_country')); ?></option>
                            </select>
                        </div>
                        <div class="form-group mb-3">
                            <label for="alert-keywords" class="form-label"><?php echo e(__('scanner.messages.alert_keywords')); ?> <span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="alert-keywords" name="keywords"
                                placeholder="<?php echo e(__('scanner.messages.alert_keywords_placeholder')); ?>" required>
                            <small class="text-muted"><?php echo e(__('scanner.messages.alert_keywords_note')); ?></small>
                        </div>
                        <div class="form-group mb-3">
                            <label for="alert-description"
                                class="form-label"><?php echo e(__('scanner.messages.alert_description')); ?></label>
                            <input type="text" class="form-control" id="alert-description" name="description"
                                placeholder="<?php echo e(__('scanner.messages.alert_description_placeholder')); ?>">
                        </div>
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="alert-is-active" name="is_active" checked>
                            <label class="form-check-label" for="alert-is-active">
                                <?php echo e(__('scanner.messages.alert_active')); ?>

                            </label>
                        </div>
                        <div id="alert-form-message" class="alert" style="display: none; margin-bottom: 15px;"></div>
                        <div style="text-align: right; margin-top: 20px;">
                            <button type="button" class="btn btn-secondary"
                                id="cancel-alert-btn"><?php echo e(__('scanner.buttons.cancel')); ?></button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> <?php echo e(__('scanner.buttons.save')); ?>

                            </button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <!-- Modal para Añadir Nuevo Artículo -->
        <div id="new-article-modal" class="modal-overlay" style="display: none;">
            <div class="modal-content-large">
                <h3><?php echo e(__('scanner.messages.add_new_article')); ?></h3>
                <span id="new-article-barcode-display" style="display: none;"></span>
                <p id="new-article-barcode-message"></p>

                <form id="new-article-form">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="new_mocaco"><?php echo e(__('scanner.article_fields.mocaco')); ?></label>
                                <input type="text" class="form-control" id="new_mocaco" name="mocaco" required
                                    readonly>
                                <small class="text-muted"><?php echo e(__('scanner.article_fields.mocaco_note')); ?></small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="new_seccion"><?php echo e(__('scanner.article_fields.seccion')); ?></label>
                                <input type="text" class="form-control" id="new_seccion" name="seccion" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="new_familia"><?php echo e(__('scanner.article_fields.familia')); ?></label>
                                <input type="text" class="form-control" id="new_familia" name="familia" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="new_cadena"><?php echo e(__('scanner.article_fields.cadena')); ?></label>
                                <input type="text" class="form-control" id="new_cadena" name="cadena" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label
                                    for="new_mercado_origen_articulo"><?php echo e(__('scanner.article_fields.mercado_origen')); ?></label>
                                <input type="text" class="form-control" id="new_mercado_origen_articulo"
                                    name="mercado_origen_articulo">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label
                                    for="new_precio_pvp_maximo_temporada"><?php echo e(__('scanner.article_fields.precio_pvp')); ?></label>
                                <input type="number" step="0.01" class="form-control"
                                    id="new_precio_pvp_maximo_temporada" name="precio_pvp_maximo_temporada">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label
                                    for="new_partida_arancelaria"><?php echo e(__('scanner.article_fields.partida_arancelaria')); ?></label>
                                <input type="text" class="form-control" id="new_partida_arancelaria"
                                    name="partida_arancelaria">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="new_composition"><?php echo e(__('scanner.article_fields.composition')); ?></label>
                                <input type="text" class="form-control" id="new_composition" name="composition">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="new_campana"><?php echo e(__('scanner.article_fields.campana')); ?></label>
                                <input type="text" class="form-control" id="new_campana" name="campana">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="new_peso_unitario"><?php echo e(__('scanner.article_fields.peso_unitario')); ?></label>
                                <input type="number" step="0.001" class="form-control" id="new_peso_unitario"
                                    name="peso_unitario">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label
                                    for="new_grupo_arancelario"><?php echo e(__('scanner.article_fields.grupo_arancelario')); ?></label>
                                <input type="text" class="form-control" id="new_grupo_arancelario"
                                    name="grupo_arancelario">
                            </div>
                        </div>
                    </div>

                    <div id="new-article-message" class="alert mt-3" style="display:none;"></div>

                    <div style="text-align: right; margin-top: 20px;">
                        <button type="button" class="btn btn-primary"
                            id="submit-new-article-btn"><?php echo e(__('scanner.buttons.add_article')); ?></button>
                        <button type="button" class="btn btn-secondary"
                            id="cancel-new-article-btn"><?php echo e(__('scanner.buttons.cancel')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/qz-tray@latest"></script>
    <script src="<?php echo e(asset('js/qz-tray-config.js')); ?>"></script>
    <?php
        $scannerTranslations = [
            'scan_article' => __('scanner.messages.scan_article'),
            'select_category' => __('scanner.select2.select_category'),
            'select_family' => __('scanner.select2.select_family'),
            'select_detail' => __('scanner.select2.select_detail'),
            'select_season' => __('scanner.select2.select_season'),
            'article_not_found' => __('scanner.messages.article_not_found'),
            'delete_confirm' => __('scanner.messages.delete_confirm'),
            'invalid_box_container' => __('scanner.messages.invalid_box_container'),
            'loading_content' => __('scanner.messages.loading_content'),
            'content_loaded' => __('scanner.messages.content_loaded'),
            'box_dispatched' => __('scanner.messages.box_dispatched'),
            'error_loading' => __('scanner.messages.error_loading'),
            'operator' => __('scanner.display.operator'),
            'delete_item_title' => __('scanner.display.delete_item_title'),
            'barcode_not_found' => __('scanner.messages.barcode_not_found'),
        ];
    ?>
    <script>
        // Inyectar traducciones en JavaScript
        const translations = JSON.parse('<?php echo addslashes(json_encode($scannerTranslations)); ?>');

        // Función helper para formatear mensajes con parámetros
        function formatMessage(key, params = {}) {
            let message = translations[key] || key;
            Object.keys(params).forEach(param => {
                message = message.replace(`:${param}`, params[param]);
            });
            return message;
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Referencias a los elementos del DOM
            const nIdOperarioInput = document.getElementById('n_id_operario');
            const nCartonInput = document.getElementById('n_carton');
            const conteneurInput = document.getElementById('conteneur');
            const containerLoadStatusScan = document.getElementById('container_load_status_scan');
            const notesTextarea = document.getElementById('notes');
            const ubicacionInput = document.getElementById('ubicacion');

            const seasonIntSelect = document.getElementById('season_int_select');
            const categoriaSeleccionadaSelect = document.getElementById('categoria_seleccionada');
            const famillieUsuarioSelect = document.getElementById('famillie_usuario');
            const detailUsuarioSelect = document.getElementById('detail_usuario');

            const barcodeInput = document.getElementById('barcode-input');
            const scanQuantityInput = document.getElementById('scan-quantity');
            const responseMessageDiv = document.getElementById('response-message');
            const totalUnidadesCajaSpan = document.getElementById('total_unidades_caja');
            const cajaContenidoList = document.getElementById('caja-contenido-list');
            const startNewBtn = document.getElementById('start-new-btn');
            const generateBoxNumberBtn = document.getElementById('generate-box-number-btn');
            const deleteLastScannedBtn = document.getElementById('delete-last-scanned-btn');
            const addAlertBtn = document.getElementById('add-alert-btn');
            const alertsContainer = document.getElementById('alerts-container');
            const alertModal = document.getElementById('alert-modal');
            const alertForm = document.getElementById('alert-form');
            const cancelAlertBtn = document.getElementById('cancel-alert-btn');

            // Verificar si el usuario es admin antes de inicializar funciones de alertas
            const isAdmin = <?php echo e(Auth::user()->hasRole('admin') ? 'true' : 'false'); ?>;

            // Elementos para Sin Info
            const needsReviewCheckbox = document.getElementById('needs_review');
            const manualInfoFields = document.getElementById('manual-info-fields');
            const marcaManualInput = document.getElementById('marca_manual');
            const seccionManualInput = document.getElementById('seccion_manual');

            // Listener para toggle de Sin Info
            if (needsReviewCheckbox) {
                needsReviewCheckbox.addEventListener('change', function() {
                    if (this.checked) {
                        manualInfoFields.style.display = 'flex';
                        marcaManualInput.focus();
                    } else {
                        manualInfoFields.style.display = 'none';
                        marcaManualInput.value = '';
                        seccionManualInput.value = '';
                    }
                });
            }

            // Elementos para mostrar los datos del artículo escaneado
            const displayFullBarcode = document.getElementById('display_full_barcode');
            const displayMocaco = document.getElementById('display_mocaco');
            const displayExtractedColor = document.getElementById('display_extracted_color');
            const displayExtractedSize = document.getElementById('display_extracted_size');
            const displaySeccion = document.getElementById('display_seccion');
            const displayFamiliaArticuloDescription = document.getElementById(
                'display_familia_articulo_description');
            const displayCadena = document.getElementById('display_cadena');
            const displayMercadoOrigenArticulo = document.getElementById('display_mercado_origen_articulo');
            const displayPrecioPVPMaximoTemporada = document.getElementById('display_precio_pvp_maximo_temporada');
            const displayPartidaArancelaria = document.getElementById('display_partida_arancelaria');
            const displayComposition = document.getElementById('display_composition');
            const displayCampana = document.getElementById('display_campana');
            const displayPesoUnitario = document.getElementById('display_peso_unitario');
            const displayGrupoArancelario = document.getElementById('display_grupo_arancelario');

            // Elementos del modal de selección
            const selectionModal = document.getElementById('selection-modal');
            const articleOptionsContainer = document.getElementById('article-options-container');
            const cancelSelectionBtn = document.getElementById('cancel-selection-btn');

            // Elementos del modal para añadir nuevo artículo
            const newArticleModal = document.getElementById('new-article-modal');
            const newArticleForm = document.getElementById('new-article-form');
            const submitNewArticleBtn = document.getElementById('submit-new-article-btn');
            const cancelNewArticleBtn = document.getElementById('cancel-new-article-btn');
            const newArticleMessageDiv = document.getElementById('new-article-message');
            const newArticleBarcodeDisplay = document.getElementById('new-article-barcode-display');

            let currentArticleDetails = {};
            let articlesInCurrentBox = [];

            // Inicializar Select2 si está disponible
            if (window.$ && typeof window.$.fn.select2 === 'function') {
                try {
                    window.$('#categoria_seleccionada').select2({
                        placeholder: translations.select_category,
                        allowClear: true,
                        width: '100%'
                    });
                    window.$('#famillie_usuario').select2({
                        placeholder: translations.select_family,
                        allowClear: true,
                        width: '100%'
                    });
                    window.$('#detail_usuario').select2({
                        placeholder: translations.select_detail,
                        allowClear: true,
                        width: '100%'
                    });
                    window.$('#season_int_select').select2({
                        placeholder: translations.select_season,
                        allowClear: true,
                        width: '100%'
                    });
                    window.$('#marca_manual').select2({
                        placeholder: 'Seleccione Marca',
                        allowClear: true,
                        width: '100%'
                    });
                    window.$('#seccion_manual').select2({
                        placeholder: 'Seleccione Sección',
                        allowClear: true,
                        width: '100%'
                    });
                } catch (e) {
                    console.warn('Select2 no inicializado:', e);
                }
            }

            // Función para verificar si el modo "Sin Info" está activo con datos manuales completos
            function isSinInfoModeActive() {
                if (!needsReviewCheckbox || !needsReviewCheckbox.checked) {
                    return false;
                }

                // Verificar que ambos campos manuales estén llenos
                const marcaFilled = marcaManualInput && marcaManualInput.value.trim() !== '';
                const seccionFilled = seccionManualInput && seccionManualInput.value !== '';

                return marcaFilled && seccionFilled;
            }

            // Función para mostrar mensajes
            function showMessage(message, type) {
                responseMessageDiv.textContent = message;
                responseMessageDiv.className = `alert alert-${type}`;
                responseMessageDiv.style.display = 'block';
                setTimeout(() => {
                    responseMessageDiv.style.display = 'none';
                }, 5000);
            }

            // Función para limpiar campos de exhibición
            function clearDisplayFields() {
                displayFullBarcode.textContent = '';
                displayMocaco.textContent = '';
                displaySeccion.textContent = '';
                displayFamiliaArticuloDescription.textContent = '';
                displayCadena.textContent = '';
                displayMercadoOrigenArticulo.textContent = '';
                displayPrecioPVPMaximoTemporada.textContent = '';
                displayPartidaArancelaria.textContent = '';
                displayComposition.textContent = '';
                displayCampana.textContent = '';
                displayPesoUnitario.textContent = '';
                displayGrupoArancelario.textContent = '';
                displayExtractedColor.textContent = '';
                displayExtractedSize.textContent = '';
                currentArticleDetails = {};
            }

            // Función para rellenar campos de exhibición
            function populateDisplayFields(article, fullBarcodeScanned) {
                // Mostrar datos del artículo
                displayFullBarcode.textContent = fullBarcodeScanned;
                displayMocaco.textContent = article.mocaco || 'N/A';
                displaySeccion.textContent = article.seccion || 'N/A';
                displayFamiliaArticuloDescription.textContent = article.familia || 'N/A';
                displayCadena.textContent = article.cadena || 'N/A';
                displayMercadoOrigenArticulo.textContent = article.mercado_origen_articulo || 'N/A';
                displayPrecioPVPMaximoTemporada.textContent = article.precio_pvp_maximo_temporada ? parseFloat(
                    article.precio_pvp_maximo_temporada).toFixed(2) : 'N/A';
                displayPartidaArancelaria.textContent = article.partida_arancelaria || 'N/A';
                displayComposition.textContent = article.composition || 'N/A';
                displayCampana.textContent = article.campana || 'N/A';
                displayPesoUnitario.textContent = article.peso_unitario || 'N/A';
                displayGrupoArancelario.textContent = article.grupo_arancelario || 'N/A';

                // Mostrar talla y color extraídos automáticamente
                if (article.extracted_color) {
                    displayExtractedColor.textContent = article.extracted_color;
                } else {
                    displayExtractedColor.textContent = 'N/A';
                }

                if (article.extracted_size) {
                    displayExtractedSize.textContent = article.extracted_size;
                } else {
                    displayExtractedSize.textContent = 'N/A';
                }
                currentArticleDetails = article;
                currentArticleDetails.full_barcode = fullBarcodeScanned;
            }

            // Función para actualizar lista de contenido de caja
            function updateCajaContenidoList() {
                if (articlesInCurrentBox.length === 0) {
                    cajaContenidoList.innerHTML =
                        `<p class="text-center text-muted">${translations.scan_article}</p>`;
                } else {
                    cajaContenidoList.innerHTML = '';
                    articlesInCurrentBox.forEach((item, index) => {
                        // Solo mostrar artículos que tengan un ID válido
                        if (!item.id) {
                            console.warn('Artículo sin ID:', item);
                            return;
                        }

                        const listItem = document.createElement('div');
                        listItem.classList.add('d-flex', 'justify-content-between', 'align-items-start',
                            'py-2', 'border-bottom');
                        listItem.dataset.itemId = item.id;

                        const infoWrapper = document.createElement('div');
                        const pvp = item.precio_pvp_maximo_temporada ? parseFloat(item
                            .precio_pvp_maximo_temporada).toFixed(2) : 'N/A';
                        const composition = item.composition || 'N/A';
                        const paisOrigen = item.mercado_origen_articulo || 'N/A';
                        infoWrapper.innerHTML = `
                    <strong>${index + 1}.</strong> CB: ${item.full_barcode} - MOCACO: ${item.mocaco} - Fam: ${item.familia || 'N/A'} - Detalle: ${item.detail_usuario || 'N/A'} - Sección: ${item.seccion || 'N/A'}
                    <br><small class="text-muted">
                        <span style="color: #28a745;"><strong>PVP:</strong> ${pvp}</span> |
                        <span style="color: #007bff;"><strong>Composition:</strong> ${composition}</span> |
                        <span style="color: #dc3545;"><strong>País:</strong> ${paisOrigen}</span>
                    </small>
                    ${item.n_id_operario && item.n_id_operario !== 'N/A' ? `<br><small class="text-muted">${translations.operator} ${item.n_id_operario}</small>` : ''}
                `;

                        const actionsWrapper = document.createElement('div');
                        actionsWrapper.innerHTML = `
                    <button type="button" class="btn btn-outline-danger btn-sm delete-item-btn" data-item-id="${item.id}" title="${translations.delete_item_title}">
                        <i class="fas fa-trash-alt"></i>
                    </button>
                `;

                        listItem.appendChild(infoWrapper);
                        listItem.appendChild(actionsWrapper);

                        cajaContenidoList.prepend(listItem);
                    });

                    attachDeleteButtons();
                }
                totalUnidadesCajaSpan.textContent = articlesInCurrentBox.length;
            }

            function attachDeleteButtons() {
                const deleteButtons = cajaContenidoList.querySelectorAll('.delete-item-btn');
                deleteButtons.forEach(button => {
                    button.addEventListener('click', handleDeleteItemButtonClick);
                });
            }

            async function handleDeleteItemButtonClick(event) {
                const button = event.currentTarget;
                const itemId = parseInt(button.dataset.itemId, 10);

                if (!itemId || isNaN(itemId)) {
                    showMessage('Error: ID de artículo inválido.', 'danger');
                    return;
                }

                let item = articlesInCurrentBox.find(entry => entry.id === itemId);

                // Si no se encuentra el artículo en el array local, recargar el contenido de la caja
                if (!item) {
                    const boxNumber = nCartonInput.value.trim();
                    if (boxNumber) {
                        showMessage('Recargando contenido de la caja...', 'info');
                        await loadBoxContent(boxNumber);
                        item = articlesInCurrentBox.find(entry => entry.id === itemId);
                    }
                }

                if (!item) {
                    showMessage(translations.article_not_found, 'warning');
                    return;
                }

                if (!confirm(formatMessage('delete_confirm', {
                        barcode: item.full_barcode,
                        mocaco: item.mocaco
                    }))) {
                    return;
                }

                const originalContent = button.innerHTML;
                button.disabled = true;
                button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

                try {
                    await deleteItemFromBox(item);
                } finally {
                    // Si la tarjeta sigue existiendo (no se recargó la lista), restaurar el botón
                    if (document.body.contains(button)) {
                        button.disabled = false;
                        button.innerHTML = originalContent;
                    }
                }
            }

            // Función para cargar contenido de caja
            async function loadBoxContent(boxNumber, keepDisplayFields = false) {
                const containerNumber = conteneurInput.value.trim();

                if (!boxNumber || !containerNumber || containerNumber === 'ERROR_CARGA') {
                    showMessage(translations.invalid_box_container, 'danger');
                    articlesInCurrentBox = [];
                    updateCajaContenidoList();
                    return;
                }

                showMessage(formatMessage('loading_content', {
                    box: boxNumber
                }), 'info');
                if (!keepDisplayFields) {
                    clearDisplayFields();
                }

                try {
                    const response = await fetch('/scanner/get-box-content', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify({
                            n_carton: boxNumber,
                            conteneur: containerNumber
                        })
                    });
                    const data = await response.json();

                    // Si la respuesta no es OK, mostrar el mensaje del backend
                    if (!response.ok) {
                        articlesInCurrentBox = [];
                        updateCajaContenidoList();
                        const backendMsg = data && data.message ? data.message : (response.status === 422 ?
                            translations.box_dispatched : translations.error_loading);
                        showMessage(backendMsg, 'danger');
                        return;
                    }

                    if (data.success) {
                        // Mapear los datos correctamente desde la respuesta del servidor
                        articlesInCurrentBox = data.articles.map(item => ({
                            id: item.id,
                            full_barcode: item.full_barcode,
                            mocaco: item.mocaco,
                            seccion: item.seccion || item.article?.seccion || 'N/A',
                            familia: item.familia_articulo_description || item.article?.familia ||
                                'N/A',
                            detail_usuario: item.detail_usuario || 'N/A',
                            n_carton: item.n_carton,
                            conteneur: item.conteneur,
                            n_id_operario: item.n_id_operario || 'N/A',
                            precio_pvp_maximo_temporada: item.precio_pvp_maximo_temporada || item
                                .article?.precio_pvp_maximo_temporada || null,
                            composition: item.composition || item.article?.composition || null,
                            mercado_origen_articulo: item.mercado_origen_articulo || item.article
                                ?.mercado_origen_articulo || null
                        }));
                        updateCajaContenidoList();
                        showMessage(formatMessage('content_loaded', {
                            box: boxNumber,
                            count: articlesInCurrentBox.length
                        }), 'success');
                    } else {
                        articlesInCurrentBox = [];
                        updateCajaContenidoList();
                        showMessage(data.message || formatMessage('error_loading'), 'info');
                    }
                } catch (error) {
                    console.error('Error al cargar el contenido de la caja:', error);
                    articlesInCurrentBox = [];
                    updateCajaContenidoList();
                    showMessage('Error de comunicación al cargar el contenido de la caja.', 'danger');
                }
            }

            // Función para resetear todos los campos
            function resetAll() {
                nIdOperarioInput.value = '';
                nCartonInput.value = '';
                notesTextarea.value = '';
                ubicacionInput.value = '';

                seasonIntSelect.value = '';
                categoriaSeleccionadaSelect.value = '';
                famillieUsuarioSelect.value = '';
                detailUsuarioSelect.value = '';

                barcodeInput.value = '';
                clearDisplayFields();
                articlesInCurrentBox = [];
                updateCajaContenidoList();
                showMessage('Inicio de nueva sesión: todos los campos reiniciados.', 'info');
                loadContainerNumberForScan();
                nIdOperarioInput.focus();
            }

            // Event listener para Start New
            // startNewBtn.addEventListener('click', resetAll);

            // Función para generar número de caja automáticamente
            async function generateNextBoxNumber() {
                const containerNumber = conteneurInput.value.trim();

                if (!containerNumber || containerNumber === 'ERROR_CARGA') {
                    showMessage('Primero debe tener un contenedor asignado para generar el número de caja.',
                        'warning');
                    return;
                }

                generateBoxNumberBtn.disabled = true;
                generateBoxNumberBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Generando...';
                showMessage('Generando número de caja...', 'info');

                try {
                    const response = await fetch('/scanner/generate-next-box-number', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify({
                            conteneur: containerNumber,
                            format: 'container'
                        })
                    });

                    const data = await response.json();

                    if (data.success) {
                        nCartonInput.value = data.box_number;
                        showMessage(`Número de caja generado: ${data.box_number}`, 'success');
                        // Cargar contenido de la caja si ya existe
                        loadBoxContent(data.box_number);
                    } else {
                        showMessage(data.message || 'Error al generar el número de caja.', 'danger');
                    }
                } catch (error) {
                    console.error('Error al generar número de caja:', error);
                    showMessage('Error de comunicación al generar el número de caja.', 'danger');
                } finally {
                    generateBoxNumberBtn.disabled = false;
                    generateBoxNumberBtn.innerHTML = '<i class="fas fa-magic"></i> Auto';
                }
            }

            // Event listener para el botón de generar número de caja
            generateBoxNumberBtn.addEventListener('click', generateNextBoxNumber);

            // Función para borrar el último artículo escaneado
            async function deleteLastScannedItem() {
                const boxNumber = nCartonInput.value.trim();
                const containerNumber = conteneurInput.value.trim();

                if (!boxNumber) {
                    showMessage('Debe ingresar un número de caja primero.', 'warning');
                    return;
                }

                if (!containerNumber || containerNumber === 'ERROR_CARGA') {
                    showMessage('Debe tener un contenedor asignado.', 'warning');
                    return;
                }

                // Confirmar antes de eliminar
                if (!confirm(
                        '¿Está seguro de que desea eliminar el último artículo escaneado por usted en esta caja?'
                    )) {
                    return;
                }

                deleteLastScannedBtn.disabled = true;
                deleteLastScannedBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Eliminando...';
                showMessage('Eliminando último artículo escaneado...', 'info');

                try {
                    const response = await fetch('/scanner/delete-last-scanned', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify({
                            n_carton: boxNumber,
                            conteneur: containerNumber
                        })
                    });

                    const data = await response.json();

                    if (data.success) {
                        const deletedItem = data.deleted_item;
                        showMessage(
                            `Artículo eliminado: ${deletedItem.full_barcode} (MOCACO: ${deletedItem.mocaco})`,
                            'success');

                        // Eliminar el artículo de la lista local si existe
                        articlesInCurrentBox = articlesInCurrentBox.filter(item =>
                            item.full_barcode !== deletedItem.full_barcode
                        );

                        // Actualizar la lista visual
                        updateCajaContenidoList();

                        // Recargar el contenido de la caja desde el servidor para sincronizar
                        await loadBoxContent(boxNumber);

                        // Limpiar campos de visualización
                        clearDisplayFields();
                    } else {
                        showMessage(data.message || 'Error al eliminar el último artículo.', 'danger');
                    }
                } catch (error) {
                    console.error('Error al eliminar último artículo:', error);
                    showMessage('Error de comunicación al eliminar el último artículo.', 'danger');
                } finally {
                    deleteLastScannedBtn.disabled = false;
                    deleteLastScannedBtn.innerHTML = '<i class="fas fa-undo"></i> Borrar Último Escaneo';
                    barcodeInput.focus();
                }
            }

            // Event listener para el botón de borrar último escaneo
            deleteLastScannedBtn.addEventListener('click', deleteLastScannedItem);

            // Función para eliminar un artículo específico de la caja
            async function deleteItemFromBox(item) {
                const boxNumber = item.n_carton || nCartonInput.value.trim();
                const containerNumber = item.conteneur || conteneurInput.value.trim();

                if (!boxNumber) {
                    showMessage('Debe ingresar un número de caja primero.', 'warning');
                    return;
                }

                if (!containerNumber || containerNumber === 'ERROR_CARGA') {
                    showMessage('Debe tener un contenedor asignado.', 'warning');
                    return;
                }

                showMessage(`Eliminando artículo ${item.full_barcode}...`, 'info');

                try {
                    const response = await fetch('/scanner/delete-scanned-item', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify({
                            inventory_id: item.id,
                            n_carton: boxNumber,
                            conteneur: containerNumber
                        })
                    });

                    const data = await response.json();

                    if (data.success) {
                        showMessage(data.message || `Artículo ${item.full_barcode} eliminado.`, 'success');

                        articlesInCurrentBox = articlesInCurrentBox.filter(entry => entry.id !== item.id);
                        updateCajaContenidoList();

                        await loadBoxContent(boxNumber);
                        clearDisplayFields();
                    } else {
                        showMessage(data.message || 'Error al eliminar el artículo.', 'danger');
                    }
                } catch (error) {
                    console.error('Error al eliminar artículo de la caja:', error);
                    showMessage('Error de comunicación al eliminar el artículo.', 'danger');
                }
            }

            // Event listener para N_CARTON - cargar contenido cuando cambia
            nCartonInput.addEventListener('change', function() {
                const boxNumber = this.value.trim();
                if (boxNumber) {
                    loadBoxContent(boxNumber);
                } else {
                    articlesInCurrentBox = [];
                    updateCajaContenidoList();
                    clearDisplayFields();
                    showMessage('Número de caja vaciado, lista de contenido reiniciada.', 'info');
                }
            });

            // Función para validar campos obligatorios
            function validateRequiredFields() {
                const requiredInputs = [nIdOperarioInput, nCartonInput, conteneurInput];
                const requiredSelects = [seasonIntSelect, categoriaSeleccionadaSelect, famillieUsuarioSelect,
                    detailUsuarioSelect
                ];

                for (const input of requiredInputs) {
                    if (input.value.trim() === '') {
                        const label = input.previousElementSibling.textContent.replace(':', '').replace('*', '')
                            .trim();
                        showMessage(`El campo "${label}" es obligatorio.`, 'danger');
                        input.focus();
                        return false;
                    }
                }

                for (const select of requiredSelects) {
                    if (!select.value) {
                        const label = select.previousElementSibling.textContent.replace(':', '').replace('*', '')
                            .trim();
                        showMessage(`Debe seleccionar una opción para "${label}".`, 'danger');
                        return false;
                    }
                }

                if (conteneurInput.value.trim() === 'ERROR_CARGA' || conteneurInput.value.trim() === '') {
                    showMessage('El número de CONTENEDOR (Nº Camión) no se ha cargado correctamente.', 'danger');
                    return false;
                }

                return true;
            }

            // Función para cargar número de contenedor
            async function loadContainerNumberForScan() {
                // Si el campo ya tiene un valor (asignado desde el servidor), no sobrescribirlo
                if (conteneurInput.value && conteneurInput.value.trim() !== '') {
                    console.log('El contenedor ya está asignado, no se carga desde la API.');
                    return;
                }

                try {
                    containerLoadStatusScan.textContent = 'Cargando...';
                    const response = await fetch('/api/current-container?' + new Date().getTime());
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    const containerText = await response.text();
                    conteneurInput.value = containerText.trim();
                    containerLoadStatusScan.textContent = '';
                    showMessage('Número de Contenedor cargado automáticamente.', 'info');
                } catch (error) {
                    console.error('Error al cargar el número de contenedor:', error);
                    // Solo marcar como error si el campo está vacío
                    if (!conteneurInput.value || conteneurInput.value.trim() === '') {
                        conteneurInput.value = 'ERROR_CARGA';
                        containerLoadStatusScan.textContent = 'Error al cargar el Nº Camión.';
                        showMessage('Error al cargar el número de Contenedor.', 'danger');
                    }
                }
            }

            // Event listener para código de barras
            barcodeInput.addEventListener('change', async function() {
                const scannedBarcode = this.value.trim();
                this.value = '';

                if (!scannedBarcode) {
                    showMessage('El código de barras no puede estar vacío.', 'danger');
                    return;
                }

                if (!validateRequiredFields()) {
                    return;
                }

                barcodeInput.disabled = true;
                showMessage('Buscando artículo...', 'info');

                try {
                    const response = await fetch('/scanner/search-article', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify({
                            full_barcode: scannedBarcode
                        })
                    });
                    const data = await response.json();

                    if (data.success) {
                        // MEJORA: Si modo "Sin Info" está activo con datos manuales completos,
                        // saltar todos los popups y procesar directamente
                        if (isSinInfoModeActive()) {
                            // Extraer el MOCACO del código de barras (posiciones 2-11)
                            const extractedMocaco = scannedBarcode.substring(1, 11);

                            // Crear artículo dummy con los datos manuales del usuario
                            const dummyArticle = {
                                id: data.articles[0]?.id || null, // Usar ID si existe
                                mocaco: extractedMocaco, // MOCACO extraído del código de barras
                                seccion: seccionManualInput.value,
                                familia: data.articles[0]?.familia || 'SIN INFO',
                                cadena: marcaManualInput.value.trim(), // Marca manual del usuario
                                detail_usuario: 'SIN INFO',
                                precio_pvp_maximo_temporada: data.articles[0]?.precio_pvp_maximo_temporada || 0,
                                composition: data.articles[0]?.composition || 'MANUAL',
                                mercado_origen_articulo: data.articles[0]?.mercado_origen_articulo || 'MANUAL',
                                extracted_color: data.articles[0]?.extracted_color || null,
                                extracted_size: data.articles[0]?.extracted_size || null
                            };

                            // Procesar directamente sin mostrar modales
                            await processFoundArticle(dummyArticle, scannedBarcode);
                            return;
                        }

                        // Comportamiento normal cuando "Sin Info" NO está activo o no tiene datos manuales
                        // Feature: Sugerencia de Sin Info (Fallback)
                        if (needsReviewCheckbox && needsReviewCheckbox.checked && data.source ===
                            'inventory_fallback') {
                            const fallbackItem = data.articles[0];

                            // Pre-llenar campos manuales
                            // NOTA: En fallback, 'mocaco' suele tener la Marca si fue manual, o el mocaco real.
                            // 'cadena' suele tener la Marca manual si se usó el fallback de proceso.
                            const suggestedBrand = fallbackItem.cadena || fallbackItem.mocaco;
                            const suggestedSection = fallbackItem.seccion;

                            if (marcaManualInput) {
                                $(marcaManualInput).val(suggestedBrand).trigger('change');
                            }
                            if (seccionManualInput) {
                                $(seccionManualInput).val(suggestedSection).trigger('change');
                            }

                            // Preguntar al usuario
                            const confirmMsg =
                                `Sugerencia encontrada (historial):\\nMarca: ${suggestedBrand}\\nSección: ${suggestedSection}\\n\\n¿Desea usar estos datos para actualizar y completar el artículo permanentemente?`;

                            if (confirm(confirmMsg)) {
                                // Marcar para creación automática
                                fallbackItem.create_article = true;
                                fallbackItem.mocaco =
                                suggestedBrand; // Asegurar que mocaco vaya como marca si es creación
                                await processFoundArticle(fallbackItem, scannedBarcode);
                                return;
                            } else {
                                showMessage(
                                    'Sugerencia cargada. Puede editar los datos y guardar manualmente.',
                                    'info');
                                // No retornamos, permitimos que el usuario edite.
                                // Pero debemos evitar que procese automáticamente como "encontrado" abajo
                                return;
                            }
                        }

                        if (data.articles.length === 1) {
                            await processFoundArticle(data.articles[0], scannedBarcode);
                        } else if (data.articles.length > 1) {
                            showSelectionModal(data.articles, scannedBarcode);
                        } else {
                            showNewArticleModal(scannedBarcode);
                        }
                    } else {
                        // Logic for Sin Info fallback
                        if (needsReviewCheckbox && needsReviewCheckbox.checked) {
                            if (!marcaManualInput.value.trim() || !seccionManualInput.value) {
                                showMessage(
                                    'Para modo "Sin Info", debe ingresar Marca y Sección obligatoriamente.',
                                    'warning');
                                return;
                            }

                            // Extraer el MOCACO del código de barras (posiciones 2-11)
                            const extractedMocaco = scannedBarcode.substring(1, 11);

                            // Crear un artículo dummy con los datos manuales
                            const dummyArticle = {
                                id: null,
                                mocaco: extractedMocaco, // MOCACO extraído del código de barras
                                seccion: seccionManualInput.value,
                                familia: 'SIN INFO',
                                cadena: marcaManualInput.value.trim(), // Marca manual del usuario
                                detail_usuario: 'SIN INFO',
                                precio_pvp_maximo_temporada: 0,
                                composition: 'MANUAL',
                                mercado_origen_articulo: 'MANUAL'
                            };

                            showMessage('Modo Sin Info: Usando datos manuales...', 'info');
                            await processFoundArticle(dummyArticle, scannedBarcode);

                        } else {
                            showMessage(data.message || 'Error al buscar el artículo.', 'danger');
                        }
                    }
                } catch (error) {
                    console.error('Error en la comunicación con el backend:', error);
                    showMessage('Error de comunicación con el servidor al buscar el artículo.',
                        'danger');
                } finally {
                    barcodeInput.disabled = false;
                    barcodeInput.focus();
                }
            });

            // Función para procesar artículo encontrado
            async function processFoundArticle(article, fullBarcodeScanned) {
                populateDisplayFields(article, fullBarcodeScanned);

                // Obtener la cantidad a escanear
                const quantity = parseInt(scanQuantityInput.value) || 1;

                showMessage(
                    `Guardando artículo en inventario (${quantity} ${quantity === 1 ? 'unidad' : 'unidades'})...`,
                    'info');

                // Procesar múltiples escaneos según la cantidad
                let successCount = 0;
                let errorMessages = [];
                let lastSuccessfulResult = null;

                for (let i = 0; i < quantity; i++) {
                    try {
                        // Debug: verificar que el artículo tenga ID
                        console.log('Artículo seleccionado:', {
                            id: article.id,
                            mocaco: article.mocaco,
                            familia: article.familia,
                            seccion: article.seccion,
                            pvp: article.precio_pvp_maximo_temporada
                        });

                        const saveData = {
                            full_barcode: fullBarcodeScanned,
                            article_id: article.id || null, // Enviar el ID del artículo seleccionado
                            mocaco: article.mocaco || '',
                            n_carton: nCartonInput.value.trim(),
                            season_int: seasonIntSelect.value,
                            conteneur: conteneurInput.value.trim(),
                            categoria_seleccionada: categoriaSeleccionadaSelect.value,
                            famillie_usuario: famillieUsuarioSelect.value,
                            detail_usuario: detailUsuarioSelect.value,
                            ubicacion: ubicacionInput.value.trim(),
                            notes: notesTextarea.value.trim(),
                            n_id_operario: nIdOperarioInput.value.trim(),
                            needs_review: needsReviewCheckbox ? needsReviewCheckbox.checked : false,
                            marca_manual: marcaManualInput ? marcaManualInput.value.trim() : '',
                            seccion_manual: seccionManualInput ? seccionManualInput.value : '',
                            create_article: article.create_article || false
                        };

                        console.log('Datos enviados al backend:', saveData);

                        const response = await fetch('/scanner/process-scan', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'Accept': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                    .getAttribute('content')
                            },
                            body: JSON.stringify(saveData)
                        });
                        const result = await response.json();

                        // Si la respuesta no es OK, capturar el error
                        if (!response.ok) {
                            const backendMsg = result && result.message ? result.message : (response.status ===
                                422 ? 'No se puede escanear: cartón despachado.' :
                                'Error al guardar el artículo.');
                            errorMessages.push(`Escaneo ${i + 1}/${quantity}: ${backendMsg}`);
                            break; // Detener si hay un error
                        }

                        if (result.success) {
                            successCount++;
                            lastSuccessfulResult = result;

                            // Verificar y mostrar alertas si existen (solo en el primer escaneo)
                            if (i === 0 && result.has_alerts && result.alerts && result.alerts.length > 0) {
                                showAlertWarning(result.alerts);
                            }
                        } else {
                            errorMessages.push(`Escaneo ${i + 1}/${quantity}: ${result.message}`);
                            break; // Detener si hay un error
                        }
                    } catch (error) {
                        console.error('Error al guardar el artículo:', error);
                        errorMessages.push(`Escaneo ${i + 1}/${quantity}: Error de comunicación`);
                        break; // Detener si hay un error
                    }
                }

                // Mostrar resumen de los escaneos
                if (successCount > 0) {
                    const boxNumber = nCartonInput.value.trim();
                    showMessage(
                        `Se guardaron ${successCount} de ${quantity} artículos en caja ${boxNumber} correctamente.`,
                        'success');
                    // Recargar el contenido de la caja desde el servidor para obtener todos los datos correctos, incluyendo el ID
                    if (boxNumber) {
                        await loadBoxContent(boxNumber, true);
                    } else if (lastSuccessfulResult && lastSuccessfulResult.inventory) {
                        // Si no hay número de caja, agregar el artículo con los datos de la respuesta
                        articlesInCurrentBox.push({
                            id: lastSuccessfulResult.inventory.id,
                            full_barcode: lastSuccessfulResult.inventory.full_barcode ||
                                fullBarcodeScanned,
                            mocaco: lastSuccessfulResult.inventory.mocaco || article.mocaco || 'N/A',
                            familia: lastSuccessfulResult.inventory.familia_articulo_description ||
                                article.familia || article.familia_articulo_description || 'N/A',
                            detail_usuario: lastSuccessfulResult.inventory.detail_usuario ||
                                detailUsuarioSelect.value || 'N/A',
                            n_carton: lastSuccessfulResult.inventory.n_carton || boxNumber,
                            conteneur: lastSuccessfulResult.inventory.conteneur || conteneurInput.value
                                .trim(),
                            n_id_operario: lastSuccessfulResult.inventory.n_id_operario || 'N/A',
                            precio_pvp_maximo_temporada: lastSuccessfulResult.inventory
                                .precio_pvp_maximo_temporada || article.precio_pvp_maximo_temporada ||
                                null,
                            composition: lastSuccessfulResult.inventory.composition || article
                                .composition || null,
                            mercado_origen_articulo: lastSuccessfulResult.inventory
                                .mercado_origen_articulo || article.mercado_origen_articulo || null
                        });
                        updateCajaContenidoList();
                    }
                }

                if (errorMessages.length > 0) {
                    errorMessages.forEach(msg => showMessage(msg, 'danger'));
                }

                if (successCount === 0 && errorMessages.length === 0) {
                    showMessage('No se pudo guardar ningún artículo.', 'danger');
                }
            }

            // Modal de selección
            function showSelectionModal(articles, scannedBarcode) {
                articleOptionsContainer.innerHTML = '';

                // Debug: verificar que los artículos tengan ID
                console.log('Artículos recibidos en modal:', articles.map(a => ({
                    id: a.id,
                    mocaco: a.mocaco,
                    familia: a.familia,
                    seccion: a.seccion,
                    pvp: a.precio_pvp_maximo_temporada
                })));

                articles.forEach((article, index) => {
                    // Usar el índice del array para capturar el artículo correcto
                    const articleIndex = index;
                    const div = document.createElement('div');
                    div.className = 'article-option';
                    div.setAttribute('data-article-index', articleIndex); // Guardar el índice como atributo

                    const pvp = article.precio_pvp_maximo_temporada ? parseFloat(article
                        .precio_pvp_maximo_temporada).toFixed(2) : 'N/A';
                    const composition = article.composition || 'N/A';
                    const paisOrigen = article.mercado_origen_articulo || 'N/A';
                    div.innerHTML = `
                <strong>CB:</strong> ${scannedBarcode}<br>
                <strong>MOCACO:</strong> ${article.mocaco || 'N/A'}<br>
                <strong>Familia:</strong> ${article.familia || 'N/A'}<br>
                <strong>Sección:</strong> ${article.seccion || 'N/A'}<br>
                <strong>Cadena:</strong> ${article.cadena || 'N/A'}<br>
                <strong style="color: #28a745;">PVP:</strong> <span style="color: #28a745; font-weight: bold;">${pvp}</span><br>
                <strong style="color: #007bff;">Composition:</strong> <span style="color: #007bff;">${composition}</span><br>
                <strong style="color: #dc3545;">País Origen:</strong> <span style="color: #dc3545;">${paisOrigen}</span>
            `;
                    div.addEventListener('click', function() {
                        // Obtener el artículo usando el índice guardado en el array original
                        const selectedArticle = articles[articleIndex];
                        console.log('Artículo seleccionado desde modal:', {
                            index: articleIndex,
                            id: selectedArticle.id,
                            mocaco: selectedArticle.mocaco,
                            familia: selectedArticle.familia,
                            seccion: selectedArticle.seccion,
                            pvp: selectedArticle.precio_pvp_maximo_temporada
                        });
                        processFoundArticle(selectedArticle, scannedBarcode);
                        selectionModal.style.display = 'none';
                    });
                    articleOptionsContainer.appendChild(div);
                });
                selectionModal.style.display = 'flex';
            }

            cancelSelectionBtn.addEventListener('click', () => {
                selectionModal.style.display = 'none';
                barcodeInput.focus();
                clearDisplayFields();
                showMessage('Selección de artículo cancelada.', 'info');
            });

            // Modal para añadir nuevo artículo
            function showNewArticleModal(scannedBarcode) {
                newArticleBarcodeDisplay.textContent = scannedBarcode;
                const barcodeMessage = document.getElementById('new-article-barcode-message');
                if (barcodeMessage) {
                    barcodeMessage.innerHTML = formatMessage('barcode_not_found', {
                        barcode: scannedBarcode
                    });
                }
                newArticleForm.reset();
                newArticleMessageDiv.style.display = 'none';
                document.getElementById('new_mocaco').value = scannedBarcode.substring(1, 11);
                newArticleModal.style.display = 'flex';
            }

            cancelNewArticleBtn.addEventListener('click', () => {
                newArticleModal.style.display = 'none';
                barcodeInput.focus();
                clearDisplayFields();
                showMessage('Creación de nuevo artículo cancelada.', 'info');
            });

            submitNewArticleBtn.addEventListener('click', async () => {
                const newArticleData = {
                    full_barcode: newArticleBarcodeDisplay.textContent,
                    mocaco: document.getElementById('new_mocaco').value,
                    seccion: document.getElementById('new_seccion').value,
                    familia: document.getElementById('new_familia').value,
                    cadena: document.getElementById('new_cadena').value,
                    mercado_origen_articulo: document.getElementById('new_mercado_origen_articulo')
                        .value,
                    precio_pvp_maximo_temporada: document.getElementById(
                        'new_precio_pvp_maximo_temporada').value,
                    partida_arancelaria: document.getElementById('new_partida_arancelaria').value,
                    composition: document.getElementById('new_composition').value,
                    campana: document.getElementById('new_campana').value,
                    peso_unitario: document.getElementById('new_peso_unitario').value,
                    grupo_arancelario: document.getElementById('new_grupo_arancelario').value
                };

                for (const key in newArticleData) {
                    if (['mocaco', 'seccion', 'familia', 'cadena', 'full_barcode'].includes(key) && !
                        newArticleData[key]) {
                        newArticleMessageDiv.textContent = `Por favor, complete el campo ${key}.`;
                        newArticleMessageDiv.className = 'alert alert-danger';
                        newArticleMessageDiv.style.display = 'block';
                        return;
                    }
                }

                newArticleMessageDiv.textContent = 'Guardando nuevo artículo...';
                newArticleMessageDiv.className = 'alert alert-info';
                newArticleMessageDiv.style.display = 'block';

                try {
                    const response = await fetch('/scanner/create-article', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify(newArticleData)
                    });
                    const result = await response.json();

                    if (result.success) {
                        newArticleMessageDiv.textContent = 'Nuevo artículo añadido con éxito.';
                        newArticleMessageDiv.className = 'alert alert-success';
                        newArticleModal.style.display = 'none';
                        await processFoundArticle(newArticleData, newArticleData.full_barcode);
                    } else {
                        newArticleMessageDiv.textContent =
                            `Error al añadir nuevo artículo: ${result.message}`;
                        newArticleMessageDiv.className = 'alert alert-danger';
                    }
                } catch (error) {
                    console.error('Error de comunicación al añadir nuevo artículo:', error);
                    newArticleMessageDiv.textContent = 'Error de comunicación con el servidor.';
                    newArticleMessageDiv.className = 'alert alert-danger';
                }
            });

            // ========== FUNCIONALIDAD DE ETIQUETAS ==========
            const printLabelBtn = document.getElementById('print-label-btn');
            const generatePdfBtn = document.getElementById('generate-pdf-btn');
            const reprintLabelBtn = document.getElementById('reprint-label-btn');
            const reprintModal = document.getElementById('reprint-modal');
            const cancelReprintBtn = document.getElementById('cancel-reprint-btn');
            const searchReprintBtn = document.getElementById('search-reprint-btn');
            const confirmReprintBtn = document.getElementById('confirm-reprint-btn');
            const reprintBoxNumber = document.getElementById('reprint-box-number');
            const reprintMessage = document.getElementById('reprint-message');
            let reprintBoxData = null;

            // Función para generar y abrir etiqueta PDF
            async function printBoxLabelPdf(nCarton, conteneur) {
                try {
                    showMessage('Generando etiqueta PDF...', 'info');

                    // Crear un formulario temporal para enviar la petición POST
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = '/scanner/generate-box-label-pdf';
                    form.target = '_blank';

                    // Agregar CSRF token
                    const csrfInput = document.createElement('input');
                    csrfInput.type = 'hidden';
                    csrfInput.name = '_token';
                    csrfInput.value = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                    form.appendChild(csrfInput);

                    // Agregar número de caja
                    const nCartonInput = document.createElement('input');
                    nCartonInput.type = 'hidden';
                    nCartonInput.name = 'n_carton';
                    nCartonInput.value = nCarton;
                    form.appendChild(nCartonInput);

                    // Agregar contenedor si existe
                    if (conteneur) {
                        const conteneurInput = document.createElement('input');
                        conteneurInput.type = 'hidden';
                        conteneurInput.name = 'conteneur';
                        conteneurInput.value = conteneur;
                        form.appendChild(conteneurInput);
                    }

                    // Agregar formulario al body, enviarlo y removerlo
                    document.body.appendChild(form);
                    form.submit();
                    document.body.removeChild(form);

                    showMessage(`Etiqueta PDF de caja ${nCarton} generada.`, 'success');
                } catch (err) {
                    console.error('Error al generar PDF:', err);
                    showMessage('Error al generar la etiqueta: ' + err.message, 'danger');
                }
            }

            // Botón: Imprimir etiqueta de caja actual
            printLabelBtn.addEventListener('click', async () => {
                const nCarton = nCartonInput.value.trim();
                const conteneur = conteneurInput.value.trim();

                if (!nCarton) {
                    showMessage('Por favor, ingrese un número de caja primero.', 'warning');
                    nCartonInput.focus();
                    return;
                }

                if (articlesInCurrentBox.length === 0) {
                    showMessage(
                        'La caja está vacía. Escanee al menos un artículo antes de imprimir la etiqueta.',
                        'warning');
                    return;
                }

                await printBoxLabelPdf(nCarton, conteneur);
            });

            // Botón: Generar PDF CONTENU DU COLIS
            generatePdfBtn.addEventListener('click', async () => {
                const nCarton = nCartonInput.value.trim();
                const conteneur = conteneurInput.value.trim();

                if (!nCarton) {
                    showMessage('Por favor, ingrese un número de caja primero.', 'warning');
                    nCartonInput.focus();
                    return;
                }

                if (articlesInCurrentBox.length === 0) {
                    showMessage(
                        'La caja está vacía. Escanee al menos un artículo antes de generar el PDF.',
                        'warning');
                    return;
                }

                try {
                    showMessage('Generando PDF...', 'info');

                    // Crear formulario para enviar datos
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = '/scanner/generate-contenu-du-colis-pdf';
                    form.target = '_blank'; // Abrir en nueva ventana

                    // Agregar CSRF token
                    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute(
                        'content');
                    const csrfInput = document.createElement('input');
                    csrfInput.type = 'hidden';
                    csrfInput.name = '_token';
                    csrfInput.value = csrfToken;
                    form.appendChild(csrfInput);

                    // Agregar n_carton
                    const nCartonInputHidden = document.createElement('input');
                    nCartonInputHidden.type = 'hidden';
                    nCartonInputHidden.name = 'n_carton';
                    nCartonInputHidden.value = nCarton;
                    form.appendChild(nCartonInputHidden);

                    // Agregar conteneur si existe
                    if (conteneur) {
                        const conteneurInputHidden = document.createElement('input');
                        conteneurInputHidden.type = 'hidden';
                        conteneurInputHidden.name = 'conteneur';
                        conteneurInputHidden.value = conteneur;
                        form.appendChild(conteneurInputHidden);
                    }

                    // Agregar al body y enviar
                    document.body.appendChild(form);
                    form.submit();
                    document.body.removeChild(form);

                    showMessage('PDF generado. Se abrirá en una nueva ventana.', 'success');
                } catch (err) {
                    console.error('Error al generar PDF:', err);
                    showMessage('Error al generar el PDF: ' + err.message, 'danger');
                }
            });

            // Botón: Abrir modal de reimpresión
            reprintLabelBtn.addEventListener('click', () => {
                reprintModal.style.display = 'flex';
                reprintBoxNumber.value = '';
                reprintMessage.style.display = 'none';
                confirmReprintBtn.style.display = 'none';
                reprintBoxData = null;
                reprintBoxNumber.focus();
            });

            // Botón: Cancelar reimpresión
            cancelReprintBtn.addEventListener('click', () => {
                reprintModal.style.display = 'none';
                reprintBoxNumber.value = '';
                reprintMessage.style.display = 'none';
                reprintBoxData = null;
            });

            // Botón: Buscar caja para reimpresión
            searchReprintBtn.addEventListener('click', async () => {
                const boxNumber = reprintBoxNumber.value.trim();

                if (!boxNumber) {
                    reprintMessage.textContent = 'Por favor, ingrese un número de caja.';
                    reprintMessage.className = 'alert alert-warning';
                    reprintMessage.style.display = 'block';
                    return;
                }

                try {
                    const response = await fetch('/scanner/find-box-reprint', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify({
                            n_carton: boxNumber
                        })
                    });

                    const result = await response.json();

                    if (!result.success) {
                        reprintMessage.textContent = result.message || 'Caja no encontrada.';
                        reprintMessage.className = 'alert alert-danger';
                        reprintMessage.style.display = 'block';
                        confirmReprintBtn.style.display = 'none';
                        reprintBoxData = null;
                        return;
                    }

                    reprintBoxData = result.box;
                    reprintMessage.textContent =
                        `Caja encontrada: ${result.box.n_carton} (${result.box.total_items} items). Contenedor: ${result.box.conteneur || 'N/A'}`;
                    reprintMessage.className = 'alert alert-success';
                    reprintMessage.style.display = 'block';
                    confirmReprintBtn.style.display = 'inline-block';
                } catch (err) {
                    console.error('Error al buscar caja:', err);
                    reprintMessage.textContent = 'Error al buscar la caja: ' + err.message;
                    reprintMessage.className = 'alert alert-danger';
                    reprintMessage.style.display = 'block';
                }
            });

            // Botón: Confirmar reimpresión
            confirmReprintBtn.addEventListener('click', async () => {
                if (!reprintBoxData) {
                    return;
                }

                await printBoxLabelPdf(reprintBoxData.n_carton, reprintBoxData.conteneur);
                reprintModal.style.display = 'none';
                reprintBoxData = null;
            });

            // Permitir Enter en el campo de búsqueda
            reprintBoxNumber.addEventListener('keypress', (e) => {
                if (e.key === 'Enter') {
                    searchReprintBtn.click();
                }
            });

            // ========== FIN FUNCIONALIDAD DE ETIQUETAS ==========

            // ========== GESTIÓN DE ALERTAS (Solo Admin) ==========

            // Función para cargar alertas
            async function loadAlerts() {
                // Solo cargar si el usuario es admin
                if (!isAdmin || !alertsContainer) {
                    return;
                }
                try {
                    const response = await fetch('/scanner/alerts', {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        }
                    });

                    const data = await response.json();

                    if (data.success) {
                        displayAlerts(data.alerts);
                    } else {
                        alertsContainer.innerHTML =
                            '<p class="text-center text-danger">Error al cargar alertas.</p>';
                    }
                } catch (error) {
                    console.error('Error al cargar alertas:', error);
                    alertsContainer.innerHTML =
                        '<p class="text-center text-danger">Error de comunicación al cargar alertas.</p>';
                }
            }

            // Función para mostrar alertas en la lista
            function displayAlerts(alerts) {
                if (!alerts || alerts.length === 0) {
                    alertsContainer.innerHTML =
                        '<p class="text-center text-muted">No hay alertas configuradas. Haga clic en "Agregar Alerta" para crear una.</p>';
                    return;
                }

                let html = '<div class="table-responsive"><table class="table table-sm table-hover">';
                html +=
                    '<thead><tr><th>Tipo</th><th>Palabras Clave</th><th>Descripción</th><th>Estado</th><th>Acciones</th></tr></thead><tbody>';

                alerts.forEach(alert => {
                    const typeLabel = alert.type === 'composition' ? 'Composición' : 'País';
                    const statusBadge = alert.is_active ?
                        '<span class="badge bg-success">Activa</span>' :
                        '<span class="badge bg-secondary">Inactiva</span>';

                    html += `<tr>
                <td>${typeLabel}</td>
                <td><small>${alert.keywords}</small></td>
                <td>${alert.description || '-'}</td>
                <td>${statusBadge}</td>
                <td>
                    <button class="btn btn-sm btn-warning edit-alert-btn" data-id="${alert.id}" title="Editar">
                        <i class="fas fa-edit"></i>
                    </button>
                    <button class="btn btn-sm btn-danger delete-alert-btn" data-id="${alert.id}" title="Eliminar">
                        <i class="fas fa-trash"></i>
                    </button>
                </td>
            </tr>`;
                });

                html += '</tbody></table></div>';
                alertsContainer.innerHTML = html;

                // Agregar event listeners a los botones
                document.querySelectorAll('.edit-alert-btn').forEach(btn => {
                    btn.addEventListener('click', () => editAlert(parseInt(btn.dataset.id)));
                });

                document.querySelectorAll('.delete-alert-btn').forEach(btn => {
                    btn.addEventListener('click', () => deleteAlert(parseInt(btn.dataset.id)));
                });
            }

            // Función para mostrar alerta de advertencia cuando se escanea un artículo
            function showAlertWarning(alerts) {
                let message = '<strong style="font-size: 1.2em;">⚠️ ALERTA DETECTADA</strong><br><br>';
                alerts.forEach((alert, index) => {
                    const typeLabel = alert.type === 'composition' ? 'Composición' : 'País de Fabricación';
                    const keywordsText = Array.isArray(alert.keywords) ? alert.keywords.join(', ') : alert
                        .keywords;
                    message += `<strong>${index + 1}. ${typeLabel}</strong><br>`;
                    message += `   ${alert.description || 'Alerta activa'}<br>`;
                    message += `   <small>Palabras clave: ${keywordsText}</small><br><br>`;
                });

                // Crear overlay bloqueante
                const overlay = document.createElement('div');
                overlay.id = 'alert-warning-overlay';
                overlay.style.cssText = `
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.7);
                z-index: 10000;
                display: flex;
                justify-content: center;
                align-items: center;
            `;

                // Crear modal de alerta
                const alertModal = document.createElement('div');
                alertModal.style.cssText = `
                background: white;
                padding: 30px;
                border-radius: 8px;
                max-width: 600px;
                width: 90%;
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.5);
                position: relative;
            `;
                alertModal.innerHTML = `
                <div style="color: #856404; background-color: #fff3cd; border: 2px solid #ffc107; padding: 20px; border-radius: 5px;">
                    ${message}
                </div>
                <button type="button" id="close-alert-warning" style="
                    position: absolute;
                    top: 10px;
                    right: 10px;
                    background: #dc3545;
                    color: white;
                    border: none;
                    border-radius: 50%;
                    width: 35px;
                    height: 35px;
                    font-size: 20px;
                    cursor: pointer;
                    font-weight: bold;
                    line-height: 1;
                ">&times;</button>
            `;

                overlay.appendChild(alertModal);
                document.body.appendChild(overlay);

                // Deshabilitar el input del escáner
                barcodeInput.disabled = true;

                // Cerrar al hacer clic en la X
                document.getElementById('close-alert-warning').addEventListener('click', () => {
                    overlay.remove();
                    barcodeInput.disabled = false;
                    barcodeInput.focus();
                });
            }

            // Función para abrir modal de alerta (nueva o edición)
            function openAlertModal(alert = null) {
                const title = document.getElementById('alert-modal-title');
                const form = document.getElementById('alert-form');

                if (alert) {
                    title.textContent = 'Editar Alerta';
                    document.getElementById('alert-id').value = alert.id;
                    document.getElementById('alert-type').value = alert.type;
                    document.getElementById('alert-keywords').value = alert.keywords;
                    document.getElementById('alert-description').value = alert.description || '';
                    document.getElementById('alert-is-active').checked = alert.is_active;
                } else {
                    title.textContent = 'Nueva Alerta';
                    form.reset();
                    document.getElementById('alert-id').value = '';
                    document.getElementById('alert-is-active').checked = true;
                }

                alertModal.style.display = 'flex';
            }

            // Función para editar alerta
            async function editAlert(id) {
                try {
                    const response = await fetch('/scanner/alerts', {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        }
                    });

                    const data = await response.json();
                    if (data.success) {
                        const alert = data.alerts.find(a => a.id === id);
                        if (alert) {
                            openAlertModal(alert);
                        }
                    }
                } catch (error) {
                    console.error('Error al cargar alerta:', error);
                    showMessage('Error al cargar la alerta para editar.', 'danger');
                }
            }

            // Función para eliminar alerta
            async function deleteAlert(id) {
                if (!confirm('¿Está seguro de que desea eliminar esta alerta?')) {
                    return;
                }

                try {
                    const response = await fetch('/scanner/alerts/delete', {
                        method: 'DELETE',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                .getAttribute('content')
                        },
                        body: JSON.stringify({
                            id: id
                        })
                    });

                    const data = await response.json();

                    if (data.success) {
                        showMessage('Alerta eliminada correctamente.', 'success');
                        await loadAlerts();
                    } else {
                        showMessage(data.message || 'Error al eliminar la alerta.', 'danger');
                    }
                } catch (error) {
                    console.error('Error al eliminar alerta:', error);
                    showMessage('Error de comunicación al eliminar la alerta.', 'danger');
                }
            }

            // Event listeners para alertas (solo si es admin)
            if (isAdmin && addAlertBtn) {
                addAlertBtn.addEventListener('click', () => openAlertModal());
            }

            if (isAdmin && cancelAlertBtn) {
                cancelAlertBtn.addEventListener('click', () => {
                    if (alertModal) {
                        alertModal.style.display = 'none';
                    }
                    if (alertForm) {
                        alertForm.reset();
                    }
                });
            }

            if (isAdmin && alertForm) {
                alertForm.addEventListener('submit', async (e) => {
                    e.preventDefault();

                    const formData = {
                        id: document.getElementById('alert-id').value || null,
                        type: document.getElementById('alert-type').value,
                        keywords: document.getElementById('alert-keywords').value,
                        description: document.getElementById('alert-description').value,
                        is_active: document.getElementById('alert-is-active').checked
                    };

                    const messageDiv = document.getElementById('alert-form-message');
                    messageDiv.style.display = 'none';

                    try {
                        const response = await fetch('/scanner/alerts', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'Accept': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector(
                                    'meta[name="csrf-token"]').getAttribute('content')
                            },
                            body: JSON.stringify(formData)
                        });

                        const data = await response.json();

                        if (data.success) {
                            messageDiv.className = 'alert alert-success';
                            messageDiv.textContent = data.message;
                            messageDiv.style.display = 'block';

                            setTimeout(async () => {
                                alertModal.style.display = 'none';
                                alertForm.reset();
                                await loadAlerts();
                            }, 1000);
                        } else {
                            messageDiv.className = 'alert alert-danger';
                            messageDiv.textContent = data.message || 'Error al guardar la alerta.';
                            messageDiv.style.display = 'block';
                        }
                    } catch (error) {
                        console.error('Error al guardar alerta:', error);
                        messageDiv.className = 'alert alert-danger';
                        messageDiv.textContent = 'Error de comunicación al guardar la alerta.';
                        messageDiv.style.display = 'block';
                    }
                });
            }

            // Cerrar modal al hacer clic fuera (solo si es admin)
            if (isAdmin && alertModal) {
                alertModal.addEventListener('click', (e) => {
                    if (e.target === alertModal) {
                        alertModal.style.display = 'none';
                        if (alertForm) {
                            alertForm.reset();
                        }
                    }
                });
            }

            // Cargar alertas al inicio (solo si es admin)
            if (isAdmin) {
                loadAlerts();
            }

            // ========== FIN GESTIÓN DE ALERTAS ==========

            // Cargar contenedor al inicio
            loadContainerNumberForScan();
            nIdOperarioInput.focus();

            // ========== FOCO PERMANENTE EN CAMPO DE ESCANEO ==========
            // Función para devolver el foco al campo de código de barras
            function returnFocusToBarcode() {
                // Solo devolver foco si no estamos en un modal o input específico
                const activeElement = document.activeElement;
                const isInModal = activeElement.closest('.modal');
                const isTextarea = activeElement.tagName === 'TEXTAREA';
                const isInput = activeElement.tagName === 'INPUT';
                const isSelect = activeElement.tagName === 'SELECT';

                // No devolver foco si estamos editando otro campo intencionalmente
                if (isInModal || (isTextarea && activeElement !== barcodeInput) ||
                    (isInput && activeElement !== barcodeInput) || isSelect) {
                    return;
                }

                // Devolver foco al campo de código de barras
                if (barcodeInput && document.activeElement !== barcodeInput) {
                    barcodeInput.focus();
                }
            }

            // Devolver foco después de clicks en botones
            document.addEventListener('click', function(e) {
                // Esperar un momento para que el evento del botón se complete
                setTimeout(returnFocusToBarcode, 100);
            });

            // Devolver foco cuando se pierde el foco del campo de código de barras
            if (barcodeInput) {
                barcodeInput.addEventListener('blur', function(e) {
                    // Esperar un momento para permitir que otros elementos reciban el foco primero
                    setTimeout(returnFocusToBarcode, 150);
                });

                // Foco inicial en el campo de código de barras
                setTimeout(() => {
                    barcodeInput.focus();
                }, 500);
            }

            // Devolver foco al presionar Escape (cancelar cualquier acción)
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    setTimeout(returnFocusToBarcode, 100);
                }
            });

            // Devolver foco periódicamente si no hay actividad en modales
            setInterval(function() {
                const activeElement = document.activeElement;
                const isInModal = activeElement.closest('.modal');

                if (!isInModal && activeElement.tagName === 'BODY') {
                    returnFocusToBarcode();
                }
            }, 2000); // Cada 2 segundos

            // ========== FIN FOCO PERMANENTE ==========
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .scanner-container-v2 {
            max-width: 1400px;
            margin: 0 auto;
        }

        .data-display {
            background-color: #e9ecef;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
            border: 1px solid #ced4da;
        }

        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            box-sizing: border-box;
        }

        .modal-content {
            background: #fff;
            padding: 25px;
            border-radius: 8px;
            max-width: 600px;
            width: 90%;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            text-align: left;
            max-height: 80vh;
            overflow-y: auto;
        }

        .modal-content-large {
            background: #fff;
            padding: 25px;
            border-radius: 8px;
            max-width: 900px;
            width: 90%;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            text-align: left;
            max-height: 80vh;
            overflow-y: auto;
        }

        .article-option {
            padding: 10px;
            border: 1px solid #eee;
            margin-bottom: 8px;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .article-option:hover {
            background-color: #f0f0f0;
        }

        .article-option.selected {
            background-color: #e0f7fa;
            border-color: #00bcd4;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/inventory/inventory_new/resources/views/scanner/index.blade.php ENDPATH**/ ?>