<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3"><?php echo e(__('Reservas de Cajas')); ?></h1>
                <div>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reservations.view')): ?>
                        <a href="<?php echo e(route('reservations.available-inventory')); ?>" class="btn btn-info">
                            <i class="fas fa-download"></i> <?php echo e(__('Descargar Inventario')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reservations.create')): ?>
                        <a href="<?php echo e(route('reservations.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> <?php echo e(__('Nueva Reserva')); ?>

                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('reservations.index')); ?>" class="row g-3">
                <div class="col-md-4">
                    <label for="status" class="form-label"><?php echo e(__('Estado')); ?></label>
                    <select name="status" id="status" class="form-select">
                        <option value=""><?php echo e(__('Todos')); ?></option>
                        <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>><?php echo e(__('Pendiente')); ?></option>
                        <option value="in_progress" <?php echo e(request('status') == 'in_progress' ? 'selected' : ''); ?>><?php echo e(__('En Proceso')); ?></option>
                        <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>><?php echo e(__('Completada')); ?></option>
                        <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>><?php echo e(__('Cancelada')); ?></option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="client_id" class="form-label"><?php echo e(__('Cliente')); ?></label>
                    <select name="client_id" id="client_id" class="form-select">
                        <option value=""><?php echo e(__('Todos')); ?></option>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($client->id); ?>" <?php echo e(request('client_id') == $client->id ? 'selected' : ''); ?>>
                                <?php echo e($client->client_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-filter"></i> <?php echo e(__('Filtrar')); ?>

                    </button>
                    <a href="<?php echo e(route('reservations.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-times"></i> <?php echo e(__('Limpiar')); ?>

                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Reservations Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Código')); ?></th>
                            <th><?php echo e(__('Cliente')); ?></th>
                            <th><?php echo e(__('Estado')); ?></th>
                            <th><?php echo e(__('Cajas')); ?></th>
                            <th><?php echo e(__('Progreso')); ?></th>
                            <th><?php echo e(__('Creado por')); ?></th>
                            <th><?php echo e(__('Fecha')); ?></th>
                            <th><?php echo e(__('Acciones')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $reservations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reservation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('reservations.show', $reservation)); ?>" class="fw-bold text-decoration-none">
                                        <?php echo e($reservation->reservation_code); ?>

                                    </a>
                                </td>
                                <td><?php echo e($reservation->client->client_name); ?></td>
                                <td>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($reservation->status == 'pending'): ?>
                                        <span class="badge bg-warning"><?php echo e(__('Pendiente')); ?></span>
                                    <?php elseif($reservation->status == 'in_progress'): ?>
                                        <span class="badge bg-info"><?php echo e(__('En Proceso')); ?></span>
                                    <?php elseif($reservation->status == 'completed'): ?>
                                        <span class="badge bg-success"><?php echo e(__('Completada')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-danger"><?php echo e(__('Cancelada')); ?></span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-primary"><?php echo e($reservation->total_boxes); ?></span> total
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($reservation->confirmed_boxes > 0): ?>
                                        <br><span class="badge bg-success"><?php echo e($reservation->confirmed_boxes); ?></span> confirmadas
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                                <td>
                                    <div class="progress" style="height: 20px;">
                                        <div class="progress-bar <?php echo e($reservation->completion_percentage == 100 ? 'bg-success' : 'bg-info'); ?>"
                                             role="progressbar"
                                             style="width: <?php echo e($reservation->completion_percentage); ?>%"
                                             aria-valuenow="<?php echo e($reservation->completion_percentage); ?>"
                                             aria-valuemin="0"
                                             aria-valuemax="100">
                                            <?php echo e(number_format($reservation->completion_percentage, 0)); ?>%
                                        </div>
                                    </div>
                                </td>
                                <td><?php echo e($reservation->reservedBy->name ?? 'N/A'); ?></td>
                                <td><?php echo e($reservation->created_at->format('d/m/Y H:i')); ?></td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('reservations.show', $reservation)); ?>"
                                           class="btn btn-sm btn-info"
                                           title="<?php echo e(__('Ver')); ?>">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($reservation->isPending() || $reservation->isInProgress()): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reservations.cancel')): ?>
                                                <form action="<?php echo e(route('reservations.cancel', $reservation)); ?>"
                                                      method="POST"
                                                      class="d-inline"
                                                      onsubmit="return confirm('¿Está seguro de cancelar esta reserva?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger" title="<?php echo e(__('Cancelar')); ?>">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">
                                    <?php echo e(__('No hay reservas registradas')); ?>

                                </td>
                            </tr>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-3">
                <?php echo e($reservations->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/inventory/inventory_new/resources/views/reservations/index.blade.php ENDPATH**/ ?>