<div class="flex gap-2 justify-end">
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('articles.view')): ?>
    <a href="<?php echo e(route('articles.show', $article)); ?>"
       class="inline-flex items-center px-3 py-1.5 bg-blue-500 text-white text-xs rounded hover:bg-blue-600 transition-colors"
       title="Ver detalles">
        <i class="fas fa-eye"></i>
    </a>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('articles.edit')): ?>
    <a href="<?php echo e(route('articles.edit', $article)); ?>"
       class="inline-flex items-center px-3 py-1.5 bg-yellow-500 text-white text-xs rounded hover:bg-yellow-600 transition-colors"
       title="Editar">
        <i class="fas fa-edit"></i>
    </a>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('articles.delete')): ?>
    <button wire:click="deleteArticle(<?php echo e($article->id); ?>)"
            wire:confirm="¿Estás seguro de que deseas eliminar este artículo?"
            class="inline-flex items-center px-3 py-1.5 bg-red-500 text-white text-xs rounded hover:bg-red-600 transition-colors"
            title="Eliminar">
        <i class="fas fa-trash"></i>
    </button>
    <?php endif; ?>
</div>
<?php /**PATH /var/www/inventory/inventory_new/resources/views/articles/partials/actions.blade.php ENDPATH**/ ?>