<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-shopping-cart"></i> <?php echo e(__('order_preparation.create_order')); ?> (Livewire)</h5>
            </div>
            <div class="card-body">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($message): ?>
                    <div class="alert alert-<?php echo e($messageType == 'error' ? 'danger' : ($messageType == 'success' ? 'success' : 'info')); ?> alert-dismissible fade show" role="alert">
                        <?php echo e($message); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close" wire:click="$set('message', '')"></button>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="client_select" class="form-label"><?php echo e(__('order_preparation.select_client')); ?></label>
                            <select id="client_select" wire:model.live="clientId" class="form-control">
                                <option value=""><?php echo e(__('order_preparation.select_client_placeholder')); ?></option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $this->clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($client->id); ?>"><?php echo e($client->client_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['clientId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="operarioId" class="form-label"><?php echo e(__('order_preparation.operator_id')); ?></label>
                            <input type="text" id="operarioId" wire:model="operarioId" class="form-control" placeholder="<?php echo e(__('order_preparation.operator_placeholder')); ?>">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['operarioId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="form-group mb-3">
                    <label for="order_notes" class="form-label"><?php echo e(__('order_preparation.order_notes')); ?></label>
                    <textarea id="order_notes" wire:model="notes" class="form-control" rows="2" placeholder="<?php echo e(__('order_preparation.order_notes_placeholder')); ?>"></textarea>
                </div>

                <hr>

                <div class="form-group mb-3">
                    <label for="barcodeInput" class="form-label"><?php echo e(__('order_preparation.scan_barcode')); ?></label>
                    <form wire:submit.prevent="scanBarcode">
                        <div class="input-group">
                            <input type="text" id="barcodeInput" wire:model="barcodeInput" class="form-control" placeholder="<?php echo e(__('order_preparation.scan_barcode_placeholder')); ?>" autofocus>
                            <button class="btn btn-primary" type="submit">Agregar</button>
                        </div>
                    </form>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <h5><?php echo e(__('order_preparation.current_boxes')); ?> <span class="badge bg-primary"><?php echo e(count($scannedBoxes)); ?></span></h5>
                    </div>
                    <div class="col-md-6 text-end">
                        <button type="button" wire:click="resetOrder" class="btn btn-warning">
                            <i class="fas fa-undo"></i> <?php echo e(__('order_preparation.reset_order')); ?>

                        </button>
                    </div>
                </div>

                <div class="mt-3">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(empty($scannedBoxes)): ?>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> <?php echo e(__('order_preparation.scan_to_start')); ?>

                        </div>
                    <?php else: ?>
                        <div class="list-group">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = array_reverse($scannedBoxes); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $box): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <span><i class="fas fa-box"></i> <?php echo e($box); ?></span>
                                    <button class="btn btn-sm btn-danger" wire:click="removeBox('<?php echo e($box); ?>')">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                <div class="d-flex justify-content-end gap-2 mt-4">
                    <button type="button" wire:click="saveDraft" class="btn btn-success" <?php if(empty($scannedBoxes) || !$clientId || !$operarioId): ?> disabled <?php endif; ?>>
                        <i class="fas fa-save"></i> <?php echo e(__('order_preparation.save_draft')); ?>

                    </button>
                </div>

                <!-- Loading States -->
                <div wire:loading wire:target="saveDraft, scanBarcode">
                    <div class="position-fixed top-0 start-0 w-100 h-100 d-flex justify-content-center align-items-center" style="background: rgba(255,255,255,0.7); z-index: 9999;">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> <?php echo e(__('order_preparation.info')); ?></h5>
            </div>
            <div class="card-body">
                <p class="text-muted">
                    <strong><?php echo e(__('order_preparation.instructions')); ?></strong>
                </p>
                <ol class="text-muted small">
                    <li><?php echo e(__('order_preparation.instruction_1')); ?></li>
                    <li><?php echo e(__('order_preparation.instruction_2')); ?></li>
                    <li><?php echo e(__('order_preparation.instruction_3')); ?></li>
                    <li><?php echo e(__('order_preparation.instruction_4')); ?></li>
                    <li><?php echo e(__('order_preparation.instruction_5')); ?></li>
                </ol>

                <hr>

                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong><?php echo e(__('order_preparation.important')); ?></strong> <?php echo e(__('order_preparation.important_note')); ?>

                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-history"></i> <?php echo e(__('order_preparation.recent_drafts')); ?></h5>
            </div>
            <div class="card-body">
                <div id="recentDrafts">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->recentDrafts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $draft): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="draft-item mb-2 p-2 border rounded bg-light">
                            <h6 class="mb-1"><?php echo e(__('order_preparation.order')); ?> #<?php echo e($draft->id); ?></h6>
                            <small class="d-block text-muted"><?php echo e(__('order_preparation.client')); ?> <?php echo e($draft->client->client_name); ?></small>
                            <small class="d-block text-muted"><?php echo e(__('order_preparation.date')); ?> <?php echo e($draft->order_date); ?></small>
                            <small class="d-block text-muted"><?php echo e(__('order_preparation.operator')); ?> <?php echo e($draft->operario_id); ?></small>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted text-center"><?php echo e(__('order_preparation.no_recent_drafts')); ?></p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /var/www/inventory/inventory_new/resources/views/livewire/order-preparation-manager.blade.php ENDPATH**/ ?>