<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\ArticleController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\RelabelingController;
use App\Http\Controllers\ScannerController;
use App\Http\Controllers\TestController;
use App\Http\Controllers\TestRelabelingController;
use App\Http\Controllers\OrderPreparationController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\ClientHistoryController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\ConfigController;
use App\Http\Controllers\ContainerEntryController;
use App\Http\Controllers\ProductivityReportController;
use App\Http\Controllers\ClientPortalController;
use App\Http\Controllers\QZTrayController;
use App\Http\Controllers\StockSummaryController;
use App\Http\Controllers\LanguageController;

// Dashboard
Route::get('/', function () {
    return redirect()->route('login');
});



// Authentication Routes
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Test routes (temporary - remove in production)
Route::post('/test/scanner/search-article', [TestController::class, 'searchArticle'])->name('test.scanner.search-article')->withoutMiddleware(['web']);
Route::post('/test/scanner/process-scan', [TestController::class, 'processScan'])->name('test.scanner.process-scan')->withoutMiddleware(['web']);

// Test relabeling routes (temporary - remove in production)
Route::post('/test/relabeling/search-product', [TestRelabelingController::class, 'searchProduct'])->name('test.relabeling.search-product')->withoutMiddleware(['web']);
Route::post('/test/relabeling/save-product', [TestRelabelingController::class, 'saveProduct'])->name('test.relabeling.save-product')->withoutMiddleware(['web']);
Route::post('/test/relabeling/generate-zpl', [TestRelabelingController::class, 'generateZpl'])->name('test.relabeling.generate-zpl')->withoutMiddleware(['web']);
Route::get('/test/relabeling/products', [TestRelabelingController::class, 'getAllProducts'])->name('test.relabeling.products')->withoutMiddleware(['web']);
Route::delete('/test/relabeling/delete-product', [TestRelabelingController::class, 'deleteProduct'])->name('test.relabeling.delete-product')->withoutMiddleware(['web']);

// Test views (temporary - remove in production)
Route::get('/test/relabeling/{id}/edit', function ($id) {
    $relabeling = \App\Models\RelabelingProduct::findOrFail($id);
    return view('relabeling.edit', compact('relabeling'));
})->name('test.relabeling.edit')->withoutMiddleware(['web']);

Route::get('/test/relabeling/{id}', function ($id) {
    $relabeling = \App\Models\RelabelingProduct::findOrFail($id);
    return view('relabeling.show', compact('relabeling'));
})->name('test.relabeling.show')->withoutMiddleware(['web']);

// Test clients route (temporary - remove in production)
Route::get('/test/clients', function () {
    $clients = \App\Models\Client::orderBy('client_name')->paginate(20);
    return view('test-clients', compact('clients'));
})->name('test.clients')->withoutMiddleware(['web']);

// Test client edit route (temporary - remove in production)
Route::get('/test/clients/{id}/edit', function ($id) {
    $client = \App\Models\Client::findOrFail($id);
    return view('test-client-edit', compact('client'));
})->name('test.clients.edit')->withoutMiddleware(['web']);

// Test inventory edit route (temporary - remove in production)
Route::get('/test/inventory/{id}/edit', function ($id) {
    $inventory = \App\Models\Inventory::findOrFail($id);
    return view('test-inventory-edit', compact('inventory'));
})->name('test.inventory.edit')->withoutMiddleware(['web']);

// Test articles edit route (temporary - remove in production)
Route::get('/test/articles/{id}/edit', function ($id) {
    $article = \App\Models\Article::findOrFail($id);
    return view('test-article-edit', compact('article'));
})->name('test.articles.edit')->withoutMiddleware(['web']);

// Test order preparation route (temporary - remove in production)
Route::get('/test/order-preparation', function () {
    return view('test-order-preparation');
})->name('test.order-preparation')->withoutMiddleware(['web']);

// Test location assignment route (temporary - remove in production)
Route::get('/test/location', function () {
    return view('test-location');
})->name('test.location')->withoutMiddleware(['web']);

// Test client history route (temporary - remove in production)
Route::get('/test/client-history', function () {
    return view('test-client-history');
})->name('test.client-history')->withoutMiddleware(['web']);

// Test order preparation API routes (temporary - remove in production)
Route::get('/api/order-preparation/clients', [OrderPreparationController::class, 'getClients'])->withoutMiddleware(['web']);
Route::post('/api/order-preparation/save-draft', [OrderPreparationController::class, 'saveDraft'])->withoutMiddleware(['web']);
Route::get('/api/order-preparation/draft-orders', [OrderPreparationController::class, 'getDraftOrders'])->withoutMiddleware(['web']);
Route::post('/api/order-preparation/confirm-dispatch', [OrderPreparationController::class, 'confirmDispatch'])->withoutMiddleware(['web']);
Route::get('/api/order-preparation/client-orders/{clientId}', [OrderPreparationController::class, 'getClientOrders'])->withoutMiddleware(['web']);
Route::post('/api/order-preparation/validate-box', [OrderPreparationController::class, 'validateBoxOrMocaco'])->withoutMiddleware(['web']);
// Test location API routes (temporary - remove in production)
Route::post('/api/location/assign', [LocationController::class, 'assignLocation'])->withoutMiddleware(['web']);
Route::get('/api/location/locations', [LocationController::class, 'getLocations'])->withoutMiddleware(['web']);
Route::get('/api/location/items/{location}', [LocationController::class, 'getItemsByLocation'])->withoutMiddleware(['web']);
Route::get('/api/location/boxes/{location}', [LocationController::class, 'getBoxesByLocation'])->withoutMiddleware(['web']);
// Test client history API routes (temporary - remove in production)
Route::get('/api/client-history/clients', [ClientHistoryController::class, 'getClients'])->withoutMiddleware(['web']);
Route::get('/api/client-history/orders/{clientId}', [ClientHistoryController::class, 'getClientOrders'])->withoutMiddleware(['web']);
Route::get('/api/client-history/stats/{clientId}', [ClientHistoryController::class, 'getClientStats'])->withoutMiddleware(['web']);
Route::get('/api/client-history/order-details/{orderId}', [ClientHistoryController::class, 'getOrderDetails'])->withoutMiddleware(['web']);
Route::get('/api/client-history/export/{clientId}', [ClientHistoryController::class, 'exportClientHistory'])->withoutMiddleware(['web']);

// Protected Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    Route::resource('brands', BrandController::class);

    Route::post('/language-switch', [LanguageController::class, 'switch'])->name('language.switch');
    // Inventory API Routes (debe ir ANTES de la resource route)
    Route::post('/inventory/search', [InventoryController::class, 'search'])->name('inventory.search');
    Route::get('/inventory/filter-options', [InventoryController::class, 'getFilterOptions'])->name('inventory.filter-options');
    Route::put('/inventory/update-field', [InventoryController::class, 'updateField'])->name('inventory.update-field');
    Route::delete('/inventory/delete', [InventoryController::class, 'delete'])->name('inventory.delete');
    Route::get('/inventory/export', [InventoryController::class, 'export'])->name('inventory.export');
    Route::get('/inventory/export-grouped', [InventoryController::class, 'exportGrouped'])->name('inventory.export-grouped');
    Route::get('/inventory/export-by-brand', [InventoryController::class, 'exportByBrand'])->name('inventory.export-by-brand');

    // Inventory Routes
    // Cajas sin ubicación
    Route::get('inventory/boxes-without-location', [App\Http\Controllers\InventoryController::class, 'boxesWithoutLocation'])
        ->name('inventory.boxes-without-location')
        ->middleware('permission:inventory.view');

    Route::resource('inventory', InventoryController::class)
        ->middleware('permission:inventory.view|inventory.create|inventory.update|inventory.delete');

    // Article Routes
    Route::resource('articles', ArticleController::class)
        ->middleware('permission:articles.view|articles.create|articles.update|articles.delete');
    Route::post('/articles/import', [ArticleController::class, 'import'])->name('articles.import')
        ->middleware('permission:articles.create');
    Route::get('/articles/import/sample', [ArticleController::class, 'importSample'])->name('articles.import-sample')
        ->middleware('permission:articles.create');

    // Client Routes
    Route::resource('clients', ClientController::class)
        ->middleware('permission:clients.view|clients.create|clients.update|clients.delete');

    // Order Routes (la ruta específica debe ir ANTES del resource)
    Route::get('/orders/export', [OrderController::class, 'export'])->name('orders.export')
        ->middleware('permission:orders.view');
    Route::get('/orders/{order}/export', [OrderController::class, 'exportOrder'])->name('orders.export-order')
        ->middleware('permission:orders.view');
    Route::get('/orders/{order}/invoice', [OrderController::class, 'downloadInvoice'])->name('orders.download-invoice')
        ->middleware('permission:orders.view');
    Route::get('/orders/reservations/template', [OrderController::class, 'downloadReservationsTemplate'])->name('orders.reservations-template')
        ->middleware('permission:orders.view');
    Route::post('/orders/import-reservations', [OrderController::class, 'importReservations'])->name('orders.import-reservations')
        ->middleware('permission:orders.create');
    Route::resource('orders', OrderController::class)
        ->middleware('permission:orders.view|orders.create|orders.update|orders.delete|orders.dispatch');

    // Relabeling Routes
    Route::resource('relabeling', RelabelingController::class)
        ->middleware('permission:relabeling.view|relabeling.create|relabeling.print');
    Route::post('/relabeling/search-product', [RelabelingController::class, 'searchProduct'])->name('relabeling.search-product')
        ->middleware('permission:relabeling.view');
    Route::post('/relabeling/save-product', [RelabelingController::class, 'saveProduct'])->name('relabeling.save-product')
        ->middleware('permission:relabeling.create');

    // Scanner Routes (requiere permisos de escaneo)
    Route::get('/scanner', [ScannerController::class, 'index'])->name('scanner')
        ->middleware('permission:inventory.scan');
    Route::post('/scanner/search-article', [ScannerController::class, 'searchArticle'])->name('scanner.search-article')
        ->middleware('permission:inventory.scan');
    Route::post('/scanner/process-scan', [ScannerController::class, 'processScan'])->name('scanner.process-scan')
        ->middleware('permission:inventory.scan|inventory.create');
    Route::post('/scanner/get-box-content', [ScannerController::class, 'getBoxContent'])->name('scanner.get-box-content')
        ->middleware('permission:inventory.view');
    Route::post('/scanner/create-article', [ScannerController::class, 'createArticle'])->name('scanner.create-article')
        ->middleware('permission:articles.create');
    Route::post('/scanner/generate-next-box-number', [ScannerController::class, 'generateNextBoxNumber'])->name('scanner.generate-next-box-number')
        ->middleware('permission:inventory.scan');
    Route::post('/scanner/delete-last-scanned', [ScannerController::class, 'deleteLastScannedItem'])->name('scanner.delete-last-scanned')
        ->middleware('permission:inventory.scan|inventory.delete');
    Route::get('/scanner/alerts', [ScannerController::class, 'getAlerts'])->name('scanner.get-alerts')
        ->middleware('role:admin');
    Route::post('/scanner/alerts', [ScannerController::class, 'saveAlert'])->name('scanner.save-alert')
        ->middleware('role:admin');
    Route::delete('/scanner/alerts/{id}', [ScannerController::class, 'deleteAlert'])->name('scanner.delete-alert')
        ->middleware('role:admin');
    Route::post('/scanner/check-alerts', [ScannerController::class, 'checkAlerts'])->name('scanner.check-alerts')
        ->middleware('permission:inventory.scan'); // Esta ruta puede ser usada por todos para verificar alertas al escanear
    Route::post('/scanner/delete-scanned-item', [ScannerController::class, 'deleteScannedItem'])->name('scanner.delete-scanned-item')
        ->middleware('permission:inventory.scan|inventory.delete');
    Route::post('/scanner/empty-box', [ScannerController::class, 'emptyBox'])->name('scanner.empty-box')
        ->middleware('permission:inventory.scan|inventory.delete');

    // API Routes for Scanner
    Route::get('/api/current-container', [ScannerController::class, 'getCurrentContainer'])->name('api.current-container');
    Route::post('/scanner/generate-box-label-zpl', [ScannerController::class, 'generateBoxLabelZpl'])->name('scanner.generate-box-label-zpl');
    Route::post('/scanner/generate-box-label-pdf', [ScannerController::class, 'generateBoxLabelPdf'])->name('scanner.generate-box-label-pdf');
    Route::post('/scanner/generate-contenu-du-colis-pdf', [ScannerController::class, 'generateContenuDuColisPdf'])->name('scanner.generate-contenu-du-colis-pdf');
    Route::post('/scanner/find-box-reprint', [ScannerController::class, 'findBoxForReprint'])->name('scanner.find-box-reprint');

    // Order Preparation Routes
    Route::get('/order-preparation', [OrderPreparationController::class, 'index'])->name('order-preparation')
        ->middleware('permission:order-preparation.view');
    Route::get('/api/order-preparation/clients', [OrderPreparationController::class, 'getClients'])->name('order-preparation.clients')
        ->middleware('permission:order-preparation.view');
    Route::post('/api/order-preparation/validate-box', [OrderPreparationController::class, 'validateBoxOrMocaco'])->name('order-preparation.validate-box')
        ->middleware('permission:order-preparation.view');
    Route::post('/api/order-preparation/save-draft', [OrderPreparationController::class, 'saveDraft'])->name('order-preparation.save-draft')
        ->middleware('permission:order-preparation.create');
    Route::get('/api/order-preparation/draft-orders', [OrderPreparationController::class, 'getDraftOrders'])->name('order-preparation.draft-orders')
        ->middleware('permission:order-preparation.view');
    Route::post('/api/order-preparation/confirm-dispatch', [OrderPreparationController::class, 'confirmDispatch'])->name('order-preparation.confirm-dispatch')
        ->middleware('permission:order-preparation.dispatch');
    Route::get('/api/order-preparation/client-orders/{clientId}', [OrderPreparationController::class, 'getClientOrders'])->name('order-preparation.client-orders')
        ->middleware('permission:order-preparation.view');
    Route::get('/api/order-preparation/reserved-orders', [OrderPreparationController::class, 'getReservedOrders'])->name('order-preparation.reserved-orders')
        ->middleware('permission:order-preparation.view');
    Route::get('/api/order-preparation/reserved-order/{orderId}', [OrderPreparationController::class, 'loadReservedOrder'])->name('order-preparation.load-reserved-order')
        ->middleware('permission:order-preparation.view');
    Route::post('/api/order-preparation/confirm-reserved-order', [OrderPreparationController::class, 'confirmReservedOrder'])->name('order-preparation.confirm-reserved-order')
        ->middleware('permission:order-preparation.dispatch');
    Route::post('/api/order-preparation/validate-reserved-box', [OrderPreparationController::class, 'validateReservedBox'])->name('order-preparation.validate-reserved-box')
        ->middleware('permission:order-preparation.view');

    // Location Assignment Routes
    Route::get('/location', [LocationController::class, 'index'])->name('location')
        ->middleware('permission:location.view');
    Route::post('/location/assign', [LocationController::class, 'assignLocation'])->name('location.assign')
        ->middleware('permission:location.assign');
    Route::get('/api/location/locations', [LocationController::class, 'getLocations'])->name('location.locations')
        ->middleware('permission:location.view');
    Route::get('/api/location/items/{location}', [LocationController::class, 'getItemsByLocation'])->name('location.items')
        ->middleware('permission:location.view');
    Route::get('/api/location/boxes/{location}', [LocationController::class, 'getBoxesByLocation'])->name('location.boxes')
        ->middleware('permission:location.view');

    // Client History Routes
    Route::get('/client-history', [ClientHistoryController::class, 'index'])->name('client-history')
        ->middleware('permission:client-history.view');
    Route::get('/api/client-history/clients', [ClientHistoryController::class, 'getClients'])->name('client-history.clients')
        ->middleware('permission:client-history.view');
    Route::get('/api/client-history/orders/{clientId}', [ClientHistoryController::class, 'getClientOrders'])->name('client-history.orders')
        ->middleware('permission:client-history.view');
    Route::get('/api/client-history/stats/{clientId}', [ClientHistoryController::class, 'getClientStats'])->name('client-history.stats')
        ->middleware('permission:client-history.view');
    Route::get('/api/client-history/order-details/{orderId}', [ClientHistoryController::class, 'getOrderDetails'])->name('client-history.order-details')
        ->middleware('permission:client-history.view');
    Route::get('/api/client-history/export/{clientId}', [ClientHistoryController::class, 'exportClientHistory'])->name('client-history.export')
        ->middleware('permission:client-history.export');

    // User Routes (solo admin puede gestionar usuarios)
    Route::resource('users', UserController::class)
        ->middleware('permission:users.view|users.create|users.update|users.delete');

    // Role Routes (solo admin puede gestionar roles)
    Route::resource('roles', RoleController::class)
        ->middleware('role:admin');

    // Config Routes (solo admin)
    Route::resource('config', ConfigController::class)
        ->middleware('role:admin')
        ->parameters([
            'config' => 'config'
        ]);

    // Scanner Options Routes (solo admin)
    Route::resource('scanner-options', \App\Http\Controllers\ScannerOptionController::class);

    // Container Entry Routes (Gestión de Entradas de Contenedores)
    // Rutas específicas DEBEN ir antes del resource para evitar colisiones con {containerEntry}
    Route::get('container-entries/theoretical-template', [ContainerEntryController::class, 'downloadTheoreticalTemplate'])->name('container-entries.theoretical-template')
        ->middleware('permission:container-entries.view');
    Route::get('container-entries/inventory-template', [ContainerEntryController::class, 'downloadInventoryTemplate'])->name('container-entries.inventory-template')
        ->middleware('permission:container-entries.view');
    Route::get('container-entries/export/unprocessed', [ContainerEntryController::class, 'exportUnprocessed'])->name('container-entries.export-unprocessed')
        ->middleware('permission:container-entries.export');

    Route::resource('container-entries', ContainerEntryController::class)
        ->middleware('permission:container-entries.view|container-entries.create|container-entries.update|container-entries.delete');
    Route::post('container-entries/{containerEntry}/assign-user', [ContainerEntryController::class, 'assignUser'])->name('container-entries.assign-user')
        ->middleware('permission:container-entries.assign');
    Route::post('container-entries/{containerEntry}/assign-users', [ContainerEntryController::class, 'assignUsers'])->name('container-entries.assign-users')
        ->middleware('permission:container-entries.assign');
    Route::post('container-entries/{containerEntry}/upload-theoretical', [ContainerEntryController::class, 'uploadTheoreticalArticles'])->name('container-entries.upload-theoretical')
        ->middleware('permission:container-entries.upload');
    Route::post('container-entries/{containerEntry}/upload-inventory', [ContainerEntryController::class, 'uploadInventory'])->name('container-entries.upload-inventory')
        ->middleware('permission:container-entries.upload');
    Route::post('container-entries/{containerEntry}/finalize', [ContainerEntryController::class, 'finalize'])->name('container-entries.finalize')
        ->middleware('permission:container-entries.finalize');
    Route::get('container-entries/{containerEntry}/discrepancy-report', [ContainerEntryController::class, 'discrepancyReport'])->name('container-entries.discrepancy-report')
        ->middleware('permission:container-entries.view');
    Route::get('container-entries/{containerEntry}/progress', [ContainerEntryController::class, 'progress'])->name('container-entries.progress')
        ->middleware('permission:container-entries.view');
    Route::get('container-entries/{containerEntry}/import-progress', [ContainerEntryController::class, 'importProgress'])->name('container-entries.import-progress')
        ->middleware('permission:container-entries.view');

    // Box Reservations Routes (Reserva de Cajas)
    Route::get('reservations', [\App\Http\Controllers\ReservationController::class, 'index'])->name('reservations.index')
        ->middleware('permission:reservations.view');
    Route::get('reservations/create', [\App\Http\Controllers\ReservationController::class, 'create'])->name('reservations.create')
        ->middleware('permission:reservations.create');
    Route::post('reservations', [\App\Http\Controllers\ReservationController::class, 'store'])->name('reservations.store')
        ->middleware('permission:reservations.create');
    Route::get('reservations/template/download', [\App\Http\Controllers\ReservationController::class, 'downloadTemplate'])->name('reservations.template')
        ->middleware('permission:reservations.view');
    Route::get('reservations/inventory/available', [\App\Http\Controllers\ReservationController::class, 'downloadAvailableInventory'])->name('reservations.available-inventory')
        ->middleware('permission:reservations.view');
    Route::get('reservations/{reservation}', [\App\Http\Controllers\ReservationController::class, 'show'])->name('reservations.show')
        ->middleware('permission:reservations.view');
    Route::post('reservations/{reservation}/import', [\App\Http\Controllers\ReservationController::class, 'importBoxes'])->name('reservations.import')
        ->middleware('permission:reservations.import');
    Route::delete('reservations/{reservation}/cancel', [\App\Http\Controllers\ReservationController::class, 'cancel'])->name('reservations.cancel')
        ->middleware('permission:reservations.cancel');
    Route::delete('reservations/{reservation}/items/{item}', [\App\Http\Controllers\ReservationController::class, 'removeBox'])->name('reservations.remove-box')
        ->middleware('permission:reservations.update');
    Route::post('reservations/{reservation}/items', [\App\Http\Controllers\ReservationController::class, 'addBox'])->name('reservations.add-box')
        ->middleware('permission:reservations.update');
    Route::put('reservations/{reservation}', [\App\Http\Controllers\ReservationController::class, 'update'])->name('reservations.update')
        ->middleware('permission:reservations.update');

    // Box Reservation APIs for Order Preparation
    Route::get('/api/order-preparation/box-reservations', [OrderPreparationController::class, 'getBoxReservations'])->name('order-preparation.box-reservations')
        ->middleware('permission:order-preparation.view');
    Route::post('/api/order-preparation/start-box-reservation', [OrderPreparationController::class, 'startBoxReservation'])->name('order-preparation.start-box-reservation')
        ->middleware('permission:order-preparation.view');
    Route::post('/api/order-preparation/confirm-box-scan', [OrderPreparationController::class, 'confirmBoxReservationScan'])->name('order-preparation.confirm-box-scan')
        ->middleware('permission:order-preparation.view');
    Route::post('/api/order-preparation/add-extra-box', [OrderPreparationController::class, 'addExtraBoxToReservation'])->name('order-preparation.add-extra-box')
        ->middleware('permission:order-preparation.create');
    Route::post('/api/order-preparation/complete-box-reservation', [OrderPreparationController::class, 'completeBoxReservation'])->name('order-preparation.complete-box-reservation')
        ->middleware('permission:order-preparation.dispatch');
    Route::post('/api/order-preparation/cancel-box-reservation', [OrderPreparationController::class, 'cancelBoxReservation'])->name('order-preparation.cancel-box-reservation')
        ->middleware('permission:order-preparation.view');
    Route::post('/api/order-preparation/remove-box-reservation', [OrderPreparationController::class, 'removeBoxFromReservation'])->name('order-preparation.remove-box-reservation')
        ->middleware('permission:order-preparation.create');
    Route::post('/api/order-preparation/update-reservation-details', [OrderPreparationController::class, 'updateReservationDetails'])->name('order-preparation.update-reservation-details')
        ->middleware('permission:order-preparation.create');


    // Article Review Routes (Revisión de Artículos Sin Info)
    Route::get('article-review', [App\Http\Controllers\ArticleReviewController::class, 'index'])->name('article-review.index')
        ->middleware('permission:inventory.view');
    Route::get('article-review/{inventory}/suggestions', [App\Http\Controllers\ArticleReviewController::class, 'getSuggestions'])->name('article-review.suggestions')
        ->middleware('permission:inventory.view');
    Route::post('article-review/{inventory}/update', [App\Http\Controllers\ArticleReviewController::class, 'updateArticle'])->name('article-review.update')
        ->middleware('permission:inventory.update');
    Route::post('article-review/bulk-update', [App\Http\Controllers\ArticleReviewController::class, 'bulkUpdate'])->name('article-review.bulk-update')
        ->middleware('permission:inventory.update');

    // Reportes
    Route::get('reports/productivity', [ProductivityReportController::class, 'index'])->name('reports.productivity')
        ->middleware('permission:reports.productivity.view');
    Route::get('reports/productivity/export', [ProductivityReportController::class, 'export'])->name('reports.productivity.export')
        ->middleware('permission:reports.productivity.export');
    Route::get('reports/stock-summary', [StockSummaryController::class, 'index'])->name('reports.stock-summary')
        ->middleware('permission:reports.stock.view');

    // Portal de Clientes (acceso restringido)
    Route::middleware(['auth', 'client.access'])->prefix('portal')->name('portal.')->group(function () {
        Route::get('/', [ClientPortalController::class, 'index'])->name('index');
        Route::get('/orders/{order}', [ClientPortalController::class, 'show'])->name('show');
        Route::get('/orders/{order}/invoice', [ClientPortalController::class, 'downloadInvoice'])->name('download-invoice');
        Route::get('/orders/{order}/excel', [ClientPortalController::class, 'downloadOrderExcel'])->name('download-excel');
    });

    // QZ Tray - Firma de certificados
    Route::post('/api/qz/sign', [QZTrayController::class, 'sign'])->name('qz.sign');
});
