@extends('layouts.app')

@section('title', __('users.view'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user"></i> {{ __('users.view') }}</h2>
    <a href="{{ route('users.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('users.back') }}
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('users.show.personal_info') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ __('users.show.id') }}</strong> {{ $user->id }}</p>
                        <p><strong>{{ __('users.show.name') }}</strong> {{ $user->name }}</p>
                        <p><strong>{{ __('users.show.email') }}</strong> {{ $user->email }}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ __('users.show.operario_id') }}</strong> {{ $user->operario_id ?? 'N/A' }}</p>
                        <p><strong>{{ __('users.show.status') }}</strong> 
                            <span class="badge badge-{{ $user->is_active ? 'success' : 'danger' }}">
                                {{ $user->is_active ? __('users.status.active') : __('users.status.inactive') }}
                            </span>
                        </p>
                        <p><strong>{{ __('users.show.registration_date') }}</strong> {{ $user->created_at->format('d/m/Y H:i') }}</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-user-tag"></i> {{ __('users.show.roles_permissions') }}</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>{{ __('users.show.roles_label') }}</strong>
                    <div class="mt-2">
                        @foreach($user->roles as $role)
                            <span class="badge badge-info">{{ ucfirst($role->name) }}</span>
                        @endforeach
                    </div>
                </div>
                
                <div>
                    <strong>{{ __('users.show.permissions_label') }}</strong>
                    <div class="mt-2">
                        @foreach($user->getAllPermissions() as $permission)
                            <span class="badge badge-secondary">{{ $permission->name }}</span>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-cog"></i> {{ __('users.show.actions') }}</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('users.edit', $user) }}" class="btn">
                        <i class="fas fa-edit"></i> {{ __('users.show.edit_user') }}
                    </a>
                    @if($user->id !== auth()->id())
                        <form action="{{ route('users.destroy', $user) }}" method="POST" onsubmit="return confirm('{{ __('users.messages.delete_confirm') }}')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger w-100">
                                <i class="fas fa-trash"></i> {{ __('users.show.delete_user') }}
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-chart-line"></i> {{ __('users.show.statistics') }}</h5>
            </div>
            <div class="card-body">
                <p><strong>{{ __('users.show.orders_created') }}</strong> {{ $user->orders->count() }}</p>
                <p><strong>{{ __('users.show.total_roles') }}</strong> {{ $user->roles->count() }}</p>
                <p><strong>{{ __('users.show.total_permissions') }}</strong> {{ $user->getAllPermissions()->count() }}</p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.badge {
    padding: 4px 8px;
    font-size: 0.75em;
    font-weight: 500;
    border-radius: 4px;
    margin: 2px;
}

.badge-info {
    background-color: #17a2b8;
    color: white;
}

.badge-secondary {
    background-color: #6c757d;
    color: white;
}

.badge-success {
    background-color: #28a745;
    color: white;
}

.badge-danger {
    background-color: #dc3545;
    color: white;
}

.gap-2 {
    gap: 10px;
}

.d-grid {
    display: grid;
}

.w-100 {
    width: 100%;
}
</style>
@endpush

