<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Inventario - {{ $inventory->id }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .card { box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075); }
        .form-control { border: 1px solid #ced4da; border-radius: 4px; padding: 10px; font-size: 0.9em; }
        .form-control:focus { border-color: #3498db; outline: none; box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2); }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-edit text-primary"></i> Editar Inventario</h2>
                    <div class="d-flex gap-2">
                        <a href="/test/clients" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Volver
                        </a>
                        <span class="badge bg-info fs-6">ID: {{ $inventory->id }}</span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-edit"></i> Información del Item</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="#" id="inventoryForm">
                                    @csrf
                                    @method('PUT')
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="full_barcode" class="form-label">Código de Barras *</label>
                                                <input type="text" class="form-control" id="full_barcode" name="full_barcode" 
                                                       value="{{ $inventory->full_barcode }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="mocaco" class="form-label">MOCACO *</label>
                                                <input type="text" class="form-control" id="mocaco" name="mocaco" 
                                                       value="{{ $inventory->mocaco }}" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="n_carton" class="form-label">Número de Caja *</label>
                                                <input type="text" class="form-control" id="n_carton" name="n_carton" 
                                                       value="{{ $inventory->n_carton }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="season_int" class="form-label">Temporada</label>
                                                <input type="text" class="form-control" id="season_int" name="season_int" 
                                                       value="{{ $inventory->season_int }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="ubicacion" class="form-label">Ubicación</label>
                                                <input type="text" class="form-control" id="ubicacion" name="ubicacion" 
                                                       value="{{ $inventory->ubicacion }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="n_id_operario" class="form-label">ID Operario</label>
                                                <input type="text" class="form-control" id="n_id_operario" name="n_id_operario" 
                                                       value="{{ $inventory->n_id_operario }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="categoria_seleccionada" class="form-label">Categoría</label>
                                                <input type="text" class="form-control" id="categoria_seleccionada" name="categoria_seleccionada" 
                                                       value="{{ $inventory->categoria_seleccionada }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="famillie_usuario" class="form-label">Familia</label>
                                                <input type="text" class="form-control" id="famillie_usuario" name="famillie_usuario" 
                                                       value="{{ $inventory->famillie_usuario }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="cadena" class="form-label">Cadena</label>
                                                <input type="text" class="form-control" id="cadena" name="cadena" 
                                                       value="{{ $inventory->cadena }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="precio_pvp_maximo_temporada" class="form-label">Precio PVP Máximo</label>
                                                <input type="number" step="0.01" class="form-control" id="precio_pvp_maximo_temporada" 
                                                       name="precio_pvp_maximo_temporada" value="{{ $inventory->precio_pvp_maximo_temporada }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="notes" class="form-label">Notas</label>
                                        <textarea class="form-control" id="notes" name="notes" rows="3">{{ $inventory->notes }}</textarea>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="detail_usuario" class="form-label">Detalle Usuario</label>
                                        <textarea class="form-control" id="detail_usuario" name="detail_usuario" rows="2">{{ $inventory->detail_usuario }}</textarea>
                                    </div>

                                    <div class="d-flex justify-content-end gap-2">
                                        <a href="/test/clients" class="btn btn-secondary">
                                            <i class="fas fa-times"></i> Cancelar
                                        </a>
                                        <button type="button" class="btn btn-primary" onclick="saveInventory()">
                                            <i class="fas fa-save"></i> Actualizar Item
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-info-circle"></i> Información del Item</h5>
                            </div>
                            <div class="card-body">
                                <p><strong>ID:</strong> {{ $inventory->id }}</p>
                                <p><strong>Creado:</strong> {{ $inventory->created_at->format('d/m/Y H:i') }}</p>
                                <p><strong>Actualizado:</strong> {{ $inventory->updated_at->format('d/m/Y H:i') }}</p>
                                @if($inventory->fecha_escaneo)
                                    <p><strong>Fecha Escaneo:</strong> {{ $inventory->fecha_escaneo->format('d/m/Y H:i') }}</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('full_barcode').focus();
        });

        function saveInventory() {
            alert('Funcionalidad de guardado implementada en la versión completa del sistema.');
            const formData = new FormData(document.getElementById('inventoryForm'));
            console.log('Datos del formulario:', Object.fromEntries(formData));
        }
    </script>
</body>
</html>
