<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Clientes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .card {
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        }
        .table th {
            background-color: #e9ecef;
            border-top: none;
        }
        .status-badge {
            font-size: 0.75rem;
        }
        .client-info {
            font-size: 0.9rem;
        }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-handshake text-primary"></i> Lista de Clientes</h2>
                    <div class="d-flex gap-2">
                        <span class="badge bg-primary fs-6">{{ $clients->total() }} clientes</span>
                        <a href="/test/clients" class="btn btn-outline-secondary btn-sm">
                            <i class="fas fa-sync"></i> Actualizar
                        </a>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-list"></i> Clientes Registrados</h5>
                    </div>
                    <div class="card-body p-0">
                        @if($clients->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Empresa</th>
                                            <th>Contacto</th>
                                            <th>Email</th>
                                            <th>Teléfono</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($clients as $client)
                                            <tr>
                                                <td class="fw-bold">{{ $client->id }}</td>
                                                <td>
                                                    <div class="client-info">
                                                        <strong>{{ $client->client_name }}</strong>
                                                        @if($client->address)
                                                            <br><small class="text-muted">{{ Str::limit($client->address, 50) }}</small>
                                                        @endif
                                                    </div>
                                                </td>
                                                <td>{{ $client->contact_person }}</td>
                                                <td>
                                                    @if($client->email)
                                                        <a href="mailto:{{ $client->email }}" class="text-decoration-none">
                                                            {{ $client->email }}
                                                        </a>
                                                    @else
                                                        <span class="text-muted">No especificado</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($client->phone)
                                                        <a href="tel:{{ $client->phone }}" class="text-decoration-none">
                                                            {{ $client->phone }}
                                                        </a>
                                                    @else
                                                        <span class="text-muted">No especificado</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($client->is_active)
                                                        <span class="badge bg-success status-badge">
                                                            <i class="fas fa-check"></i> Activo
                                                        </span>
                                                    @else
                                                        <span class="badge bg-danger status-badge">
                                                            <i class="fas fa-times"></i> Inactivo
                                                        </span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-sm" role="group">
                                                        <button type="button" class="btn btn-outline-primary" 
                                                                onclick="showClientDetails({{ $client->id }})">
                                                            <i class="fas fa-eye"></i>
                                                        </button>
                                                        <button type="button" class="btn btn-outline-secondary" 
                                                                onclick="editClient({{ $client->id }})">
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Paginación -->
                            @if($clients->hasPages())
                                <div class="card-footer">
                                    {{ $clients->links() }}
                                </div>
                            @endif
                        @else
                            <div class="text-center py-5">
                                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">No hay clientes registrados</h5>
                                <p class="text-muted">Los clientes aparecerán aquí una vez que se agreguen al sistema.</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Estadísticas -->
                <div class="row mt-4">
                    <div class="col-md-4">
                        <div class="card text-center">
                            <div class="card-body">
                                <i class="fas fa-users fa-2x text-primary mb-2"></i>
                                <h4 class="card-title">{{ $clients->total() }}</h4>
                                <p class="card-text text-muted">Total de Clientes</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card text-center">
                            <div class="card-body">
                                <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                                <h4 class="card-title">{{ $clients->where('is_active', true)->count() }}</h4>
                                <p class="card-text text-muted">Clientes Activos</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card text-center">
                            <div class="card-body">
                                <i class="fas fa-times-circle fa-2x text-danger mb-2"></i>
                                <h4 class="card-title">{{ $clients->where('is_active', false)->count() }}</h4>
                                <p class="card-text text-muted">Clientes Inactivos</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal para detalles del cliente -->
    <div class="modal fade" id="clientModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Detalles del Cliente</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="clientDetails">
                    <!-- Los detalles se cargarán aquí -->
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function showClientDetails(clientId) {
            // En una implementación real, aquí harías una llamada AJAX para obtener los detalles
            document.getElementById('clientDetails').innerHTML = `
                <div class="text-center py-4">
                    <i class="fas fa-spinner fa-spin fa-2x text-primary mb-3"></i>
                    <p>Cargando detalles del cliente ID: ${clientId}</p>
                    <p class="text-muted small">Esta funcionalidad se implementará en la versión completa del sistema.</p>
                </div>
            `;
            
            const modal = new bootstrap.Modal(document.getElementById('clientModal'));
            modal.show();
        }

        function editClient(clientId) {
            alert(`Editar cliente ID: ${clientId}\n\nEsta funcionalidad se implementará en la versión completa del sistema.`);
        }

        // Auto-refresh cada 30 segundos
        setTimeout(() => {
            location.reload();
        }, 30000);
    </script>
</body>
</html>
