<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Artículo - {{ $article->mocaco }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .card { box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075); }
        .form-control { border: 1px solid #ced4da; border-radius: 4px; padding: 10px; font-size: 0.9em; }
        .form-control:focus { border-color: #3498db; outline: none; box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2); }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-edit text-primary"></i> Editar Artículo</h2>
                    <div class="d-flex gap-2">
                        <a href="/test/clients" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Volver
                        </a>
                        <span class="badge bg-info fs-6">MOCACO: {{ $article->mocaco }}</span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-edit"></i> Información del Artículo</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="#" id="articleForm">
                                    @csrf
                                    @method('PUT')
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="mocaco" class="form-label">MOCACO *</label>
                                                <input type="text" class="form-control" id="mocaco" name="mocaco" 
                                                       value="{{ $article->mocaco }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="seccion" class="form-label">Sección</label>
                                                <input type="text" class="form-control" id="seccion" name="seccion" 
                                                       value="{{ $article->seccion }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="familia" class="form-label">Familia</label>
                                                <input type="text" class="form-control" id="familia" name="familia" 
                                                       value="{{ $article->familia }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="cadena" class="form-label">Cadena</label>
                                                <input type="text" class="form-control" id="cadena" name="cadena" 
                                                       value="{{ $article->cadena }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="mercado_origen_articulo" class="form-label">Mercado Origen</label>
                                                <input type="text" class="form-control" id="mercado_origen_articulo" name="mercado_origen_articulo" 
                                                       value="{{ $article->mercado_origen_articulo }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="precio_pvp_maximo_temporada" class="form-label">Precio PVP Máximo</label>
                                                <input type="number" step="0.01" class="form-control" id="precio_pvp_maximo_temporada" 
                                                       name="precio_pvp_maximo_temporada" value="{{ $article->precio_pvp_maximo_temporada }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="partida_arancelaria" class="form-label">Partida Arancelaria</label>
                                                <input type="text" class="form-control" id="partida_arancelaria" name="partida_arancelaria" 
                                                       value="{{ $article->partida_arancelaria }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="campana" class="form-label">Campaña</label>
                                                <input type="text" class="form-control" id="campana" name="campana" 
                                                       value="{{ $article->campana }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="peso_unitario" class="form-label">Peso Unitario</label>
                                                <input type="number" step="0.001" class="form-control" id="peso_unitario" 
                                                       name="peso_unitario" value="{{ $article->peso_unitario }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="grupo_arancelario" class="form-label">Grupo Arancelario</label>
                                                <input type="text" class="form-control" id="grupo_arancelario" name="grupo_arancelario" 
                                                       value="{{ $article->grupo_arancelario }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="composition" class="form-label">Composición</label>
                                        <textarea class="form-control" id="composition" name="composition" rows="3">{{ $article->composition }}</textarea>
                                    </div>

                                    <div class="d-flex justify-content-end gap-2">
                                        <a href="/test/clients" class="btn btn-secondary">
                                            <i class="fas fa-times"></i> Cancelar
                                        </a>
                                        <button type="button" class="btn btn-primary" onclick="saveArticle()">
                                            <i class="fas fa-save"></i> Actualizar Artículo
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-info-circle"></i> Información del Artículo</h5>
                            </div>
                            <div class="card-body">
                                <p><strong>ID:</strong> {{ $article->id }}</p>
                                <p><strong>MOCACO:</strong> {{ $article->mocaco }}</p>
                                <p><strong>Creado:</strong> {{ $article->created_at->format('d/m/Y H:i') }}</p>
                                <p><strong>Actualizado:</strong> {{ $article->updated_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('mocaco').focus();
        });

        function saveArticle() {
            alert('Funcionalidad de guardado implementada en la versión completa del sistema.');
            const formData = new FormData(document.getElementById('articleForm'));
            console.log('Datos del formulario:', Object.fromEntries(formData));
        }
    </script>
</body>
</html>
