@extends('layouts.app')

@section('title', 'Nueva Opción')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-plus"></i> Nueva Opción</h2>
        <a href="{{ route('scanner-options.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('scanner-options.store') }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label for="type" class="form-label">Tipo</label>
                    <select class="form-control @error('type') is-invalid @enderror" id="type" name="type" required>
                        <option value="">Seleccionar tipo...</option>
                        <option value="season" {{ old('type') == 'season' ? 'selected' : '' }}>Season (Temporada)</option>
                        <option value="category" {{ old('type') == 'category' ? 'selected' : '' }}>Category (Categoría)
                        </option>
                        <option value="family" {{ old('type') == 'family' ? 'selected' : '' }}>Family (Familia)</option>
                        <option value="detail" {{ old('type') == 'detail' ? 'selected' : '' }}>Detail (Detalle)</option>
                        <option value="brand" {{ old('type') == 'brand' ? 'selected' : '' }}>Brand (Marca)</option>
                        <option value="section" {{ old('type') == 'section' ? 'selected' : '' }}>Section (Sección)
                        </option>
                    </select>
                    @error('type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="value" class="form-label">Valor (Interno)</label>
                    <input type="text" class="form-control @error('value') is-invalid @enderror" id="value"
                        name="value" value="{{ old('value') }}">
                    <div class="form-text">Este es el valor que se guardará en la base de datos.</div>
                    @error('value')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="label" class="form-label">Etiqueta (Visible)</label>
                    <input type="text" class="form-control @error('label') is-invalid @enderror" id="label"
                        name="label" value="{{ old('label') }}" required>
                    <div class="form-text">Este es el texto que verá el usuario en el desplegable.</div>
                    @error('label')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3 form-check">
                    <input type="checkbox" class="form-check-input" id="active" name="active" value="1"
                        {{ old('active', true) ? 'checked' : '' }}>
                    <label class="form-check-label" for="active">Activo</label>
                </div>

                <button type="submit" class="btn btn-primary">Guardar</button>
            </form>
        </div>
    </div>
@endsection
