@extends('layouts.app')

@section('title', __('roles.view'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-tag"></i> {{ __('roles.view') }}</h2>
    <a href="{{ route('roles.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('roles.back') }}
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('roles.info.role_info') }}</h5>
            </div>
            <div class="card-body">
                <p><strong>{{ __('roles.show.id') }}</strong> {{ $role->id }}</p>
                <p><strong>{{ __('roles.show.name') }}</strong> {{ ucfirst($role->name) }}</p>
                <p><strong>{{ __('roles.show.guard') }}</strong> {{ $role->guard_name }}</p>
                <p><strong>{{ __('roles.show.created') }}</strong> {{ $role->created_at->format('d/m/Y H:i') }}</p>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-key"></i> {{ __('roles.show.permissions_assigned') }} ({{ $role->permissions->count() }})</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($role->permissions as $permission)
                        <div class="col-md-6 mb-2">
                            <span class="badge badge-info">{{ $permission->name }}</span>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-users"></i> {{ __('roles.show.users_with_role') }} ({{ $role->users->count() }})</h5>
            </div>
            <div class="card-body">
                @if($role->users->count() > 0)
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>{{ __('roles.show.user_id') }}</th>
                                    <th>{{ __('roles.show.user_name') }}</th>
                                    <th>{{ __('roles.show.user_email') }}</th>
                                    <th>{{ __('roles.show.user_status') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($role->users as $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>{{ $user->name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td>
                                            <span class="badge badge-{{ $user->is_active ? 'success' : 'danger' }}">
                                                {{ $user->is_active ? __('roles.status.active') : __('roles.status.inactive') }}
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="text-muted">{{ __('roles.show.no_users') }}</p>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-cog"></i> {{ __('roles.show.actions') }}</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('roles.edit', $role) }}" class="btn">
                        <i class="fas fa-edit"></i> {{ __('roles.show.edit_role') }}
                    </a>
                    @if(!in_array($role->name, ['admin', 'manager', 'operator', 'scanner', 'viewer']))
                        <form action="{{ route('roles.destroy', $role) }}" method="POST" onsubmit="return confirm('{{ __('roles.messages.delete_confirm') }}')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger w-100">
                                <i class="fas fa-trash"></i> {{ __('roles.show.delete_role') }}
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('roles.show.statistics') }}</h5>
            </div>
            <div class="card-body">
                <p><strong>{{ __('roles.show.total_permissions') }}</strong> {{ $allPermissions->count() }}</p>
                <p><strong>{{ __('roles.show.assigned_permissions') }}</strong> {{ $role->permissions->count() }}</p>
                <p><strong>{{ __('roles.show.assigned_users') }}</strong> {{ $role->users->count() }}</p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.badge {
    padding: 4px 8px;
    font-size: 0.75em;
    font-weight: 500;
    border-radius: 4px;
}

.badge-info {
    background-color: #17a2b8;
    color: white;
}

.badge-success {
    background-color: #28a745;
    color: white;
}

.badge-danger {
    background-color: #dc3545;
    color: white;
}

.gap-2 {
    gap: 10px;
}

.d-grid {
    display: grid;
}

.w-100 {
    width: 100%;
}
</style>
@endpush

