@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3">
                    {{ __('Reserva') }}: {{ $reservation->reservation_code }}
                    @if($reservation->status == 'pending')
                        <span class="badge bg-warning">{{ __('Pendiente') }}</span>
                    @elseif($reservation->status == 'in_progress')
                        <span class="badge bg-info">{{ __('En Proceso') }}</span>
                    @elseif($reservation->status == 'completed')
                        <span class="badge bg-success">{{ __('Completada') }}</span>
                    @else
                        <span class="badge bg-danger">{{ __('Cancelada') }}</span>
                    @endif
                </h1>
                <a href="{{ route('reservations.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> {{ __('Volver') }}
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Información de la Reserva -->
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('Información General') }}</h5>
                    @if(!$reservation->isCompleted() && !$reservation->isCancelled())
                        <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editReservationModal">
                            <i class="fas fa-edit"></i> {{ __('Editar') }}
                        </button>
                    @endif
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-5">{{ __('Cliente:') }}</dt>
                        <dd class="col-sm-7">{{ $reservation->client->client_name }}</dd>

                        <dt class="col-sm-5">{{ __('Código:') }}</dt>
                        <dd class="col-sm-7"><code>{{ $reservation->reservation_code }}</code></dd>

                        <dt class="col-sm-5">{{ __('Estado:') }}</dt>
                        <dd class="col-sm-7">
                            @if($reservation->status == 'pending')
                                <span class="badge bg-warning">{{ __('Pendiente') }}</span>
                            @elseif($reservation->status == 'in_progress')
                                <span class="badge bg-info">{{ __('En Proceso') }}</span>
                            @elseif($reservation->status == 'completed')
                                <span class="badge bg-success">{{ __('Completada') }}</span>
                            @else
                                <span class="badge bg-danger">{{ __('Cancelada') }}</span>
                            @endif
                        </dd>

                        <dt class="col-sm-5">{{ __('Creado por:') }}</dt>
                        <dd class="col-sm-7">{{ $reservation->reservedBy->name ?? 'N/A' }}</dd>

                        <dt class="col-sm-5">{{ __('Fecha:') }}</dt>
                        <dd class="col-sm-7">{{ $reservation->created_at->format('d/m/Y H:i') }}</dd>

                        @if($reservation->confirmed_at)
                            <dt class="col-sm-5">{{ __('Confirmado:') }}</dt>
                            <dd class="col-sm-7">{{ $reservation->confirmed_at->format('d/m/Y H:i') }}</dd>
                        @endif

                        @if($reservation->notes)
                            <dt class="col-sm-12 mt-2">{{ __('Notas:') }}</dt>
                            <dd class="col-sm-12">{{ $reservation->notes }}</dd>
                        @endif
                    </dl>
                </div>
            </div>

            <!-- Estadísticas -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Estadísticas') }}</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-1">
                            <span>{{ __('Progreso') }}</span>
                            <span class="fw-bold">{{ number_format($stats['completion_percentage'], 0) }}%</span>
                        </div>
                        <div class="progress" style="height: 25px;">
                            <div class="progress-bar {{ $stats['completion_percentage'] == 100 ? 'bg-success' : 'bg-info' }}"
                                 role="progressbar"
                                 style="width: {{ $stats['completion_percentage'] }}%">
                                {{ number_format($stats['completion_percentage'], 0) }}%
                            </div>
                        </div>
                    </div>

                    <dl class="row mb-0">
                        <dt class="col-sm-7">{{ __('Total de cajas:') }}</dt>
                        <dd class="col-sm-5 text-end"><span class="badge bg-primary">{{ $stats['total_boxes'] }}</span></dd>

                        <dt class="col-sm-7">{{ __('Confirmadas:') }}</dt>
                        <dd class="col-sm-5 text-end"><span class="badge bg-success">{{ $stats['confirmed_boxes'] }}</span></dd>

                        <dt class="col-sm-7">{{ __('Pendientes:') }}</dt>
                        <dd class="col-sm-5 text-end"><span class="badge bg-warning">{{ $stats['pending_boxes'] }}</span></dd>
                    </dl>
                </div>
            </div>

            <!-- Acciones -->
            @if(!$reservation->isCompleted() && !$reservation->isCancelled())
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">{{ __('Acciones') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            {{-- Button removed as per request --}}
                            <a href="{{ route('reservations.available-inventory') }}" class="btn btn-info">
                                <i class="fas fa-download"></i> {{ __('Descargar Inventario') }}
                            </a>
                            <a href="{{ route('reservations.template') }}" class="btn btn-secondary">
                                <i class="fas fa-file-excel"></i> {{ __('Descargar Plantilla') }}
                            </a>
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#importModal">
                                <i class="fas fa-upload"></i> {{ __('Importar Cajas') }}
                            </button>
                            @can('reservations.cancel')
                                <form action="{{ route('reservations.cancel', $reservation) }}"
                                      method="POST"
                                      onsubmit="return confirm('¿Está seguro de cancelar esta reserva?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger w-100">
                                        <i class="fas fa-times"></i> {{ __('Cancelar Reserva') }}
                                    </button>
                                </form>
                            @endcan
                        </div>
                    </div>
                </div>
            @endif
        </div>

        <!-- Lista de Cajas -->
        <div class="col-md-8">
            @if(!$reservation->isCompleted() && !$reservation->isCancelled())
                <div class="card mb-3 border-primary">
                    <div class="card-header bg-primary text-white">
                        <h6 class="mb-0"><i class="fas fa-barcode"></i> {{ __('Escanear para Confirmar') }}</h6>
                    </div>
                    <div class="card-body bg-light">
                        <form action="{{ route('reservations.add-box', $reservation) }}" method="POST">
                            @csrf
                            <input type="text" name="box_number" class="form-control form-control-lg text-center fw-bold" placeholder="ESCANEAR CÓDIGO CAJA" autocomplete="off" autofocus onblur="this.focus()">
                        </form>
                    </div>
                </div>
            @endif

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Cajas Reservadas') }} ({{ $stats['total_boxes'] }})</h5>
                </div>
                <div class="card-body">
                    @if($reservation->items->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead>
                                    <tr>
                                        <th>{{ __('Número de Caja') }}</th>
                                        <th>{{ __('Marca') }}</th>
                                        <th>{{ __('Sección') }}</th>
                                        <th>{{ __('Familia') }}</th>
                                        <th>{{ __('Ubicación') }}</th>
                                        <th>{{ __('Cantidad') }}</th>
                                        <th>{{ __('Estado') }}</th>
                                        @if(!$reservation->isCompleted() && !$reservation->isCancelled())
                                            <th>{{ __('Acciones') }}</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($reservation->items as $item)
                                        <tr>
                                            <td><code>{{ $item->box_number }}</code></td>
                                            <td>{{ $item->inventory->cadena ?? '-' }}</td>
                                            <td>{{ $item->inventory->seccion ?? '-' }}</td>
                                            <td>{{ $item->inventory->familia_articulo_description ?? '-' }}</td>
                                            <td>{{ $item->inventory->ubicacion ?? '-' }}</td>
                                            <td><span class="badge bg-secondary">{{ $item->quantity }}</span></td>
                                            <td>
                                                @if($item->status == 'reserved')
                                                    <span class="badge bg-warning">{{ __('Reservado') }}</span>
                                                @elseif($item->status == 'confirmed')
                                                    <span class="badge bg-success">{{ __('Confirmado') }}</span>
                                                    <br><small class="text-muted">{{ $item->scanned_at->format('d/m H:i') }}</small>
                                                @else
                                                    <span class="badge bg-danger">{{ __('Cancelado') }}</span>
                                                @endif
                                            </td>
                                            @if(!$reservation->isCompleted() && !$reservation->isCancelled())
                                                <td>
                                                    @can('reservations.update')
                                                        <form action="{{ route('reservations.remove-box', [$reservation, $item]) }}"
                                                              method="POST"
                                                              class="d-inline"
                                                              onsubmit="return confirm('¿Eliminar esta caja de la reserva?')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-sm btn-danger" title="{{ __('Eliminar') }}">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    @endcan
                                                </td>
                                            @endif
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center text-muted py-5">
                            <i class="fas fa-inbox fa-3x mb-3"></i>
                            <p>{{ __('No hay cajas en esta reserva') }}</p>
                            <p class="small">{{ __('Importe un archivo Excel con las cajas seleccionadas') }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

</div>

</div>
 {{-- Add Box Modal Removed --}}


<!-- Modal Editar Detalles -->
<div class="modal fade" id="editReservationModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('reservations.update', $reservation) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Editar Detalles') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="client_id" class="form-label">{{ __('Cliente') }}</label>
                        <select name="client_id" id="client_id_edit" class="form-select" required>
                             @foreach(\App\Models\Client::orderBy('client_name')->get() as $client)
                                <option value="{{ $client->id }}" {{ $reservation->client_id == $client->id ? 'selected' : '' }}>
                                    {{ $client->client_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">{{ __('Notas') }}</label>
                        <textarea name="notes" id="notes_edit" class="form-control" rows="3">{{ $reservation->notes }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancelar') }}</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> {{ __('Guardar Cambios') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal de Importación -->
<div class="modal fade" id="importModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('reservations.import', $reservation) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Importar Cajas desde Excel') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="file" class="form-label">{{ __('Archivo Excel') }}</label>
                        <input type="file" name="file" id="file" class="form-control" accept=".xlsx,.xls,.csv" required>
                        <small class="form-text text-muted">
                            {{ __('Formatos aceptados: .xlsx, .xls, .csv (máximo 10MB)') }}
                        </small>
                    </div>

                    <div class="alert alert-info">
                        <strong>{{ __('Instrucciones:') }}</strong>
                        <ol class="mb-0 mt-2 small">
                            <li>{{ __('Descarga el inventario disponible o la plantilla') }}</li>
                            <li>{{ __('Marca con "X" o "1" en la columna SELECCIONAR') }}</li>
                            <li>{{ __('Guarda el archivo y súbelo aquí') }}</li>
                        </ol>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancelar') }}</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> {{ __('Importar') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
