@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3">{{ __('Reservas de Cajas') }}</h1>
                <div>
                    @can('reservations.view')
                        <a href="{{ route('reservations.available-inventory') }}" class="btn btn-info">
                            <i class="fas fa-download"></i> {{ __('Descargar Inventario') }}
                        </a>
                    @endcan
                    @can('reservations.create')
                        <a href="{{ route('reservations.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> {{ __('Nueva Reserva') }}
                        </a>
                    @endcan
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('reservations.index') }}" class="row g-3">
                <div class="col-md-4">
                    <label for="status" class="form-label">{{ __('Estado') }}</label>
                    <select name="status" id="status" class="form-select">
                        <option value="">{{ __('Todos') }}</option>
                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>{{ __('Pendiente') }}</option>
                        <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>{{ __('En Proceso') }}</option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>{{ __('Completada') }}</option>
                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>{{ __('Cancelada') }}</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="client_id" class="form-label">{{ __('Cliente') }}</label>
                    <select name="client_id" id="client_id" class="form-select">
                        <option value="">{{ __('Todos') }}</option>
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}" {{ request('client_id') == $client->id ? 'selected' : '' }}>
                                {{ $client->client_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-filter"></i> {{ __('Filtrar') }}
                    </button>
                    <a href="{{ route('reservations.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> {{ __('Limpiar') }}
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Reservations Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>{{ __('Código') }}</th>
                            <th>{{ __('Cliente') }}</th>
                            <th>{{ __('Estado') }}</th>
                            <th>{{ __('Cajas') }}</th>
                            <th>{{ __('Progreso') }}</th>
                            <th>{{ __('Creado por') }}</th>
                            <th>{{ __('Fecha') }}</th>
                            <th>{{ __('Acciones') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reservations as $reservation)
                            <tr>
                                <td>
                                    <a href="{{ route('reservations.show', $reservation) }}" class="fw-bold text-decoration-none">
                                        {{ $reservation->reservation_code }}
                                    </a>
                                </td>
                                <td>{{ $reservation->client->client_name }}</td>
                                <td>
                                    @if($reservation->status == 'pending')
                                        <span class="badge bg-warning">{{ __('Pendiente') }}</span>
                                    @elseif($reservation->status == 'in_progress')
                                        <span class="badge bg-info">{{ __('En Proceso') }}</span>
                                    @elseif($reservation->status == 'completed')
                                        <span class="badge bg-success">{{ __('Completada') }}</span>
                                    @else
                                        <span class="badge bg-danger">{{ __('Cancelada') }}</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-primary">{{ $reservation->total_boxes }}</span> total
                                    @if($reservation->confirmed_boxes > 0)
                                        <br><span class="badge bg-success">{{ $reservation->confirmed_boxes }}</span> confirmadas
                                    @endif
                                </td>
                                <td>
                                    <div class="progress" style="height: 20px;">
                                        <div class="progress-bar {{ $reservation->completion_percentage == 100 ? 'bg-success' : 'bg-info' }}"
                                             role="progressbar"
                                             style="width: {{ $reservation->completion_percentage }}%"
                                             aria-valuenow="{{ $reservation->completion_percentage }}"
                                             aria-valuemin="0"
                                             aria-valuemax="100">
                                            {{ number_format($reservation->completion_percentage, 0) }}%
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $reservation->reservedBy->name ?? 'N/A' }}</td>
                                <td>{{ $reservation->created_at->format('d/m/Y H:i') }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('reservations.show', $reservation) }}"
                                           class="btn btn-sm btn-info"
                                           title="{{ __('Ver') }}">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @if($reservation->isPending() || $reservation->isInProgress())
                                            @can('reservations.cancel')
                                                <form action="{{ route('reservations.cancel', $reservation) }}"
                                                      method="POST"
                                                      class="d-inline"
                                                      onsubmit="return confirm('¿Está seguro de cancelar esta reserva?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" title="{{ __('Cancelar') }}">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </form>
                                            @endcan
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">
                                    {{ __('No hay reservas registradas') }}
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-3">
                {{ $reservations->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
