@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3">{{ __('Nueva Reserva de Cajas') }}</h1>
                <a href="{{ route('reservations.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> {{ __('Volver') }}
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Información de la Reserva') }}</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('reservations.store') }}" method="POST">
                        @csrf

                        <div class="mb-3">
                            <label for="client_id" class="form-label">
                                {{ __('Cliente') }} <span class="text-danger">*</span>
                            </label>
                            <select name="client_id" id="client_id" class="form-select @error('client_id') is-invalid @enderror" required>
                                <option value="">{{ __('Seleccionar cliente...') }}</option>
                                @foreach($clients as $client)
                                    <option value="{{ $client->id }}" {{ old('client_id') == $client->id ? 'selected' : '' }}>
                                        {{ $client->client_name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('client_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                {{ __('Seleccione el cliente para el cual se creará la reserva') }}
                            </small>
                        </div>

                        <div class="mb-3">
                            <label for="notes" class="form-label">{{ __('Notas') }}</label>
                            <textarea name="notes" id="notes" rows="4" class="form-control @error('notes') is-invalid @enderror" placeholder="{{ __('Notas adicionales sobre la reserva (opcional)') }}">{{ old('notes') }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror>
                        </div>

                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <strong>{{ __('Próximos pasos:') }}</strong>
                            <ol class="mb-0 mt-2">
                                <li>{{ __('Crear la reserva') }}</li>
                                <li>{{ __('Descargar el inventario disponible o usar plantilla') }}</li>
                                <li>{{ __('Marcar las cajas deseadas en el Excel') }}</li>
                                <li>{{ __('Importar el archivo con las cajas seleccionadas') }}</li>
                            </ol>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ route('reservations.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> {{ __('Cancelar') }}
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> {{ __('Crear Reserva') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
