@extends('layouts.app')

@section('title', __('reports.stock_summary.title'))

@section('content')
<div class="page-header d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-4">
    <div>
        <h1 class="page-title mb-1">{{ __('reports.stock_summary.header') }}</h1>
        <p class="text-muted mb-0">
            {{ __('reports.stock_summary.description') }}
        </p>
    </div>
</div>

<div class="card mb-4 shadow-sm">
    <div class="card-header">
        <h5 class="mb-0"><i class="fas fa-filter me-2"></i>{{ __('reports.stock_summary.filters.title') }}</h5>
    </div>
    <form method="GET" action="{{ route('reports.stock-summary') }}">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="marca" class="form-label">{{ __('reports.stock_summary.filters.brand') }}</label>
                    <input type="text" id="marca" name="marca" class="form-control"
                           value="{{ $filters['marca'] }}">
                </div>
                <div class="col-md-3">
                    <label for="season_int" class="form-label">{{ __('reports.stock_summary.filters.season_internal') }}</label>
                    <input type="text" id="season_int" name="season_int" class="form-control"
                           value="{{ $filters['season_int'] }}">
                </div>
                <div class="col-md-3">
                    <label for="season" class="form-label">{{ __('reports.stock_summary.filters.season') }}</label>
                    <input type="text" id="season" name="season" class="form-control"
                           value="{{ $filters['season'] }}">
                </div>
                <div class="col-md-3">
                    <label for="status_scope" class="form-label">{{ __('reports.stock_summary.filters.status_scope') }}</label>
                    <select id="status_scope" name="status_scope" class="form-select">
                        <option value="all" {{ $filters['status_scope'] === 'all' ? 'selected' : '' }}>{{ __('reports.stock_summary.filters.status_all') }}</option>
                        <option value="trabajada" {{ $filters['status_scope'] === 'trabajada' ? 'selected' : '' }}>{{ __('reports.stock_summary.filters.status_worked') }}</option>
                        <option value="sin_trabajar" {{ $filters['status_scope'] === 'sin_trabajar' ? 'selected' : '' }}>{{ __('reports.stock_summary.filters.status_pending') }}</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="card-footer d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search me-1"></i> {{ __('reports.stock_summary.filters.apply') }}
            </button>
            <a href="{{ route('reports.stock-summary') }}" class="btn btn-outline-secondary">
                <i class="fas fa-undo me-1"></i> {{ __('reports.common.clear') }}
            </a>
        </div>
    </form>
</div>

@php
    $totalTrabajada = $totals->total_trabajada ?? 0;
    $totalSinTrabajar = $totals->total_sin_trabajar ?? 0;
    $totalMercancia = $totals->total_mercancia ?? 0;
@endphp

<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="metric-card bg-light border h-100 p-3 rounded">
            <div class="text-muted text-uppercase small">{{ __('reports.stock_summary.metrics.worked') }}</div>
            <div class="display-6 fw-bold text-success">{{ number_format($totalTrabajada) }}</div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="metric-card bg-light border h-100 p-3 rounded">
            <div class="text-muted text-uppercase small">{{ __('reports.stock_summary.metrics.pending') }}</div>
            <div class="display-6 fw-bold text-warning">{{ number_format($totalSinTrabajar) }}</div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="metric-card bg-light border h-100 p-3 rounded">
            <div class="text-muted text-uppercase small">{{ __('reports.stock_summary.metrics.total') }}</div>
            <div class="display-6 fw-bold text-primary">{{ number_format($totalMercancia) }}</div>
        </div>
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0"><i class="fas fa-layer-group me-2"></i>{{ __('reports.stock_summary.details.title') }}</h5>
        <span class="text-muted">{{ __('reports.stock_summary.details.count', ['count' => $summary->count()]) }}</span>
    </div>
    <div class="card-body p-0">
        @if($summary->isEmpty())
            <div class="p-4 text-center text-muted">
                <i class="fas fa-info-circle me-2"></i>{{ __('reports.stock_summary.details.empty') }}
            </div>
        @else
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>{{ __('reports.stock_summary.details.headers.brand') }}</th>
                            @foreach($seasonInts as $seasonInt)
                                <th class="text-center">{{ $seasonInt }}</th>
                            @endforeach
                            <th class="text-center">{{ __('reports.stock_summary.details.headers.pending') }}</th>
                            <th class="text-center">{{ __('reports.stock_summary.details.headers.total') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($summary as $row)
                            <tr>
                                <td><strong>{{ $row['marca'] ?? __('reports.stock_summary.details.no_brand') }}</strong></td>
                                @foreach($seasonInts as $seasonInt)
                                    <td class="text-center">
                                        {{ isset($row['season_ints'][$seasonInt]) ? number_format($row['season_ints'][$seasonInt]['cantidad']) : '0' }}
                                    </td>
                                @endforeach
                                <td class="text-center fw-semibold text-warning">{{ number_format($row['total_sin_trabajar']) }}</td>
                                <td class="text-center fw-bold text-primary">{{ number_format($row['total_general']) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    @if($summary->isNotEmpty())
                        <tfoot class="table-light">
                            <tr>
                                <td><strong>Total</strong></td>
                                @foreach($seasonInts as $seasonInt)
                                    @php
                                        $totalSeason = 0;
                                        foreach($summary as $row) {
                                            if (isset($row['season_ints'][$seasonInt])) {
                                                $totalSeason += $row['season_ints'][$seasonInt]['cantidad'];
                                            }
                                        }
                                    @endphp
                                    <td class="text-center fw-bold">{{ number_format($totalSeason) }}</td>
                                @endforeach
                                <td class="text-center fw-bold text-warning">{{ number_format($totals->total_sin_trabajar ?? 0) }}</td>
                                <td class="text-center fw-bold text-primary">{{ number_format($totals->total_mercancia ?? 0) }}</td>
                            </tr>
                        </tfoot>
                    @endif
                </table>
            </div>
        @endif
    </div>
</div>
@endsection



