@extends('layouts.app')

@section('title', __('reports.productivity.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-chart-bar"></i> {{ __('reports.productivity.header') }}</h2>
    <div>
        <a href="{{ route('reports.productivity.export', request()->all()) }}" class="btn btn-success">
            <i class="fas fa-file-excel"></i> {{ __('reports.productivity.export') }}
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.productivity') }}" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">{{ __('reports.productivity.filters.operator') }}</label>
                <select name="operario_id" class="form-select">
                    <option value="">{{ __('reports.common.all') }}</option>
                    @foreach($operarios as $operario)
                        <option value="{{ $operario }}" {{ request('operario_id') == $operario ? 'selected' : '' }}>
                            {{ $operario }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">{{ __('reports.productivity.filters.date_from') }}</label>
                <input type="date" name="fecha_desde" class="form-control" value="{{ request('fecha_desde') }}">
            </div>
            <div class="col-md-3">
                <label class="form-label">{{ __('reports.productivity.filters.date_to') }}</label>
                <input type="date" name="fecha_hasta" class="form-control" value="{{ request('fecha_hasta') }}">
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button type="submit" class="btn btn-primary me-2"><i class="fas fa-search"></i> {{ __('reports.productivity.actions.filter') }}</button>
                <a href="{{ route('reports.productivity') }}" class="btn btn-secondary"><i class="fas fa-times"></i> {{ __('reports.productivity.actions.clear') }}</a>
            </div>
        </form>
    </div>
</div>

<!-- Controles de Paginación -->
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.productivity') }}" id="pagination-form" class="d-flex justify-content-between align-items-center flex-wrap gap-3">
            <!-- Mantener filtros en campos ocultos -->
            @if(request('operario_id'))
                <input type="hidden" name="operario_id" value="{{ request('operario_id') }}">
            @endif
            @if(request('fecha_desde'))
                <input type="hidden" name="fecha_desde" value="{{ request('fecha_desde') }}">
            @endif
            @if(request('fecha_hasta'))
                <input type="hidden" name="fecha_hasta" value="{{ request('fecha_hasta') }}">
            @endif
            
            <div class="d-flex align-items-center gap-2">
                <label for="per_page">{{ __('reports.productivity.pagination.per_page') }}</label>
                <select name="per_page" id="per_page" class="form-control" style="width: auto;" onchange="this.form.submit()">
                    <option value="10" {{ request('per_page', 50) == 10 ? 'selected' : '' }}>10</option>
                    <option value="25" {{ request('per_page', 50) == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ request('per_page', 50) == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ request('per_page', 50) == 100 ? 'selected' : '' }}>100</option>
                    <option value="250" {{ request('per_page', 50) == 250 ? 'selected' : '' }}>250</option>
                </select>
            </div>
            <div class="text-muted">
                {{ __('reports.productivity.pagination.page_info', [
                    'current' => $reports->currentPage(),
                    'last' => $reports->lastPage(),
                    'total' => $reports->total()
                ]) }}
            </div>
            <div class="d-flex align-items-center gap-2">
                @if($reports->onFirstPage())
                    <button type="button" class="btn btn-sm" disabled>{{ __('reports.productivity.pagination.prev') }}</button>
                @else
                    <a href="{{ $reports->previousPageUrl() }}" class="btn btn-sm">{{ __('reports.productivity.pagination.prev') }}</a>
                @endif
                
                @foreach($reports->getUrlRange(max(1, $reports->currentPage() - 2), min($reports->lastPage(), $reports->currentPage() + 2)) as $page => $url)
                    @if($page == $reports->currentPage())
                        <span class="pagination-link active">{{ $page }}</span>
                    @else
                        <a href="{{ $url }}" class="pagination-link">{{ $page }}</a>
                    @endif
                @endforeach
                
                @if($reports->hasMorePages())
                    <a href="{{ $reports->nextPageUrl() }}" class="btn btn-sm">{{ __('reports.productivity.pagination.next') }}</a>
                @else
                    <button type="button" class="btn btn-sm" disabled>{{ __('reports.productivity.pagination.next') }}</button>
                @endif
            </div>
        </form>
    </div>
</div>

<!-- Tabla de Reportes -->
<div class="card">
    <div class="card-header">
        <h5><i class="fas fa-list"></i> {{ __('reports.productivity.table.title') }}</h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>{{ __('reports.productivity.table.headers.operator') }}</th>
                        <th>{{ __('reports.productivity.table.headers.date') }}</th>
                        <th>{{ __('reports.productivity.table.headers.scanned_units') }}</th>
                        <th>{{ __('reports.productivity.table.headers.processed_boxes') }}</th>
                        <th>{{ __('reports.productivity.table.headers.average_per_box') }}</th>
                    </tr>
                </thead>
                <tbody>
                @forelse($reports as $report)
                    <tr>
                        <td><strong>{{ $report->n_id_operario }}</strong></td>
                        <td>{{ \Carbon\Carbon::parse($report->fecha)->format('d/m/Y') }}</td>
                        <td><span class="badge bg-primary">{{ $report->unidades_escaneadas }}</span></td>
                        <td><span class="badge bg-info">{{ $report->cajas_procesadas }}</span></td>
                        <td>
                            @if($report->cajas_procesadas > 0)
                                {{ number_format($report->unidades_escaneadas / $report->cajas_procesadas, 2) }}
                            @else
                                0
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center text-muted p-4">
                            {{ __('reports.productivity.table.empty') }}
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Resumen -->
@if(isset($summary) && $reports->total() > 0)
<div class="card mt-4">
    <div class="card-header">
        <h5><i class="fas fa-chart-pie"></i> {{ __('reports.productivity.summary.title') }}</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-4">
                <div class="text-center">
                    <h3>{{ number_format($summary->total_unidades ?? 0) }}</h3>
                    <p class="text-muted">{{ __('reports.productivity.summary.total_units') }}</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="text-center">
                    <h3>{{ number_format($summary->total_cajas ?? 0) }}</h3>
                    <p class="text-muted">{{ __('reports.productivity.summary.total_boxes') }}</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="text-center">
                    <h3>
                        @if(($summary->total_cajas ?? 0) > 0)
                            {{ number_format(($summary->total_unidades ?? 0) / ($summary->total_cajas ?? 1), 2) }}
                        @else
                            0
                        @endif
                    </h3>
                    <p class="text-muted">{{ __('reports.productivity.summary.average') }}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@push('styles')
<style>
.pagination-link {
    padding: 5px 10px;
    margin: 0 2px;
    border: 1px solid #007bff;
    border-radius: 3px;
    text-decoration: none;
    color: #007bff;
    cursor: pointer;
    font-size: 14px;
    display: inline-block;
}

.pagination-link:hover:not(.active) {
    background-color: #e6f2ff;
}

.pagination-link.active {
    background-color: #007bff;
    color: white;
    pointer-events: none;
}

/* Asegurar que la tabla tenga los mismos estilos que inventario */
.data-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 0;
    font-size: 13px;
    box-shadow: 0 1px 5px rgba(0,0,0,0.08);
    border-radius: 0;
    overflow: hidden;
}

.data-table th, .data-table td {
    border: 1px solid #DFE3E8;
    padding: 8px 12px;
    text-align: left;
    vertical-align: middle;
}

.data-table th {
    background-color: #F7F9FC;
    color: #555;
    font-weight: 600;
    position: relative;
    cursor: default;
    padding-right: 25px;
    user-select: none;
    white-space: nowrap;
    transition: background-color 0.2s ease;
}

.data-table th:hover {
    background-color: #E6EEF5;
}

.data-table tbody tr:nth-child(even) {
    background-color: #FCFDFF;
}

.data-table tbody tr:hover {
    background-color: #EBF2F9;
}

.data-table tbody tr td {
    border: 1px solid #DFE3E8;
}

.table-responsive {
    overflow-x: auto;
}
</style>
@endpush
@endsection

