@extends('layouts.app')

@section('title', __('relabeling.view'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-eye"></i> {{ __('relabeling.view') }}</h2>
    <div class="d-flex gap-2">
        @can('relabeling.create')
        <a href="{{ route('relabeling.edit', $relabeling) }}" class="btn btn-primary">
            <i class="fas fa-edit"></i> {{ __('relabeling.buttons.edit') }}
        </a>
        @endcan
        <a href="{{ route('relabeling.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> {{ __('relabeling.back') }}
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('relabeling.info.product_info') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <label class="info-label">{{ __('relabeling.fields.proveedor_code') }}:</label>
                            <span class="info-value">{{ $relabeling->proveedor_code }}</span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <label class="info-label">{{ __('relabeling.fields.codebar_gnu') }}:</label>
                            <span class="info-value">{{ $relabeling->codebar_gnu }}</span>
                        </div>
                    </div>
                </div>

                <div class="info-item">
                    <label class="info-label">{{ __('relabeling.fields.description') }}:</label>
                    <span class="info-value">{{ $relabeling->description }}</span>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <label class="info-label">{{ __('relabeling.fields.price_cfa') }}:</label>
                            <span class="info-value">
                                @if($relabeling->price_cfa)
                                    {{ number_format($relabeling->price_cfa, 2) }} CFA
                                @else
                                    <span class="text-muted">{{ __('relabeling.labels.no_price') }}</span>
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-qrcode"></i> {{ __('relabeling.zpl.title') }}</h5>
            </div>
            <div class="card-body">
                <form id="zpl-form">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my_code">{{ __('relabeling.zpl.internal_code') }}</label>
                                <input type="text" class="form-control" id="my_code" name="my_code" 
                                       value="{{ $relabeling->proveedor_code }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="price_display">{{ __('relabeling.fields.price_display') }}:</label>
                                <input type="text" class="form-control" id="price_display" name="price_display" 
                                       value="{{ $relabeling->price_cfa ?? '0' }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-end gap-2">
                        <button type="button" class="btn btn-success" onclick="generateZpl()">
                            <i class="fas fa-print"></i> {{ __('relabeling.buttons.generate_zpl') }}
                        </button>
                    </div>
                </form>
                
                <div id="zpl-result" class="mt-3" style="display: none;">
                    <h6>{{ __('relabeling.zpl.generated_content') }}</h6>
                    <pre id="zpl-content" class="bg-light p-3 rounded"></pre>
                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="copyZpl()">
                        <i class="fas fa-copy"></i> {{ __('relabeling.buttons.copy_zpl') }}
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-history"></i> {{ __('relabeling.info.record_info') }}</h5>
            </div>
            <div class="card-body">
                <div class="info-item">
                    <label class="info-label">{{ __('relabeling.info.id') }}</label>
                    <span class="info-value">{{ $relabeling->id }}</span>
                </div>
                
                <div class="info-item">
                    <label class="info-label">{{ __('relabeling.info.created') }}</label>
                    <span class="info-value">{{ $relabeling->created_at->format('d/m/Y H:i:s') }}</span>
                </div>
                
                <div class="info-item">
                    <label class="info-label">{{ __('relabeling.info.updated') }}</label>
                    <span class="info-value">{{ $relabeling->updated_at->format('d/m/Y H:i:s') }}</span>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-trash"></i> {{ __('relabeling.info.delete_section') }}</h5>
            </div>
            <div class="card-body">
                <p class="text-muted small">
                    {{ __('relabeling.info.delete_warning') }}
                </p>
                <form method="POST" action="{{ route('relabeling.destroy', $relabeling) }}" 
                      onsubmit="return confirm('{{ __('relabeling.info.delete_confirm') }}')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm">
                        <i class="fas fa-trash"></i> {{ __('relabeling.buttons.delete') }}
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Inyectar traducciones en JavaScript
const translations = @json([
    'internal_code_required' => __('relabeling.messages.internal_code_required'),
    'zpl_error' => __('relabeling.messages.zpl_error'),
    'zpl_copied' => __('relabeling.messages.zpl_copied'),
    'zpl_copy_error' => __('relabeling.messages.zpl_copy_error'),
]);

async function generateZpl() {
    const myCode = document.getElementById('my_code').value;
    const priceDisplay = document.getElementById('price_display').value;
    
    if (!myCode) {
        alert(translations.internal_code_required);
        return;
    }
    
    try {
        const response = await fetch('/test/relabeling/generate-zpl', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            },
            body: JSON.stringify({
                barcode: '{{ $relabeling->codebar_gnu }}',
                my_code: myCode,
                description: '{{ $relabeling->description }}',
                price: priceDisplay
            })
        });
        
        const data = await response.json();
        
        if (data.success) {
            document.getElementById('zpl-content').textContent = data.zpl_content;
            document.getElementById('zpl-result').style.display = 'block';
        } else {
            alert(translations.zpl_error.replace(':message', data.message || ''));
        }
    } catch (error) {
        alert(translations.zpl_error.replace(':message', error.message));
    }
}

function copyZpl() {
    const zplContent = document.getElementById('zpl-content').textContent;
    navigator.clipboard.writeText(zplContent).then(() => {
        alert(translations.zpl_copied);
    }).catch(() => {
        alert(translations.zpl_copy_error);
    });
}
</script>
@endpush

@push('styles')
<style>
.info-item {
    margin-bottom: 20px;
}

.info-label {
    display: block;
    font-weight: 600;
    color: var(--sap-text-medium);
    margin-bottom: 5px;
}

.info-value {
    display: block;
    font-size: 1.1em;
    color: var(--sap-text-dark);
}

.gap-2 {
    gap: 10px;
}

.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

pre {
    font-size: 0.8em;
    max-height: 200px;
    overflow-y: auto;
}
</style>
@endpush
