@extends('layouts.app')

@section('title', __('relabeling.add'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus"></i> {{ __('relabeling.add') }}</h2>
    <a href="{{ route('relabeling.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('relabeling.back') }}
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-edit"></i> {{ __('relabeling.info.product_info') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('relabeling.store') }}">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="proveedor_code">{{ __('relabeling.fields.proveedor_code') }} *</label>
                                <input type="text" class="form-control" id="proveedor_code" name="proveedor_code" 
                                       value="{{ old('proveedor_code') }}" required>
                                @error('proveedor_code')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="codebar_gnu">{{ __('relabeling.fields.codebar_gnu') }} *</label>
                                <input type="text" class="form-control" id="codebar_gnu" name="codebar_gnu" 
                                       value="{{ old('codebar_gnu') }}" required>
                                @error('codebar_gnu')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="description">{{ __('relabeling.fields.description') }} *</label>
                        <textarea class="form-control" id="description" name="description" rows="3" required>{{ old('description') }}</textarea>
                        @error('description')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="price_cfa">{{ __('relabeling.fields.price_cfa') }}</label>
                                <input type="number" step="0.01" class="form-control" id="price_cfa" 
                                       name="price_cfa" value="{{ old('price_cfa') }}">
                                @error('price_cfa')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('relabeling.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> {{ __('relabeling.buttons.cancel') }}
                        </a>
                        <button type="submit" class="btn">
                            <i class="fas fa-save"></i> {{ __('relabeling.buttons.save') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('relabeling.info.title') }}</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">
                    <strong>{{ __('relabeling.info.required_fields') }}</strong> {{ __('relabeling.info.required_note') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('relabeling.info.proveedor_code_note') }}</strong> {{ __('relabeling.info.proveedor_code_description') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('relabeling.info.codebar_gnu_note') }}</strong> {{ __('relabeling.info.codebar_gnu_description') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('relabeling.info.description_note') }}</strong> {{ __('relabeling.info.description_description') }}
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Auto-focus en el primer campo
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('proveedor_code').focus();
});
</script>
@endpush

@push('styles')
<style>
.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.text-danger {
    font-size: 0.8em;
    margin-top: 5px;
}

.gap-2 {
    gap: 10px;
}
</style>
@endpush

