@extends('layouts.app')

@section('title', __('portal.index.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-circle"></i> {{ __('portal.index.header') }}</h2>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
    <i class="fas fa-check-circle"></i> {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
    <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('portal.index') }}" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">{{ __('portal.index.filters.status') }}</label>
                <select name="status" class="form-select">
                    <option value="">{{ __('portal.index.filters.all') }}</option>
                    <option value="reservado" {{ request('status') === 'reservado' ? 'selected' : '' }}>{{ __('portal.statuses.reservado') }}</option>
                    <option value="confirmed" {{ request('status') === 'confirmed' ? 'selected' : '' }}>{{ __('portal.statuses.confirmed') }}</option>
                    <option value="dispatched" {{ request('status') === 'dispatched' ? 'selected' : '' }}>{{ __('portal.statuses.dispatched') }}</option>
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label">{{ __('portal.index.filters.search') }}</label>
                <input type="text" name="search" class="form-control" value="{{ request('search') }}" placeholder="{{ __('portal.index.filters.search_placeholder') }}">
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary me-2"><i class="fas fa-search"></i> {{ __('portal.index.filters.apply') }}</button>
                <a href="{{ route('portal.index') }}" class="btn btn-secondary"><i class="fas fa-times"></i> {{ __('portal.common.clear') }}</a>
            </div>
        </form>
    </div>
</div>

<!-- Lista de Reservas -->
<div class="card">
    <div class="card-header">
        <h5><i class="fas fa-list"></i> {{ __('portal.index.table.title') }}</h5>
        <span class="badge bg-primary">{{ __('portal.index.table.orders_badge', ['count' => $orders->total()]) }}</span>
    </div>
    <div class="card-body p-0">
        @if($orders->count() > 0)
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>{{ __('portal.index.table.headers.order_id') }}</th>
                            <th>{{ __('portal.index.table.headers.status') }}</th>
                            <th>{{ __('portal.index.table.headers.order_date') }}</th>
                            <th>{{ __('portal.index.table.headers.dispatch_date') }}</th>
                            <th>{{ __('portal.index.table.headers.items') }}</th>
                            <th>{{ __('portal.index.table.headers.notes') }}</th>
                            <th>{{ __('portal.index.table.headers.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($orders as $order)
                            <tr>
                                <td><strong>#{{ $order->id }}</strong></td>
                                <td>
                                    @php
                                        $statusKey = 'portal.statuses.' . $order->status;
                                        $statusLabel = __($statusKey);
                                        if ($statusLabel === $statusKey) {
                                            $statusLabel = ucfirst($order->status);
                                        }
                                        $statusClass = match($order->status) {
                                            'reservado' => 'bg-warning',
                                            'confirmed' => 'bg-info',
                                            'dispatched' => 'bg-success',
                                            default => 'bg-secondary',
                                        };
                                    @endphp
                                    <span class="badge {{ $statusClass }}">{{ $statusLabel }}</span>
                                </td>
                                <td>{{ $order->order_date->format('d/m/Y H:i') }}</td>
                                <td>
                                    @if($order->dispatched_date)
                                        {{ $order->dispatched_date->format('d/m/Y H:i') }}
                                    @else
                                        <span class="text-muted">{{ __('portal.common.not_available') }}</span>
                                    @endif
                                </td>
                                <td>
                                    @php
                                        $itemCount = $order->orderItems ? $order->orderItems->count() : 0;
                                    @endphp
                                    {{ $itemCount }}
                                </td>
                                <td>{{ Str::limit($order->notes ?? __('portal.common.notes_placeholder'), 50) }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('portal.show', $order) }}" class="btn btn-sm btn-outline-primary" title="{{ __('portal.common.view') }}">
                                            <i class="fas fa-eye"></i> {{ __('portal.index.buttons.view') }}
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- Paginación -->
            <div class="card-footer">
                {{ $orders->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-box-open fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">{{ __('portal.index.table.empty_title') }}</h5>
                <p class="text-muted">{{ __('portal.index.table.empty_description') }}</p>
            </div>
        @endif
    </div>
</div>

@push('styles')
<style>
.data-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 0;
    font-size: 13px;
    box-shadow: 0 1px 5px rgba(0,0,0,0.08);
    border-radius: 0;
    overflow: hidden;
}

.data-table th, .data-table td {
    border: 1px solid #DFE3E8;
    padding: 8px 12px;
    text-align: left;
    vertical-align: middle;
}

.data-table th {
    background-color: #F7F9FC;
    color: #555;
    font-weight: 600;
}

.data-table tbody tr:nth-child(even) {
    background-color: #FCFDFF;
}

.data-table tbody tr:hover {
    background-color: #EBF2F9;
}

.badge {
    padding: 4px 8px;
    font-size: 0.75em;
    font-weight: 500;
    border-radius: 4px;
}

.bg-warning { background-color: #ffc107 !important; color: #000 !important; }
.bg-info { background-color: #17a2b8 !important; }
.bg-success { background-color: #28a745 !important; }
.bg-secondary { background-color: #6c757d !important; }
</style>
@endpush
@endsection

