@extends('layouts.app')

@section('title', __('orders.new'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus"></i> {{ __('orders.new') }}</h2>
    <a href="{{ route('orders.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('orders.buttons.back') }}
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-edit"></i> {{ __('orders.create.form_title') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('orders.store') }}">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="client_id">{{ __('orders.create.client_label') }}</label>
                                <select class="form-control" id="client_id" name="client_id" required>
                                    <option value="">{{ __('orders.create.client_select') }}</option>
                                    @foreach($clients as $client)
                                        <option value="{{ $client->id }}" {{ old('client_id') == $client->id ? 'selected' : '' }}>
                                            {{ $client->client_name }} ({{ $client->email ?? __('orders.create.client_no_email') }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('client_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="operario_id">{{ __('orders.create.operator_label') }}</label>
                                <input type="text" class="form-control" id="operario_id" name="operario_id" 
                                       value="{{ old('operario_id') }}">
                                @error('operario_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="status">{{ __('orders.create.status_label') }}</label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="">{{ __('orders.create.status_select') }}</option>
                                    <option value="draft" {{ old('status') === 'draft' ? 'selected' : '' }}>{{ __('orders.status.draft') }}</option>
                                    <option value="pending" {{ old('status') === 'pending' ? 'selected' : '' }}>{{ __('orders.status.pending') }}</option>
                                    <option value="dispatched" {{ old('status') === 'dispatched' ? 'selected' : '' }}>{{ __('orders.status.dispatched') }}</option>
                                    <option value="cancelled" {{ old('status') === 'cancelled' ? 'selected' : '' }}>{{ __('orders.status.cancelled') }}</option>
                                </select>
                                @error('status')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="notes">{{ __('orders.create.notes_label') }}</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                        @error('notes')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('orders.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> {{ __('orders.buttons.cancel') }}
                        </a>
                        <button type="submit" class="btn">
                            <i class="fas fa-save"></i> {{ __('orders.buttons.save') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('orders.create.info_title') }}</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">
                    <strong>{{ __('orders.create.required_fields') }}</strong> {{ __('orders.create.required_note') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('orders.create.client_info') }}</strong> {{ __('orders.create.client_note') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('orders.create.status_info') }}</strong> {{ __('orders.create.status_note') }}
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Auto-focus en el primer campo
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('client_id').focus();
});
</script>
@endpush

@push('styles')
<style>
.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.text-danger {
    font-size: 0.8em;
    margin-top: 5px;
}

.gap-2 {
    gap: 10px;
}
</style>
@endpush
