@extends('layouts.app')

@section('title', 'Agregar Item de Inventario')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus"></i> Agregar Item de Inventario</h2>
    <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-edit"></i> Información del Item</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('inventory.store') }}">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="full_barcode">Código de Barras *</label>
                                <input type="text" class="form-control" id="full_barcode" name="full_barcode" 
                                       value="{{ old('full_barcode') }}" required>
                                @error('full_barcode')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mocaco">MOCACO *</label>
                                <input type="text" class="form-control" id="mocaco" name="mocaco" 
                                       value="{{ old('mocaco') }}" required>
                                @error('mocaco')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="n_carton">Número de Caja *</label>
                                <input type="text" class="form-control" id="n_carton" name="n_carton" 
                                       value="{{ old('n_carton') }}" required>
                                @error('n_carton')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="season_int">Temporada</label>
                                <input type="text" class="form-control" id="season_int" name="season_int" 
                                       value="{{ old('season_int') }}">
                                @error('season_int')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="ubicacion">Ubicación</label>
                                <input type="text" class="form-control" id="ubicacion" name="ubicacion" 
                                       value="{{ old('ubicacion') }}">
                                @error('ubicacion')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="n_id_operario">ID Operario</label>
                                <input type="text" class="form-control" id="n_id_operario" name="n_id_operario" 
                                       value="{{ old('n_id_operario') }}">
                                @error('n_id_operario')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="categoria_seleccionada">Categoría</label>
                                <input type="text" class="form-control" id="categoria_seleccionada" name="categoria_seleccionada" 
                                       value="{{ old('categoria_seleccionada') }}">
                                @error('categoria_seleccionada')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="famillie_usuario">Familia</label>
                                <input type="text" class="form-control" id="famillie_usuario" name="famillie_usuario" 
                                       value="{{ old('famillie_usuario') }}">
                                @error('famillie_usuario')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="cadena">Cadena</label>
                                <input type="text" class="form-control" id="cadena" name="cadena" 
                                       value="{{ old('cadena') }}">
                                @error('cadena')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="precio_pvp_maximo_temporada">Precio PVP Máximo</label>
                                <input type="number" step="0.01" class="form-control" id="precio_pvp_maximo_temporada" 
                                       name="precio_pvp_maximo_temporada" value="{{ old('precio_pvp_maximo_temporada') }}">
                                @error('precio_pvp_maximo_temporada')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="notes">Notas</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                        @error('notes')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="detail_usuario">Detalle Usuario</label>
                        <textarea class="form-control" id="detail_usuario" name="detail_usuario" rows="2">{{ old('detail_usuario') }}</textarea>
                        @error('detail_usuario')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancelar
                        </a>
                        <button type="submit" class="btn">
                            <i class="fas fa-save"></i> Guardar Item
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> Información</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">
                    <strong>Campos obligatorios:</strong> Los campos marcados con (*) son obligatorios.
                </p>
                <p class="text-muted">
                    <strong>Código de barras:</strong> Debe ser único en el sistema.
                </p>
                <p class="text-muted">
                    <strong>MOCACO:</strong> Código interno del artículo.
                </p>
                <p class="text-muted">
                    <strong>Caja:</strong> Número de caja donde se encuentra el item.
                </p>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-barcode"></i> Escáner</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Use el escáner para llenar automáticamente el código de barras.</p>
                <button type="button" class="btn btn-outline-primary" onclick="openScanner()">
                    <i class="fas fa-qrcode"></i> Abrir Escáner
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function openScanner() {
    // Esta función se implementará cuando creemos el módulo de escáner
    alert('Funcionalidad de escáner próximamente disponible');
}

// Auto-focus en el primer campo
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('full_barcode').focus();
});
</script>
@endpush

@push('styles')
<style>
.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.text-danger {
    font-size: 0.8em;
    margin-top: 5px;
}

.gap-2 {
    gap: 10px;
}

.btn-outline-primary {
    background-color: transparent;
    color: var(--sap-blue-light);
    border: 1px solid var(--sap-blue-light);
}

.btn-outline-primary:hover {
    background-color: var(--sap-blue-light);
    color: white;
}
</style>
@endpush

