@extends('layouts.app')

@section('title', __('dashboard.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-tachometer-alt"></i> {{ __('dashboard.dashboard') }}</h2>
    <div class="text-muted">
        <i class="fas fa-calendar"></i> {{ now()->format('d/m/Y H:i') }}
    </div>
</div>

<!-- Estadísticas principales -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-boxes"></i>
            </div>
            <div class="stat-content">
                <h3>{{ $stats['total_items'] ?? 0 }}</h3>
                <p>{{ __('dashboard.stats.total_items') }}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-archive"></i>
            </div>
            <div class="stat-content">
                <h3>{{ $stats['total_boxes'] ?? 0 }}</h3>
                <p>{{ __('dashboard.stats.total_boxes') }}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <div class="stat-content">
                <h3>{{ $stats['total_orders'] ?? 0 }}</h3>
                <p>{{ __('dashboard.stats.total_orders') }}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-handshake"></i>
            </div>
            <div class="stat-content">
                <h3>{{ $stats['total_clients'] ?? 0 }}</h3>
                <p>{{ __('dashboard.stats.total_clients') }}</p>
            </div>
        </div>
    </div>
</div>

<!-- Acciones rápidas -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-bolt"></i> {{ __('dashboard.quick_actions.title') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <a href="{{ route('inventory.create') }}" class="quick-action">
                            <i class="fas fa-plus-circle"></i>
                            <span>{{ __('dashboard.quick_actions.add_item') }}</span>
                        </a>
                    </div>
                    <div class="col-md-2">
                        <a href="{{ route('scanner') }}" class="quick-action">
                            <i class="fas fa-barcode"></i>
                            <span>{{ __('dashboard.quick_actions.scan') }}</span>
                        </a>
                    </div>
                    <div class="col-md-2">
                        <a href="{{ route('order-preparation') }}" class="quick-action">
                            <i class="fas fa-shopping-cart"></i>
                            <span>{{ __('dashboard.quick_actions.prepare_order') }}</span>
                        </a>
                    </div>
                    <div class="col-md-2">
                        <a href="{{ route('location') }}" class="quick-action">
                            <i class="fas fa-map-marker-alt"></i>
                            <span>{{ __('dashboard.quick_actions.assign_location') }}</span>
                        </a>
                    </div>
                    <div class="col-md-2">
                        <a href="{{ route('client-history') }}" class="quick-action">
                            <i class="fas fa-history"></i>
                            <span>{{ __('dashboard.quick_actions.client_history') }}</span>
                        </a>
                    </div>
                    <div class="col-md-2">
                        <a href="{{ route('relabeling.create') }}" class="quick-action">
                            <i class="fas fa-redo"></i>
                            <span>{{ __('dashboard.quick_actions.relabel') }}</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tablas de resumen -->
<div class="row">
    <!-- Items recientes -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5><i class="fas fa-clock"></i> {{ __('dashboard.recent_items.title') }}</h5>
                <a href="{{ route('inventory.index') }}" class="btn btn-sm">{{ __('dashboard.recent_items.view_all') }}</a>
            </div>
            <div class="card-body">
                @if(isset($recent_items) && $recent_items->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>{{ __('dashboard.recent_items.code') }}</th>
                                    <th>{{ __('dashboard.recent_items.mocaco') }}</th>
                                    <th>{{ __('dashboard.recent_items.box') }}</th>
                                    <th>{{ __('dashboard.recent_items.date') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recent_items as $item)
                                    <tr>
                                        <td><code>{{ $item->full_barcode }}</code></td>
                                        <td>{{ $item->mocaco }}</td>
                                        <td>{{ $item->n_carton }}</td>
                                        <td>{{ $item->created_at->format('d/m H:i') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-3">
                        <i class="fas fa-box-open fa-2x text-muted mb-2"></i>
                        <p class="text-muted">{{ __('dashboard.recent_items.no_items') }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Pedidos pendientes -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5><i class="fas fa-list-alt"></i> {{ __('dashboard.pending_orders.title') }}</h5>
                <a href="{{ route('orders.index') }}" class="btn btn-sm">{{ __('dashboard.pending_orders.view_all') }}</a>
            </div>
            <div class="card-body">
                @if(isset($pending_orders) && $pending_orders->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>{{ __('dashboard.pending_orders.id') }}</th>
                                    <th>{{ __('dashboard.pending_orders.client') }}</th>
                                    <th>{{ __('dashboard.pending_orders.status') }}</th>
                                    <th>{{ __('dashboard.pending_orders.date') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($pending_orders as $order)
                                    <tr>
                                        <td>{{ $order->id }}</td>
                                        <td>{{ $order->client->name ?? 'N/A' }}</td>
                                        <td>
                                            @php
                                                $statusTranslations = [
                                                    'draft' => __('orders.status.draft'),
                                                    'reserved' => __('orders.status.reserved'),
                                                    'pending' => __('orders.status.pending'),
                                                    'dispatched' => __('orders.status.dispatched'),
                                                    'cancelled' => __('orders.status.cancelled'),
                                                ];
                                                $statusText = $statusTranslations[$order->status] ?? ucfirst($order->status);
                                            @endphp
                                            <span class="badge badge-{{ $order->status === 'pending' ? 'warning' : 'info' }}">
                                                {{ $statusText }}
                                            </span>
                                        </td>
                                        <td>{{ $order->created_at->format('d/m H:i') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-3">
                        <i class="fas fa-clipboard-list fa-2x text-muted mb-2"></i>
                        <p class="text-muted">{{ __('dashboard.pending_orders.no_orders') }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.stat-card {
    background: white;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    display: flex;
    align-items: center;
    margin-bottom: 20px;
    transition: transform 0.2s ease;
}

.stat-card:hover {
    transform: translateY(-2px);
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--sap-blue-light), #2980b9);
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    color: white;
    font-size: 1.5em;
}

.stat-content h3 {
    font-size: 2em;
    font-weight: bold;
    color: var(--sap-blue-dark);
    margin: 0;
    line-height: 1;
}

.stat-content p {
    color: var(--sap-text-medium);
    margin: 5px 0 0 0;
    font-size: 0.9em;
}

.quick-action {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 20px;
    text-decoration: none;
    color: var(--sap-text-dark);
    border-radius: 8px;
    transition: all 0.2s ease;
    background: white;
    border: 2px solid transparent;
}

.quick-action:hover {
    color: var(--sap-blue-light);
    border-color: var(--sap-blue-light);
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.quick-action i {
    font-size: 2em;
    margin-bottom: 10px;
    color: var(--sap-blue-light);
}

.quick-action span {
    font-weight: 500;
    font-size: 0.9em;
}

.table {
    margin-bottom: 0;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: var(--sap-text-medium);
    font-size: 0.85em;
    padding: 8px;
}

.table td {
    padding: 8px;
    font-size: 0.85em;
    vertical-align: middle;
}

.badge {
    padding: 4px 8px;
    font-size: 0.75em;
    font-weight: 500;
    border-radius: 4px;
}

.badge-warning {
    background-color: #ffc107;
    color: #212529;
}

.badge-info {
    background-color: #17a2b8;
    color: white;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 0.8em;
    min-width: auto;
}

code {
    font-family: 'Courier New', monospace;
    background-color: #f8f9fa;
    padding: 2px 4px;
    border-radius: 3px;
    font-size: 0.8em;
}

.row {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -15px;
}

.col-md-3, .col-md-6, .col-md-12 {
    padding: 0 15px;
    margin-bottom: 20px;
}

@media (max-width: 768px) {
    .col-md-3, .col-md-6 {
        flex: 0 0 100%;
        max-width: 100%;
    }
    
    .stat-card {
        flex-direction: column;
        text-align: center;
    }
    
    .stat-icon {
        margin-right: 0;
        margin-bottom: 10px;
    }
}
</style>
@endpush

