@extends('layouts.app')

@section('title', __('container_entries.index.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-truck"></i> {{ __('container_entries.index.title') }}</h2>
    <div class="d-flex gap-2">
        <a href="{{ route('container-entries.theoretical-template') }}" class="btn btn-secondary">
            <i class="fas fa-download"></i> {{ __('container_entries.index.buttons.theoretical_template') }}
        </a>
        <a href="{{ route('container-entries.export-unprocessed') }}" class="btn btn-info">
            <i class="fas fa-file-excel"></i> {{ __('container_entries.index.buttons.export_unprocessed') }}
        </a>
        @can('inventory.create')
        <a href="{{ route('container-entries.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> {{ __('container_entries.index.buttons.new_entry') }}
        </a>
        @endcan
    </div>
</div>

<!-- Modal: Asignar Usuarios -->
<div class="modal fade" id="assignUsersModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-users"></i> {{ __('container_entries.index.modal.title') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="assign-users-form" method="POST">
                @csrf
                <div class="modal-body">
                    <p class="text-muted mb-2">{{ __('container_entries.index.modal.description') }}</p>
                    <select name="usuario_ids[]" id="assign-users-select" class="form-select" multiple size="8">
                        @foreach($users as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('container_entries.common.cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('container_entries.index.modal.submit') }}</button>
                </div>
            </form>
        </div>
    </div>
    </div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function(){
    const assignModal = document.getElementById('assignUsersModal');
    const form = document.getElementById('assign-users-form');
    const select = document.getElementById('assign-users-select');

    assignModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const entryId = button.getAttribute('data-entry-id');
        form.action = `${window.location.origin}${window.location.pathname.replace(/\/$/, '')}/`;
        // Construir ruta con helper backend renderizado en data-attribute no es trivial aquí,
        // así que formamos la URL relativa:
        form.setAttribute('action', `{{ url('container-entries') }}/${entryId}/assign-users`);
        // Limpiar selección previa
        if (select) {
            for (const opt of select.options) opt.selected = false;
        }
    });
});
</script>
@endpush

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(session('warning'))
<div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
    <i class="fas fa-exclamation-triangle"></i> {{ session('warning') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
    {{ session('error') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('container-entries.index') }}" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">{{ __('container_entries.index.filters.status') }}</label>
                <select name="estado" class="form-select">
                    <option value="">{{ __('container_entries.index.filters.all') }}</option>
                    @foreach(\App\Enums\ContainerEntryStatus::cases() as $status)
                        <option value="{{ $status->value }}" {{ request('estado') === $status->value ? 'selected' : '' }}>
                            {{ $status->label() }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">{{ __('container_entries.index.filters.truck_number') }}</label>
                <input type="text" name="n_camion" class="form-control" value="{{ request('n_camion') }}" placeholder="{{ __('container_entries.index.filters.search_placeholder') }}">
            </div>
            @if(Auth::user()->hasRole('admin'))
            <div class="col-md-3">
                <label class="form-label">{{ __('container_entries.index.filters.assigned_user') }}</label>
                <select name="usuario_asignado_id" class="form-select">
                    <option value="">{{ __('container_entries.index.filters.all') }}</option>
                    @foreach($users as $user)
                        <option value="{{ $user->id }}" {{ request('usuario_asignado_id') == $user->id ? 'selected' : '' }}>
                            {{ $user->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            @endif
            <div class="col-md-3 d-flex align-items-end">
                <button type="submit" class="btn btn-primary me-2"><i class="fas fa-search"></i> {{ __('container_entries.index.filters.filter') }}</button>
                <a href="{{ route('container-entries.index') }}" class="btn btn-secondary"><i class="fas fa-times"></i> {{ __('container_entries.index.filters.clear') }}</a>
            </div>
        </form>
    </div>
</div>

<!-- Controles de Paginación -->
@if($containerEntries->total() > 0 || $containerEntries->hasPages())
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('container-entries.index') }}" id="pagination-form" class="d-flex justify-content-between align-items-center flex-wrap gap-3">
            <!-- Mantener filtros en campos ocultos -->
            @if(request('estado'))
                <input type="hidden" name="estado" value="{{ request('estado') }}">
            @endif
            @if(request('n_camion'))
                <input type="hidden" name="n_camion" value="{{ request('n_camion') }}">
            @endif
            @if(request('usuario_asignado_id'))
                <input type="hidden" name="usuario_asignado_id" value="{{ request('usuario_asignado_id') }}">
            @endif
            
            <div class="d-flex align-items-center gap-2">
                <label for="per_page">{{ __('container_entries.index.pagination.per_page') }}</label>
                <select name="per_page" id="per_page" class="form-control" style="width: auto;" onchange="this.form.submit()">
                    <option value="10" {{ request('per_page', 20) == 10 ? 'selected' : '' }}>10</option>
                    <option value="25" {{ request('per_page', 20) == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ request('per_page', 20) == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ request('per_page', 20) == 100 ? 'selected' : '' }}>100</option>
                    <option value="250" {{ request('per_page', 20) == 250 ? 'selected' : '' }}>250</option>
                </select>
            </div>
            <div class="text-muted">
                {{ __('container_entries.index.pagination.page_info', [
                    'current' => $containerEntries->currentPage(),
                    'last' => $containerEntries->lastPage(),
                    'total' => $containerEntries->total()
                ]) }}
            </div>
            <div class="d-flex align-items-center gap-2">
                @if($containerEntries->onFirstPage())
                    <button type="button" class="btn btn-sm" disabled>{{ __('container_entries.index.pagination.prev') }}</button>
                @else
                    <a href="{{ $containerEntries->previousPageUrl() }}" class="btn btn-sm">{{ __('container_entries.index.pagination.prev') }}</a>
                @endif
                
                @foreach($containerEntries->getUrlRange(max(1, $containerEntries->currentPage() - 2), min($containerEntries->lastPage(), $containerEntries->currentPage() + 2)) as $page => $url)
                    @if($page == $containerEntries->currentPage())
                        <span class="pagination-link active">{{ $page }}</span>
                    @else
                        <a href="{{ $url }}" class="pagination-link">{{ $page }}</a>
                    @endif
                @endforeach
                
                @if($containerEntries->hasMorePages())
                    <a href="{{ $containerEntries->nextPageUrl() }}" class="btn btn-sm">{{ __('container_entries.index.pagination.next') }}</a>
                @else
                    <button type="button" class="btn btn-sm" disabled>{{ __('container_entries.index.pagination.next') }}</button>
                @endif
            </div>
        </form>
    </div>
</div>
@endif

<!-- Tabla de Entradas -->
<div class="card">
    <div class="card-header">
        <h5><i class="fas fa-list"></i> {{ __('container_entries.index.table.title') }}</h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>{{ __('container_entries.index.table.headers.id') }}</th>
                        <th>{{ __('container_entries.index.table.headers.truck_number') }}</th>
                        <th>{{ __('container_entries.index.table.headers.brand') }}</th>
                        <th>{{ __('container_entries.index.table.headers.product_type') }}</th>
                        <th>{{ __('container_entries.index.table.headers.status') }}</th>
                        <th>{{ __('container_entries.index.table.headers.assigned_users') }}</th>
                        <th>{{ __('container_entries.index.table.headers.progress') }}</th>
                        <th>{{ __('container_entries.index.table.headers.cycle_time') }}</th>
                        <th>{{ __('container_entries.index.table.headers.created_at') }}</th>
                        <th style="width: 200px">{{ __('container_entries.index.table.headers.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                @forelse($containerEntries as $entry)
                    <tr>
                        <td>{{ $entry->id }}</td>
                        <td><strong>{{ $entry->n_camion }}</strong></td>
                        <td>{{ $entry->marca ?? '-' }}</td>
                        <td>{{ $entry->tipo_producto ?? '-' }}</td>
                        <td>
                            <span class="badge badge-{{ $entry->estado->isFinalizado() ? 'success' : 'warning' }}">
                                {{ $entry->estado->label() }}
                            </span>
                        </td>
                        <td>
                            @php
                                $nombres = [];
                                if ($entry->usuarioAsignado) { $nombres[] = $entry->usuarioAsignado->name . __('container_entries.index.table.primary_label'); }
                                foreach(($entry->usuariosAsignados ?? []) as $u){ $nombres[] = $u->name; }
                            @endphp
                            @if(count($nombres))
                                {{ implode(', ', array_unique($nombres)) }}
                            @else
                                <span class="text-muted">{{ __('container_entries.common.not_assigned') }}</span>
                            @endif
                        </td>
                        <td>
                            @if(isset($entry->progress))
                                <div class="progress" style="height: 20px;">
                                    <div class="progress-bar {{ $entry->progress['percentage'] >= 100 ? 'bg-success' : 'bg-info' }}" 
                                         role="progressbar" 
                                         style="width: {{ min(100, $entry->progress['percentage']) }}%">
                                        {{ $entry->progress['percentage'] }}%
                                    </div>
                                </div>
                                <small class="text-muted">
                                    {{ __('container_entries.index.table.progress_units', [
                                        'scanned' => $entry->progress['scanned_units'],
                                        'theoretical' => $entry->progress['theoretical_units']
                                    ]) }}
                                </small>
                            @else
                                <span class="text-muted">{{ __('container_entries.common.not_available') }}</span>
                            @endif
                        </td>
                        <td>
                            @if(isset($entry->cycle_time))
                                {{ $entry->cycle_time['formatted'] }}
                            @else
                                <span class="text-muted">{{ __('container_entries.common.in_process') }}</span>
                            @endif
                        </td>
                        <td>{{ $entry->created_at->format('d/m/Y H:i') }}</td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('container-entries.show', $entry) }}" class="btn btn-sm btn-outline-secondary" title="{{ __('container_entries.common.view') }}">
                                    <i class="fas fa-eye"></i>
                                </a>
                                @can('inventory.update')
                                <a href="{{ route('container-entries.edit', $entry) }}" class="btn btn-sm btn-outline-primary" title="{{ __('container_entries.common.edit') }}">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @endcan
                                @can('inventory.update')
                                <button type="button" class="btn btn-sm btn-outline-success" title="{{ __('container_entries.common.assign_users') }}" data-bs-toggle="modal" data-bs-target="#assignUsersModal" data-entry-id="{{ $entry->id }}">
                                    <i class="fas fa-users"></i>
                                </button>
                                @endcan
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="10" class="text-center text-muted p-4">
                            {{ __('container_entries.index.table.empty') }}
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('styles')
<style>
/* Asegurar que la tabla tenga los mismos estilos que inventario */
.data-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 0;
    font-size: 13px;
    box-shadow: 0 1px 5px rgba(0,0,0,0.08);
    border-radius: 0;
    overflow: hidden;
}

.data-table th, .data-table td {
    border: 1px solid #DFE3E8;
    padding: 8px 12px;
    text-align: left;
    vertical-align: middle;
}

.data-table th {
    background-color: #F7F9FC;
    color: #555;
    font-weight: 600;
    position: relative;
    cursor: default;
    padding-right: 25px;
    user-select: none;
    white-space: nowrap;
    transition: background-color 0.2s ease;
}

.data-table th:hover {
    background-color: #E6EEF5;
}

.data-table tbody tr:nth-child(even) {
    background-color: #FCFDFF;
}

.data-table tbody tr:hover {
    background-color: #EBF2F9;
}

.data-table tbody tr td {
    border: 1px solid #DFE3E8;
}

.table-responsive {
    overflow-x: auto;
}

.pagination-link {
    padding: 5px 10px;
    margin: 0 2px;
    border: 1px solid #007bff;
    border-radius: 3px;
    text-decoration: none;
    color: #007bff;
    cursor: pointer;
    font-size: 14px;
    display: inline-block;
}

.pagination-link:hover:not(.active) {
    background-color: #e6f2ff;
}

.pagination-link.active {
    background-color: #007bff;
    color: white;
    pointer-events: none;
}
</style>
@endpush
@endsection

