@extends('layouts.app')

@section('title', __('config.show.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-eye"></i> {{ __('config.show.title') }}</h2>
    <div>
        <a href="{{ route('config.edit', $config) }}" class="btn btn-primary"><i class="fas fa-edit"></i> {{ __('config.show.edit') }}</a>
        <a href="{{ route('config.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> {{ __('config.show.back') }}</a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="mb-3">
            <strong>{{ __('config.show.key') }}</strong>
            <div><code>{{ $config->key }}</code></div>
        </div>
        <div class="mb-3">
            <strong>{{ __('config.show.value') }}</strong>
            <pre class="mb-0" style="white-space: pre-wrap">{{ $config->value }}</pre>
        </div>
        <div class="text-muted small">
            {{ __('config.show.created_at') }} {{ $config->created_at }} | {{ __('config.show.updated_at') }} {{ $config->updated_at }}
        </div>
    </div>
</div>
@endsection


