@extends('layouts.app')

@section('title', __('config.create.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus"></i> {{ __('config.create.title') }}</h2>
    <a href="{{ route('config.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> {{ __('config.create.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('config.store') }}">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{ __('config.form.key_label') }}</label>
                <input type="text" name="key" class="form-control" value="{{ old('key') }}" required>
                @error('key')
                    <div class="text-danger small">{{ $message }}</div>
                @enderror
            </div>
            <div class="mb-3">
                <label class="form-label">{{ __('config.form.value_label') }}</label>
                <textarea name="value" rows="6" class="form-control">{{ old('value') }}</textarea>
                @error('value')
                    <div class="text-danger small">{{ $message }}</div>
                @enderror
            </div>
            <button class="btn btn-primary" type="submit"><i class="fas fa-save"></i> {{ __('config.create.submit') }}</button>
        </form>
    </div>
@endsection


