@extends('layouts.app')

@section('title', __('clients.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-handshake"></i> {{ __('clients.title') }}</h2>
    @can('clients.create')
    <a href="{{ route('clients.create') }}" class="btn">
        <i class="fas fa-plus"></i> {{ __('clients.buttons.add_client') }}
    </a>
    @endcan
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-header">
        <h5><i class="fas fa-filter"></i> {{ __('clients.filters.title') }}</h5>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('clients.index') }}" class="row g-3">
            <div class="col-md-4">
                <label for="search" class="form-label">{{ __('clients.filters.search') }}</label>
                <input type="text" class="form-control" id="search" name="search" 
                       value="{{ request('search') }}" placeholder="{{ __('clients.filters.search_placeholder') }}">
            </div>
            <div class="col-md-4">
                <label for="status" class="form-label">{{ __('clients.filters.status') }}</label>
                <select class="form-control" id="status" name="status">
                    <option value="">{{ __('clients.filters.all') }}</option>
                    <option value="1" {{ request('status') === '1' ? 'selected' : '' }}>{{ __('clients.filters.active') }}</option>
                    <option value="0" {{ request('status') === '0' ? 'selected' : '' }}>{{ __('clients.filters.inactive') }}</option>
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">&nbsp;</label>
                <div class="d-flex gap-2">
                    <button type="submit" class="btn">
                        <i class="fas fa-search"></i> {{ __('clients.filters.apply') }}
                    </button>
                    <a href="{{ route('clients.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> {{ __('clients.filters.reset') }}
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Controles de Paginación -->
@if($clients->total() > 0 || $clients->hasPages())
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('clients.index') }}" id="pagination-form" class="d-flex justify-content-between align-items-center flex-wrap gap-3">
            <!-- Mantener filtros en campos ocultos -->
            @if(request('search'))
                <input type="hidden" name="search" value="{{ request('search') }}">
            @endif
            @if(request('status'))
                <input type="hidden" name="status" value="{{ request('status') }}">
            @endif
            
            <div class="d-flex align-items-center gap-2">
                <label for="per_page">{{ __('clients.pagination.rows_per_page') }}</label>
                <select name="per_page" id="per_page" class="form-control" style="width: auto;" onchange="this.form.submit()">
                    <option value="10" {{ request('per_page', 20) == 10 ? 'selected' : '' }}>10</option>
                    <option value="25" {{ request('per_page', 20) == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ request('per_page', 20) == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ request('per_page', 20) == 100 ? 'selected' : '' }}>100</option>
                    <option value="250" {{ request('per_page', 20) == 250 ? 'selected' : '' }}>250</option>
                </select>
            </div>
            <div class="text-muted">
                {{ __('clients.pagination.page_info', [
                    'current' => $clients->currentPage(),
                    'total' => $clients->lastPage(),
                    'records' => $clients->total()
                ]) }}
            </div>
            <div class="d-flex align-items-center gap-2">
                @if($clients->onFirstPage())
                    <button type="button" class="btn btn-sm" disabled>{{ __('clients.pagination.previous') }}</button>
                @else
                    <a href="{{ $clients->previousPageUrl() }}" class="btn btn-sm">{{ __('clients.pagination.previous') }}</a>
                @endif
                
                @foreach($clients->getUrlRange(max(1, $clients->currentPage() - 2), min($clients->lastPage(), $clients->currentPage() + 2)) as $page => $url)
                    @if($page == $clients->currentPage())
                        <span class="pagination-link active">{{ $page }}</span>
                    @else
                        <a href="{{ $url }}" class="pagination-link">{{ $page }}</a>
                    @endif
                @endforeach
                
                @if($clients->hasMorePages())
                    <a href="{{ $clients->nextPageUrl() }}" class="btn btn-sm">{{ __('clients.pagination.next') }}</a>
                @else
                    <button type="button" class="btn btn-sm" disabled>{{ __('clients.pagination.next') }}</button>
                @endif
            </div>
        </form>
    </div>
</div>
@endif

<!-- Tabla de Clientes -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-list"></i> {{ __('clients.table.title') }}</h5>
        <span class="badge bg-primary">{{ __('clients.table.count', ['count' => $clients->total()]) }}</span>
    </div>
    <div class="card-body p-0">
        @if($clients->count() > 0)
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>{{ __('clients.table.columns.id') }}</th>
                            <th>{{ __('clients.table.columns.name') }}</th>
                            <th>{{ __('clients.table.columns.email') }}</th>
                            <th>{{ __('clients.table.columns.contact') }}</th>
                            <th>{{ __('clients.table.columns.phone') }}</th>
                            <th>{{ __('clients.table.columns.status') }}</th>
                            <th>{{ __('clients.table.columns.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($clients as $client)
                            <tr>
                                <td>{{ $client->id }}</td>
                                <td>{{ $client->client_name }}</td>
                                <td>{{ $client->email ?? '-' }}</td>
                                <td>{{ $client->contact_person ?? '-' }}</td>
                                <td>{{ $client->phone ?? '-' }}</td>
                                <td>
                                    <span class="badge badge-{{ $client->is_active ? 'success' : 'secondary' }}">
                                        {{ $client->is_active ? __('clients.table.status_badges.active') : __('clients.table.status_badges.inactive') }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('clients.show', $client) }}" class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @can('clients.update')
                                        <a href="{{ route('clients.edit', $client) }}" class="btn btn-sm btn-outline-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @endcan
                                        @can('clients.delete')
                                        <form action="{{ route('clients.destroy', $client) }}" method="POST" 
                                              class="d-inline" onsubmit="return confirm('{{ __('clients.confirm_delete') }}')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-handshake fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">{{ __('clients.table.empty.title') }}</h5>
                <p class="text-muted">{{ __('clients.table.empty.description') }}</p>
                <a href="{{ route('clients.create') }}" class="btn">
                    <i class="fas fa-plus"></i> {{ __('clients.buttons.add_first_client') }}
                </a>
            </div>
        @endif
    </div>
</div>
@endsection

@push('styles')
<style>
.btn-group {
    display: flex;
    gap: 5px;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 0.8em;
    min-width: auto;
}

.btn-outline-info {
    background-color: transparent;
    color: #17a2b8;
    border: 1px solid #17a2b8;
}

.btn-outline-info:hover {
    background-color: #17a2b8;
    color: white;
}

.btn-outline-warning {
    background-color: transparent;
    color: #ffc107;
    border: 1px solid #ffc107;
}

.btn-outline-warning:hover {
    background-color: #ffc107;
    color: white;
}

.btn-outline-danger {
    background-color: transparent;
    color: #dc3545;
    border: 1px solid #dc3545;
}

.btn-outline-danger:hover {
    background-color: #dc3545;
    color: white;
}

.badge {
    padding: 0.5em 0.75em;
    font-size: 0.75em;
    font-weight: 700;
    line-height: 1;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: 0.375rem;
}

.bg-primary {
    background-color: var(--sap-blue-light) !important;
}

.badge-success {
    background-color: #28a745;
    color: white;
}

.badge-secondary {
    background-color: #6c757d;
    color: white;
}

/* Asegurar que la tabla tenga los mismos estilos que inventario */
.data-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 0;
    font-size: 13px;
    box-shadow: 0 1px 5px rgba(0,0,0,0.08);
    border-radius: 0;
    overflow: hidden;
}

.data-table th, .data-table td {
    border: 1px solid #DFE3E8;
    padding: 8px 12px;
    text-align: left;
    vertical-align: middle;
}

.data-table th {
    background-color: #F7F9FC;
    color: #555;
    font-weight: 600;
    position: relative;
    cursor: default;
    padding-right: 25px;
    user-select: none;
    white-space: nowrap;
    transition: background-color 0.2s ease;
}

.data-table th:hover {
    background-color: #E6EEF5;
}

.data-table tbody tr:nth-child(even) {
    background-color: #FCFDFF;
}

.data-table tbody tr:hover {
    background-color: #EBF2F9;
}

.data-table tbody tr td {
    border: 1px solid #DFE3E8;
}

.table-responsive {
    overflow-x: auto;
}

.pagination-link {
    padding: 5px 10px;
    margin: 0 2px;
    border: 1px solid #007bff;
    border-radius: 3px;
    text-decoration: none;
    color: #007bff;
    cursor: pointer;
    font-size: 14px;
    display: inline-block;
}

.pagination-link:hover:not(.active) {
    background-color: #e6f2ff;
}

.pagination-link.active {
    background-color: #007bff;
    color: white;
    pointer-events: none;
}
</style>
@endpush
