@extends('layouts.app')

@section('title', 'Detalle del Artículo')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-eye"></i> Detalle del Artículo</h2>
    <div class="d-flex gap-2">
        @can('articles.update')
        <a href="{{ route('articles.edit', $article) }}" class="btn">
            <i class="fas fa-edit"></i> Editar
        </a>
        @endcan
        <a href="{{ route('articles.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> Información Principal</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>MOCACO</label>
                            <p><code>{{ $article->mocaco }}</code></p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Sección</label>
                            <p>{{ $article->seccion ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Familia</label>
                            <p>{{ $article->familia ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Cadena</label>
                            <p>{{ $article->cadena ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Mercado Origen</label>
                            <p>{{ $article->mercado_origen_articulo ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Precio PVP Máximo</label>
                            <p>{{ $article->precio_pvp_maximo_temporada ? '$' . number_format($article->precio_pvp_maximo_temporada, 2) : '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Partida Arancelaria</label>
                            <p>{{ $article->partida_arancelaria ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Campaña</label>
                            <p>{{ $article->campana ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Peso Unitario</label>
                            <p>{{ $article->peso_unitario ? $article->peso_unitario . ' kg' : '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Grupo Arancelario</label>
                            <p>{{ $article->grupo_arancelario ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                @if($article->composition)
                <div class="info-group">
                    <label>Composición</label>
                    <p>{{ $article->composition }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-clock"></i> Información Temporal</h5>
            </div>
            <div class="card-body">
                <div class="info-group">
                    <label>ID del Artículo</label>
                    <p><strong>{{ $article->id }}</strong></p>
                </div>
                
                <div class="info-group">
                    <label>Creado</label>
                    <p>{{ $article->created_at->format('d/m/Y H:i:s') }}</p>
                </div>
                
                <div class="info-group">
                    <label>Última Actualización</label>
                    <p>{{ $article->updated_at->format('d/m/Y H:i:s') }}</p>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-cogs"></i> Acciones</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('articles.edit', $article) }}" class="btn">
                        <i class="fas fa-edit"></i> Editar Artículo
                    </a>
                    
                    <form action="{{ route('articles.destroy', $article) }}" method="POST" 
                          onsubmit="return confirm('¿Está seguro de eliminar este artículo?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Eliminar Artículo
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-boxes"></i> Inventario</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Este artículo puede estar presente en múltiples items de inventario.</p>
                <a href="{{ route('inventory.index', ['search' => $article->mocaco]) }}" class="btn btn-outline-primary">
                    <i class="fas fa-search"></i> Ver en Inventario
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.info-group {
    margin-bottom: 20px;
}

.info-group label {
    font-weight: 600;
    color: var(--sap-text-medium);
    font-size: 0.9em;
    margin-bottom: 5px;
    display: block;
}

.info-group p {
    margin: 0;
    padding: 8px 12px;
    background-color: #f8f9fa;
    border-radius: 4px;
    border-left: 3px solid var(--sap-blue-light);
    font-size: 0.95em;
}

code {
    font-family: 'Courier New', monospace;
    background-color: #e9ecef;
    padding: 2px 6px;
    border-radius: 3px;
    font-size: 0.9em;
    color: #495057;
}

.gap-2 {
    gap: 10px;
}

.d-grid {
    display: grid;
}

.btn-outline-primary {
    background-color: transparent;
    color: var(--sap-blue-light);
    border: 1px solid var(--sap-blue-light);
}

.btn-outline-primary:hover {
    background-color: var(--sap-blue-light);
    color: white;
}

.w-100 {
    width: 100%;
}
</style>
@endpush

