@extends('layouts.app')

@section('title', 'Editar Artículo')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-edit"></i> Editar Artículo</h2>
    <a href="{{ route('articles.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-edit"></i> Información del Artículo</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('articles.update', $article) }}">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mocaco">MOCACO *</label>
                                <input type="text" class="form-control" id="mocaco" name="mocaco" 
                                       value="{{ old('mocaco', $article->mocaco) }}" required>
                                @error('mocaco')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="seccion">Sección</label>
                                <input type="text" class="form-control" id="seccion" name="seccion" 
                                       value="{{ old('seccion', $article->seccion) }}">
                                @error('seccion')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="familia">Familia</label>
                                <input type="text" class="form-control" id="familia" name="familia" 
                                       value="{{ old('familia', $article->familia) }}">
                                @error('familia')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="cadena">Cadena</label>
                                <input type="text" class="form-control" id="cadena" name="cadena" 
                                       value="{{ old('cadena', $article->cadena) }}">
                                @error('cadena')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mercado_origen_articulo">Mercado Origen</label>
                                <input type="text" class="form-control" id="mercado_origen_articulo" name="mercado_origen_articulo" 
                                       value="{{ old('mercado_origen_articulo', $article->mercado_origen_articulo) }}">
                                @error('mercado_origen_articulo')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="precio_pvp_maximo_temporada">Precio PVP Máximo</label>
                                <input type="number" step="0.01" class="form-control" id="precio_pvp_maximo_temporada" 
                                       name="precio_pvp_maximo_temporada" value="{{ old('precio_pvp_maximo_temporada', $article->precio_pvp_maximo_temporada) }}">
                                @error('precio_pvp_maximo_temporada')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="partida_arancelaria">Partida Arancelaria</label>
                                <input type="text" class="form-control" id="partida_arancelaria" name="partida_arancelaria" 
                                       value="{{ old('partida_arancelaria', $article->partida_arancelaria) }}">
                                @error('partida_arancelaria')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="campana">Campaña</label>
                                <input type="text" class="form-control" id="campana" name="campana" 
                                       value="{{ old('campana', $article->campana) }}">
                                @error('campana')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="peso_unitario">Peso Unitario</label>
                                <input type="number" step="0.001" class="form-control" id="peso_unitario" 
                                       name="peso_unitario" value="{{ old('peso_unitario', $article->peso_unitario) }}">
                                @error('peso_unitario')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="grupo_arancelario">Grupo Arancelario</label>
                                <input type="text" class="form-control" id="grupo_arancelario" name="grupo_arancelario" 
                                       value="{{ old('grupo_arancelario', $article->grupo_arancelario) }}">
                                @error('grupo_arancelario')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="composition">Composición</label>
                        <textarea class="form-control" id="composition" name="composition" rows="3">{{ old('composition', $article->composition) }}</textarea>
                        @error('composition')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('articles.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancelar
                        </a>
                        <button type="submit" class="btn">
                            <i class="fas fa-save"></i> Actualizar Artículo
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> Información del Artículo</h5>
            </div>
            <div class="card-body">
                <p><strong>ID:</strong> {{ $article->id }}</p>
                <p><strong>Creado:</strong> {{ $article->created_at->format('d/m/Y H:i') }}</p>
                <p><strong>Actualizado:</strong> {{ $article->updated_at->format('d/m/Y H:i') }}</p>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-trash"></i> Eliminar Artículo</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Esta acción no se puede deshacer.</p>
                <form action="{{ route('articles.destroy', $article) }}" method="POST" 
                      onsubmit="return confirm('¿Está seguro de eliminar este artículo?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i> Eliminar Artículo
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Auto-focus en el primer campo
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('mocaco').focus();
});
</script>
@endpush

@push('styles')
<style>
.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.text-danger {
    font-size: 0.8em;
    margin-top: 5px;
}

.gap-2 {
    gap: 10px;
}

.btn-danger {
    background-color: #dc3545;
    color: white;
    border: none;
}

.btn-danger:hover {
    background-color: #c82333;
}
</style>
@endpush

