<?php

return [
    'title' => 'User Management',
    'create' => 'Create User',
    'edit' => 'Edit User',
    'view' => 'User Details',
    'back' => 'Back',
    'new' => 'New User',
    'create_new' => 'Create New User',

    'filters' => [
        'title' => 'Filters',
        'search' => 'Search',
        'search_placeholder' => 'Name, email, operator...',
        'role' => 'Role',
        'all_roles' => 'All roles',
        'status' => 'Status',
        'all' => 'All',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'apply' => 'Search',
        'clear' => 'Clear',
    ],

    'table' => [
        'title' => 'Users',
        'total' => 'users',
        'id' => 'ID',
        'name' => 'Name',
        'email' => 'Email',
        'operario_id' => 'Operator ID',
        'roles' => 'Roles',
        'status' => 'Status',
        'actions' => 'Actions',
        'no_users' => 'No users found',
        'no_users_message' => 'Try adjusting the filters or create a new user.',
        'create_first' => 'Create First User',
    ],

    'pagination' => [
        'rows_per_page' => 'Rows per page',
        'page_info' => 'Page :current of :total (:records records)',
        'previous' => 'Previous',
        'next' => 'Next',
    ],

    'fields' => [
        'name' => 'Name',
        'email' => 'Email',
        'password' => 'Password',
        'password_confirmation' => 'Confirm Password',
        'new_password' => 'New Password',
        'confirm_new_password' => 'Confirm New Password',
        'operario_id' => 'Operator ID',
        'operario_id_placeholder' => 'OP001',
        'client_id' => 'Client (Client Portal)',
        'no_client' => 'No client (internal user)',
        'is_active' => 'Status',
        'roles' => 'Roles',
        'password_leave_empty' => 'Leave empty to keep current password.',
        'roles_multiple' => 'Hold Ctrl (Cmd on Mac) to select multiple roles.',
        'client_note' => 'Assigning a client allows access to the Client Portal.',
    ],

    'info' => [
        'title' => 'Information',
        'user_info' => 'User Information',
        'personal_info' => 'Personal Information',
        'required_fields' => 'Required fields:',
        'required_note' => 'Fields marked with (*) are required.',
        'email_note' => 'Email:',
        'email_description' => 'Must be unique in the system.',
        'password_note' => 'Password:',
        'password_description' => 'Minimum 8 characters.',
        'password_leave_empty_note' => 'Password:',
        'password_leave_empty_description' => 'Leave empty to keep current password.',
        'roles_note' => 'Roles:',
        'roles_description' => 'Select one or more roles for the user.',
    ],

    'show' => [
        'id' => 'ID:',
        'name' => 'Name:',
        'email' => 'Email:',
        'operario_id' => 'Operator ID:',
        'status' => 'Status:',
        'registration_date' => 'Registration Date:',
        'roles_permissions' => 'Roles and Permissions',
        'roles_label' => 'Roles:',
        'permissions_label' => 'Permissions:',
        'actions' => 'Actions',
        'edit_user' => 'Edit User',
        'delete_user' => 'Delete User',
        'statistics' => 'Statistics',
        'orders_created' => 'Orders Created:',
        'total_roles' => 'Total Roles:',
        'total_permissions' => 'Total Permissions:',
    ],

    'buttons' => [
        'create' => 'Create User',
        'update' => 'Update User',
        'cancel' => 'Cancel',
        'delete' => 'Delete User',
    ],

    'messages' => [
        'delete_confirm' => 'Are you sure you want to delete this user?',
        'no_email' => 'No email',
    ],

    'status' => [
        'active' => 'Active',
        'inactive' => 'Inactive',
    ],
];
