<?php

return [
    'title' => 'Client History',
    'header' => 'Client and Dispatched Orders History',
    'back' => 'Back',
    
    'select_client' => [
        'title' => 'Select Client',
        'label' => 'Select Client *',
        'loading' => 'Loading clients...',
        'placeholder' => 'Search or select a client',
        'select_placeholder' => 'Select a client...',
        'no_clients' => 'No clients available.',
    ],
    
    'info' => [
        'title' => 'Information',
        'instructions' => 'Instructions:',
        'step1' => 'Select a client from the list',
        'step2' => 'View their order history',
        'step3' => 'Check details of each order',
        'step4' => 'Export the history if needed',
        'note' => 'Note:',
        'note_text' => 'Only orders with "dispatched" status are shown.',
    ],
    
    'stats' => [
        'title' => 'Client Statistics',
        'select_client' => 'Select a client to view statistics.',
        'total_orders' => 'Total Orders',
        'total_items' => 'Dispatched Items',
        'total_boxes' => 'Unique Boxes',
        'last_order' => 'Last Order:',
        'error' => 'Error loading statistics.',
    ],
    
    'export' => [
        'title' => 'Export History',
        'select_client' => 'Select a client to export their history.',
        'button' => 'Export History CSV',
    ],
    
    'orders' => [
        'title' => 'Order History',
        'select_client' => 'Select a client to view their order history.',
        'loading' => 'Loading order history...',
        'no_orders' => 'No dispatched orders found for this client.',
        'error' => 'Error loading order history.',
        'order_number' => 'Order #:id',
        'order_date' => 'Order Date:',
        'dispatch_date' => 'Dispatch Date:',
        'operator' => 'Operator:',
        'items' => 'Items:',
        'notes' => 'Notes:',
        'view_details' => 'View Details',
    ],
    
    'order_details' => [
        'title' => 'Order Details #:id',
        'client' => 'Client:',
        'order_date' => 'Order Date:',
        'dispatch_date' => 'Dispatch Date:',
        'operator' => 'Operator:',
        'status' => 'Status:',
        'status_dispatched' => 'Dispatched',
        'total_items' => 'Total Items:',
        'notes' => 'Notes:',
        'barcode' => 'Barcode',
        'mocaco' => 'MOCACO',
        'box_number' => 'Box Number',
        'close' => 'Close',
        'error' => 'Error loading order details.',
    ],
    
    'messages' => [
        'clients_load_error' => 'Could not load clients.',
        'network_error' => 'Network error loading clients.',
        'email' => 'Email:',
        'phone' => 'Phone:',
        'not_available' => 'N/A',
    ],
];


