<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Admin User
        $admin = User::firstOrCreate(
            ['email' => 'admin@inventory.com'],
            [
                'name' => 'Administrador',
                'password' => Hash::make('admin123'),
                'email_verified_at' => now(),
            ]
        );
        
        // Assign admin role
        $adminRole = Role::where('name', 'admin')->first();
        if ($adminRole && !$admin->hasRole('admin')) {
            $admin->assignRole($adminRole);
        }

        // Create Operator User
        $operator = User::firstOrCreate(
            ['email' => 'operador@inventory.com'],
            [
                'name' => 'Operador',
                'password' => Hash::make('operador123'),
                'email_verified_at' => now(),
            ]
        );
        
        // Assign operator role
        $operatorRole = Role::where('name', 'operator')->first();
        if ($operatorRole && !$operator->hasRole('operator')) {
            $operator->assignRole($operatorRole);
        }

        // Create Viewer User
        $viewer = User::firstOrCreate(
            ['email' => 'viewer@inventory.com'],
            [
                'name' => 'Visualizador',
                'password' => Hash::make('viewer123'),
                'email_verified_at' => now(),
            ]
        );
        
        // Assign viewer role
        $viewerRole = Role::where('name', 'viewer')->first();
        if ($viewerRole && !$viewer->hasRole('viewer')) {
            $viewer->assignRole($viewerRole);
        }

        // Create additional test users
        $testUsers = [
            [
                'name' => 'Juan Pérez',
                'email' => 'juan.perez@inventory.com',
                'password' => Hash::make('password123'),
                'role' => 'operator',
            ],
            [
                'name' => 'María García',
                'email' => 'maria.garcia@inventory.com',
                'password' => Hash::make('password123'),
                'role' => 'operator',
            ],
            [
                'name' => 'Carlos López',
                'email' => 'carlos.lopez@inventory.com',
                'password' => Hash::make('password123'),
                'role' => 'viewer',
            ],
        ];

        foreach ($testUsers as $userData) {
            $user = User::firstOrCreate(
                ['email' => $userData['email']],
                [
                    'name' => $userData['name'],
                    'password' => $userData['password'],
                    'email_verified_at' => now(),
                ]
            );
            
            $role = Role::where('name', $userData['role'])->first();
            if ($role && !$user->hasRole($userData['role'])) {
                $user->assignRole($role);
            }
        }

        $this->command->info('Users created successfully!');
        $this->command->info('Admin: admin@inventory.com / admin123');
        $this->command->info('Operator: operador@inventory.com / operador123');
        $this->command->info('Viewer: viewer@inventory.com / viewer123');
        $this->command->info('Test users: juan.perez@inventory.com, maria.garcia@inventory.com, carlos.lopez@inventory.com / password123');
    }
}