<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ScannerOption;

class ScannerOptionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $options = [
            // Seasons
            ['type' => 'season', 'value' => 'VERANO', 'label' => 'VERANO'],
            ['type' => 'season', 'value' => 'INVIERNO', 'label' => 'INVIERNO'],
            ['type' => 'season', 'value' => 'X', 'label' => 'X'],

            // Categories
            ['type' => 'category', 'value' => 'REG.', 'label' => 'REG.'],
            ['type' => 'category', 'value' => 'TARA', 'label' => 'TARA'],
            ['type' => 'category', 'value' => 'TARA 2', 'label' => 'TARA 2'],

            // Families
            ['type' => 'family', 'value' => 'ACCESSOIR', 'label' => 'ACCESSORIES'],
            ['type' => 'family', 'value' => 'CONJUNTO', 'label' => 'CONJUNTO'],
            ['type' => 'family', 'value' => 'DRESS', 'label' => 'DRESS'],
            ['type' => 'family', 'value' => 'KNITWEAR', 'label' => 'KNITWEAR'],
            ['type' => 'family', 'value' => 'O.GARMENTS', 'label' => 'O.GARMENTS'],
            ['type' => 'family', 'value' => 'SHIRTS', 'label' => 'SHIRTS'],
            ['type' => 'family', 'value' => 'SKIRT', 'label' => 'SKIRT'],
            ['type' => 'family', 'value' => 'TRAJE', 'label' => 'TRAJE'],
            ['type' => 'family', 'value' => 'TROUSERS', 'label' => 'TROUSERS'],
            ['type' => 'family', 'value' => 'T-SHIRTS', 'label' => 'T-SHIRTS'],
            ['type' => 'family', 'value' => 'VARIED CLOTHES', 'label' => 'VARIED CLOTHES'],
            ['type' => 'family', 'value' => 'VARIED BAGS', 'label' => 'VARIED BAGS'],
            ['type' => 'family', 'value' => 'VARIED SHOES', 'label' => 'VARIED SHOES'],

            // Details
            ['type' => 'detail', 'value' => 'ACC BEBÉ', 'label' => 'ACC BEBÉ'],
            ['type' => 'detail', 'value' => 'ACC CALZADO', 'label' => 'ACC CALZADO'],
            ['type' => 'detail', 'value' => 'ACC DISFRAZ', 'label' => 'ACC DISFRAZ'],
            ['type' => 'detail', 'value' => 'ACC PELO', 'label' => 'ACC PELO'],
            ['type' => 'detail', 'value' => 'ACC PIJAMA', 'label' => 'ACC PIJAMA'],
            ['type' => 'detail', 'value' => 'ANTIFÁZ', 'label' => 'ANTIFÁZ'],
            ['type' => 'detail', 'value' => 'BABERO', 'label' => 'BABERO'],
            ['type' => 'detail', 'value' => 'BABUCHA', 'label' => 'BABUCHA'],
            ['type' => 'detail', 'value' => 'BAÑADOR', 'label' => 'BAÑADOR'],
            ['type' => 'detail', 'value' => 'BODY', 'label' => 'BODY'],
            ['type' => 'detail', 'value' => 'BODY PACK', 'label' => 'BODY PACK'],
            ['type' => 'detail', 'value' => 'BOLSA TELA', 'label' => 'BOLSA TELA'],
            ['type' => 'detail', 'value' => 'BOTA', 'label' => 'BOTA'],
            ['type' => 'detail', 'value' => 'BOTELLA', 'label' => 'BOTELLA'],
            ['type' => 'detail', 'value' => 'BRAGA', 'label' => 'BRAGA'],
            ['type' => 'detail', 'value' => 'BRAGUITA', 'label' => 'BRAGUITA'],
            ['type' => 'detail', 'value' => 'CAJA VACÍA BISUTERÍA', 'label' => 'CAJA VACÍA BISUTERÍA'],
            ['type' => 'detail', 'value' => 'CALCETIN CORTO', 'label' => 'CALCETIN CORTO'],
            ['type' => 'detail', 'value' => 'CALCETIN PACK', 'label' => 'CALCETIN PACK'],
            ['type' => 'detail', 'value' => 'CALCETIN SUELTO', 'label' => 'CALCETIN SUELTO'],
            ['type' => 'detail', 'value' => 'CALCETINES', 'label' => 'CALCETINES'],
            ['type' => 'detail', 'value' => 'CALENTADORES', 'label' => 'CALENTADORES'],
            ['type' => 'detail', 'value' => 'CAMISETA', 'label' => 'CAMISETA'],
            ['type' => 'detail', 'value' => 'CAPRI', 'label' => 'CAPRI'],
            ['type' => 'detail', 'value' => 'CARTERA', 'label' => 'CARTERA'],
            ['type' => 'detail', 'value' => 'CHALECO', 'label' => 'CHALECO'],
            ['type' => 'detail', 'value' => 'CINTURON', 'label' => 'CINTURON'],
            ['type' => 'detail', 'value' => 'CINTURÓN VESTIDO', 'label' => 'CINTURÓN VESTIDO'],
            ['type' => 'detail', 'value' => 'COLLAR', 'label' => 'COLLAR'],
            ['type' => 'detail', 'value' => 'CONJUNTO', 'label' => 'CONJUNTO'],
            ['type' => 'detail', 'value' => 'CORDONES', 'label' => 'CORDONES'],
            ['type' => 'detail', 'value' => 'CORPIÑO', 'label' => 'CORPIÑO'],
            ['type' => 'detail', 'value' => 'CORTA', 'label' => 'CORTA'],
            ['type' => 'detail', 'value' => 'CORTO', 'label' => 'CORTO'],
            ['type' => 'detail', 'value' => 'CORTO PIEL', 'label' => 'CORTO PIEL'],
            ['type' => 'detail', 'value' => 'CUMPLENAÑOS', 'label' => 'CUMPLENAÑOS'],
            ['type' => 'detail', 'value' => 'DELANTAL', 'label' => 'DELANTAL'],
            ['type' => 'detail', 'value' => 'DIADEMA', 'label' => 'DIADEMA'],
            ['type' => 'detail', 'value' => 'DISFRAZ', 'label' => 'DISFRAZ'],
            ['type' => 'detail', 'value' => 'FALDA', 'label' => 'FALDA'],
            ['type' => 'detail', 'value' => 'FOULAR', 'label' => 'FOULAR'],
            ['type' => 'detail', 'value' => 'FUNDA MOVIL', 'label' => 'FUNDA MOVIL'],
            ['type' => 'detail', 'value' => 'FUNDA RELOJ', 'label' => 'FUNDA RELOJ'],
            ['type' => 'detail', 'value' => 'FUNDA VACÍA GAFAS', 'label' => 'FUNDA VACÍA GAFAS'],
            ['type' => 'detail', 'value' => 'GABARDINA', 'label' => 'GABARDINA'],
            ['type' => 'detail', 'value' => 'GAFAS', 'label' => 'GAFAS'],
            ['type' => 'detail', 'value' => 'GORRA', 'label' => 'GORRA'],
            ['type' => 'detail', 'value' => 'GORRO', 'label' => 'GORRO'],
            ['type' => 'detail', 'value' => 'GORRO CUMPEAÑOS', 'label' => 'GORRO CUMPEAÑOS'],
            ['type' => 'detail', 'value' => 'GORRO NAVIDAD', 'label' => 'GORRO NAVIDAD'],
            ['type' => 'detail', 'value' => 'GUANTE BOX', 'label' => 'GUANTE BOX'],
            ['type' => 'detail', 'value' => 'GUANTES', 'label' => 'GUANTES'],
            ['type' => 'detail', 'value' => 'KIMONO', 'label' => 'KIMONO'],
            ['type' => 'detail', 'value' => 'LARGA', 'label' => 'LARGA'],
            ['type' => 'detail', 'value' => 'LARGA PIEL', 'label' => 'LARGA PIEL'],
            ['type' => 'detail', 'value' => 'LEOTARDOS PACK', 'label' => 'LEOTARDOS PACK'],
            ['type' => 'detail', 'value' => 'LEOTARDOS SUELTOS', 'label' => 'LEOTARDOS SUELTOS'],
            ['type' => 'detail', 'value' => 'LIBRETA', 'label' => 'LIBRETA'],
            ['type' => 'detail', 'value' => 'LLAVERO', 'label' => 'LLAVERO'],
            ['type' => 'detail', 'value' => 'MANOPLA COCINA', 'label' => 'MANOPLA COCINA'],
            ['type' => 'detail', 'value' => 'MANTELERIA', 'label' => 'MANTELERIA'],
            ['type' => 'detail', 'value' => 'MEDIA', 'label' => 'MEDIA'],
            ['type' => 'detail', 'value' => 'MOCHILA', 'label' => 'MOCHILA'],
            ['type' => 'detail', 'value' => 'MONEDERO', 'label' => 'MONEDERO'],
            ['type' => 'detail', 'value' => 'MONO CORTO', 'label' => 'MONO CORTO'],
            ['type' => 'detail', 'value' => 'MONO LARGO', 'label' => 'MONO LARGO'],
            ['type' => 'detail', 'value' => 'NECESER', 'label' => 'NECESER'],
            ['type' => 'detail', 'value' => 'PAJARITA', 'label' => 'PAJARITA'],
            ['type' => 'detail', 'value' => 'PAÑUELO', 'label' => 'PAÑUELO'],
            ['type' => 'detail', 'value' => 'PARAGUAS', 'label' => 'PARAGUAS'],
            ['type' => 'detail', 'value' => 'PERFUME', 'label' => 'PERFUME'],
            ['type' => 'detail', 'value' => 'PETATE', 'label' => 'PETATE'],
            ['type' => 'detail', 'value' => 'PIEL', 'label' => 'PIEL'],
            ['type' => 'detail', 'value' => 'PIJAMA', 'label' => 'PIJAMA'],
            ['type' => 'detail', 'value' => 'PORTA AURICULARES', 'label' => 'PORTA AURICULARES'],
            ['type' => 'detail', 'value' => 'PORTA TRAJE', 'label' => 'PORTA TRAJE'],
            ['type' => 'detail', 'value' => 'SHORT', 'label' => 'SHORT'],
            ['type' => 'detail', 'value' => 'SKIRT', 'label' => 'SKIRT'],
            ['type' => 'detail', 'value' => 'SOMBRERO', 'label' => 'SOMBRERO'],
            ['type' => 'detail', 'value' => 'SPORT', 'label' => 'SPORT'],
            ['type' => 'detail', 'value' => 'SPORTS PIEL', 'label' => 'SPORTS PIEL'],
            ['type' => 'detail', 'value' => 'T-SHIRT', 'label' => 'T-SHIRT'],
            ['type' => 'detail', 'value' => 'TIRANTES', 'label' => 'TIRANTES'],
            ['type' => 'detail', 'value' => 'TOP', 'label' => 'TOP'],
            ['type' => 'detail', 'value' => 'TROUSERS', 'label' => 'TROUSERS'],
            ['type' => 'detail', 'value' => 'UNDERWEAR', 'label' => 'UNDERWEAR'],
            ['type' => 'detail', 'value' => 'UNDERWEAR PACK 2', 'label' => 'UNDERWEAR PACK 2'],
            ['type' => 'detail', 'value' => 'UNDERWEAR PACK 3', 'label' => 'UNDERWEAR PACK 3'],
            ['type' => 'detail', 'value' => 'UNDERWEAR PACK 4', 'label' => 'UNDERWEAR PACK 4'],
            ['type' => 'detail', 'value' => 'UNDERWEAR PACK 5', 'label' => 'UNDERWEAR PACK 5'],
            ['type' => 'detail', 'value' => 'V', 'label' => 'V'],
            ['type' => 'detail', 'value' => 'VESTIDO', 'label' => 'VESTIDO'],
        ];

        foreach ($options as $option) {
            ScannerOption::updateOrCreate(
                ['type' => $option['type'], 'value' => $option['value']],
                ['label' => $option['label'], 'active' => true]
            );
        }
    }
}
