<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ScannerOption;

class ScannerBrandSectionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $options = [
            // Brands (Marcas)
            ['type' => 'brand', 'value' => 'ZARA', 'label' => 'ZARA'],
            ['type' => 'brand', 'value' => 'BERSHKA', 'label' => 'BERSHKA'],
            ['type' => 'brand', 'value' => 'PULL&BEAR', 'label' => 'PULL&BEAR'],
            ['type' => 'brand', 'value' => 'STRADIVARIUS', 'label' => 'STRADIVARIUS'],
            ['type' => 'brand', 'value' => 'MASSIMO DUTTI', 'label' => 'MASSIMO DUTTI'],
            ['type' => 'brand', 'value' => 'OYSHO', 'label' => 'OYSHO'],
            ['type' => 'brand', 'value' => 'ZARA HOME', 'label' => 'ZARA HOME'],
            ['type' => 'brand', 'value' => 'LEFTIES', 'label' => 'LEFTIES'],
            ['type' => 'brand', 'value' => 'H&M', 'label' => 'H&M'],
            ['type' => 'brand', 'value' => 'MANGO', 'label' => 'MANGO'],
            ['type' => 'brand', 'value' => 'OTHER', 'label' => 'OTRA'],

            // Sections (Secciones)
            ['type' => 'section', 'value' => 'WOMAN', 'label' => 'WOMAN'],
            ['type' => 'section', 'value' => 'MAN', 'label' => 'MAN'],
            ['type' => 'section', 'value' => 'KIDS', 'label' => 'KIDS'],
            ['type' => 'section', 'value' => 'TRF', 'label' => 'TRF'],
            ['type' => 'section', 'value' => 'BASIC', 'label' => 'BASIC'],
            ['type' => 'section', 'value' => 'DENIM', 'label' => 'DENIM'],
            ['type' => 'section', 'value' => 'KNITWEAR', 'label' => 'KNITWEAR'],
            ['type' => 'section', 'value' => 'ACCESSORIES', 'label' => 'ACCESSORIES'],
            ['type' => 'section', 'value' => 'SHOES', 'label' => 'SHOES'],
            ['type' => 'section', 'value' => 'BAGS', 'label' => 'BAGS'],
            ['type' => 'section', 'value' => 'HOME', 'label' => 'HOME'],
        ];

        foreach ($options as $option) {
            ScannerOption::updateOrCreate(
                ['type' => $option['type'], 'value' => $option['value']],
                ['label' => $option['label'], 'active' => true]
            );
        }
    }
}
