<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class ReservationPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Define reservation permissions
        $permissions = [
            'reservations.view' => 'Ver reservas de cajas',
            'reservations.create' => 'Crear reservas de cajas',
            'reservations.import' => 'Importar cajas a reservas',
            'reservations.update' => 'Actualizar reservas',
            'reservations.cancel' => 'Cancelar reservas',
        ];

        // Create permissions
        foreach ($permissions as $name => $description) {
            Permission::firstOrCreate(
                ['name' => $name],
                ['guard_name' => 'web']
            );
        }

        $this->command->info('Permisos de reservas creados correctamente.');

        // Assign permissions to admin role
        $adminRole = Role::where('name', 'admin')->first();
        if ($adminRole) {
            $adminRole->givePermissionTo(array_keys($permissions));
            $this->command->info('Permisos asignados al rol admin.');
        }

        // Optionally assign some permissions to other roles
        $managerRole = Role::where('name', 'manager')->first();
        if ($managerRole) {
            $managerRole->givePermissionTo([
                'reservations.view',
                'reservations.create',
                'reservations.import',
                'reservations.update',
            ]);
            $this->command->info('Permisos asignados al rol manager.');
        }

        $operatorRole = Role::where('name', 'operator')->first();
        if ($operatorRole) {
            $operatorRole->givePermissionTo([
                'reservations.view',
            ]);
            $this->command->info('Permisos asignados al rol operator.');
        }
    }
}
