<?php

namespace Database\Seeders;

use App\Models\ContainerEntry;
use App\Models\User;
use App\Enums\ContainerEntryStatus;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ContainerEntrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Obtener usuarios para asignación
        $admin = User::where('email', 'admin@inventory.com')->first();
        $operator = User::where('email', 'operador@inventory.com')->first();

        $containerEntries = [
            [
                'n_camion' => 'PT233I23',
                'marca' => 'ZARA',
                'tipo_producto' => 'Textil',
                'estado' => ContainerEntryStatus::EN_PROCESO->value,
                'usuario_asignado_id' => $operator?->id,
                'fecha_inicio_proceso' => now()->subDays(2),
                'fecha_finalizacion' => null,
                'notes' => 'Contenedor de ejemplo con artículos de temporada',
                'created_at' => now()->subDays(2),
                'updated_at' => now()->subDays(2),
            ],
            [
                'n_camion' => 'PT233I24',
                'marca' => 'H&M',
                'tipo_producto' => 'Textil y Accesorios',
                'estado' => ContainerEntryStatus::EN_PROCESO->value,
                'usuario_asignado_id' => $operator?->id,
                'fecha_inicio_proceso' => now()->subDays(1),
                'fecha_finalizacion' => null,
                'notes' => 'Segunda entrada de ejemplo',
                'created_at' => now()->subDays(1),
                'updated_at' => now()->subDays(1),
            ],
            [
                'n_camion' => 'PT233I25',
                'marca' => 'Mango',
                'tipo_producto' => 'Textil',
                'estado' => ContainerEntryStatus::FINALIZADO->value,
                'usuario_asignado_id' => $operator?->id,
                'fecha_inicio_proceso' => now()->subDays(5),
                'fecha_finalizacion' => now()->subDays(3),
                'notes' => 'Contenedor finalizado - ejemplo de proceso completo',
                'created_at' => now()->subDays(5),
                'updated_at' => now()->subDays(3),
            ],
        ];

        foreach ($containerEntries as $entryData) {
            ContainerEntry::firstOrCreate(
                ['n_camion' => $entryData['n_camion']],
                $entryData
            );
        }

        $this->command->info('Container entries created successfully!');
        $this->command->info('Created ' . count($containerEntries) . ' container entries');
    }
}

