<?php

namespace Database\Seeders;

use App\Models\Client;
use Illuminate\Database\Seeder;

class ClientSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $clients = [
            [
                'client_name' => 'Distribuidora Central S.A.',
                'email' => 'contacto@distribuidoracentral.com',
                'phone' => '+34 91 123 4567',
                'address' => 'Calle Mayor 123, Madrid',
            ],
            [
                'client_name' => 'Comercial del Norte',
                'email' => 'info@comercialnorte.es',
                'phone' => '+34 94 567 8901',
                'address' => 'Avenida de la Paz 45, Bilbao',
            ],
            [
                'client_name' => 'Importaciones Mediterráneas',
                'email' => 'ventas@importmed.com',
                'phone' => '+34 96 234 5678',
                'address' => 'Plaza del Mar 12, Valencia',
            ],
            [
                'client_name' => 'Textiles del Sur',
                'email' => 'contacto@textilessur.es',
                'phone' => '+34 95 345 6789',
                'address' => 'Calle Sevilla 78, Sevilla',
            ],
            [
                'client_name' => 'Moda Barcelona',
                'email' => 'info@modabarcelona.cat',
                'phone' => '+34 93 456 7890',
                'address' => 'Passeig de Gràcia 156, Barcelona',
            ],
            [
                'client_name' => 'Distribuidora Atlántica',
                'email' => 'contacto@distatlantica.es',
                'phone' => '+34 98 567 8901',
                'address' => 'Rúa Nova 23, A Coruña',
            ],
            [
                'client_name' => 'Comercial Levante',
                'email' => 'ventas@comerciallevante.es',
                'phone' => '+34 96 678 9012',
                'address' => 'Calle Colón 89, Alicante',
            ],
            [
                'client_name' => 'Textiles Industriales S.L.',
                'email' => 'comercial@textilesindustriales.es',
                'phone' => '+34 91 789 0123',
                'address' => 'Polígono Industrial Norte, Madrid',
            ],
            [
                'client_name' => 'Moda Express',
                'email' => 'pedidos@modaexpress.es',
                'phone' => '+34 91 890 1234',
                'address' => 'Calle Gran Vía 234, Madrid',
            ],
            [
                'client_name' => 'Distribuidora Canaria',
                'email' => 'info@distcanaria.es',
                'phone' => '+34 92 901 2345',
                'address' => 'Avenida Marítima 67, Las Palmas',
            ],
            [
                'client_name' => 'Textiles del Este',
                'email' => 'contacto@textileseste.es',
                'phone' => '+34 97 123 4567',
                'address' => 'Carrer de la Pau 45, Palma',
            ],
        ];

        foreach ($clients as $clientData) {
            Client::create(array_merge($clientData, [
                'is_active' => true
            ]));
        }

        $this->command->info('Clientes creados exitosamente: ' . count($clients));
    }
}