<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ArticleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $articles = [
            [
                'mocaco' => 'ART001',
                'seccion' => 'Sección A',
                'familia' => 'Camisetas',
                'cadena' => 'CAM01',
                'mercado_origen_articulo' => 'España',
                'precio_pvp_maximo_temporada' => 29.99,
                'partida_arancelaria' => '6109.10',
                'composition' => '100% algodón',
                'campana' => '2024',
                'peso_unitario' => 0.250,
                'grupo_arancelario' => 'TEXTIL',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'mocaco' => 'ART002',
                'seccion' => 'Sección A',
                'familia' => 'Pantalones',
                'cadena' => 'PAN01',
                'mercado_origen_articulo' => 'Turquía',
                'precio_pvp_maximo_temporada' => 45.50,
                'partida_arancelaria' => '6203.42',
                'composition' => '70% algodón, 30% poliéster',
                'campana' => '2024',
                'peso_unitario' => 0.450,
                'grupo_arancelario' => 'TEXTIL',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'mocaco' => 'ART003',
                'seccion' => 'Sección B',
                'familia' => 'Calzado Deportivo',
                'cadena' => 'CAL01',
                'mercado_origen_articulo' => 'China',
                'precio_pvp_maximo_temporada' => 79.99,
                'partida_arancelaria' => '6404.20',
                'composition' => 'Cuero sintético',
                'campana' => '2024',
                'peso_unitario' => 0.800,
                'grupo_arancelario' => 'CALZADO',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'mocaco' => 'ART004',
                'seccion' => 'Sección C',
                'familia' => 'Bolsos',
                'cadena' => 'BOL01',
                'mercado_origen_articulo' => 'Italia',
                'precio_pvp_maximo_temporada' => 89.99,
                'partida_arancelaria' => '4202.12',
                'composition' => 'Cuero genuino',
                'campana' => '2024',
                'peso_unitario' => 0.600,
                'grupo_arancelario' => 'ACCESORIOS',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'mocaco' => 'ART005',
                'seccion' => 'Sección D',
                'familia' => 'Chaquetas',
                'cadena' => 'CHA01',
                'mercado_origen_articulo' => 'Portugal',
                'precio_pvp_maximo_temporada' => 129.99,
                'partida_arancelaria' => '6201.93',
                'composition' => 'Poliéster impermeable',
                'campana' => '2024',
                'peso_unitario' => 0.950,
                'grupo_arancelario' => 'TEXTIL',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('articles')->insert($articles);
    }
}
