<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('inventory', function (Blueprint $table) {
            $table->enum('reservation_status', ['available', 'reserved', 'confirmed'])->default('available')->after('status');
            $table->foreignId('reserved_for_client_id')->nullable()->after('reservation_status')->constrained('clients')->onDelete('set null');
            $table->foreignId('reservation_id')->nullable()->after('reserved_for_client_id')->constrained('box_reservations')->onDelete('set null');

            $table->index('reservation_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory', function (Blueprint $table) {
            $table->dropForeign(['reserved_for_client_id']);
            $table->dropForeign(['reservation_id']);
            $table->dropColumn(['reservation_status', 'reserved_for_client_id', 'reservation_id']);
        });
    }
};
