<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('theoretical_articles')) {
            return;
        }
        
        Schema::create('theoretical_articles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('container_entry_id')->constrained('container_entries')->onDelete('cascade');
            $table->string('mocaco', 20)->index();
            $table->integer('cantidad_unidades')->default(1)->comment('Cantidad de unidades esperadas (agrupación)');
            
            // Datos del artículo (igual que inventory)
            $table->string('season_int', 20)->nullable();
            $table->string('categoria_seleccionada', 20)->nullable();
            $table->string('famillie_usuario', 50)->nullable();
            $table->string('detail_usuario', 100)->nullable();
            $table->string('seccion', 50)->nullable();
            $table->string('familia_articulo_description', 100)->nullable();
            $table->string('cadena', 50)->nullable();
            $table->string('mercado_origen_articulo', 100)->nullable();
            $table->decimal('precio_pvp_maximo_temporada', 10, 2)->nullable();
            $table->string('partida_arancelaria', 50)->nullable();
            $table->text('composition')->nullable();
            $table->string('campana', 50)->nullable();
            $table->decimal('peso_unitario', 8, 3)->nullable();
            $table->string('grupo_arancelario', 50)->nullable();
            
            // Campos para trazabilidad
            $table->text('notes')->nullable();
            $table->timestamps();
            
            // Índices para rendimiento
            $table->index(['container_entry_id', 'mocaco']);
            $table->index('cantidad_unidades');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('theoretical_articles');
    }
};
