<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory', function (Blueprint $table) {
            $table->id();
            $table->string('full_barcode', 50)->index();
            $table->string('mocaco', 20)->index();
            $table->string('n_carton', 50)->index();
            $table->string('season_int', 20)->nullable();
            $table->text('notes')->nullable();
            $table->string('conteneur', 50)->nullable();
            $table->string('n_id_operario', 20)->nullable();
            $table->string('ubicacion', 50)->nullable();
            $table->string('categoria_seleccionada', 20)->nullable();
            $table->string('famillie_usuario', 50)->nullable();
            $table->string('seccion', 50)->nullable();
            $table->string('familia_articulo_description', 100)->nullable();
            $table->string('cadena', 50)->nullable();
            $table->string('mercado_origen_articulo', 100)->nullable();
            $table->decimal('precio_pvp_maximo_temporada', 10, 2)->nullable();
            $table->string('partida_arancelaria', 50)->nullable();
            $table->text('composition')->nullable();
            $table->string('campana', 50)->nullable();
            $table->decimal('peso_unitario', 8, 3)->nullable();
            $table->string('grupo_arancelario', 50)->nullable();
            $table->string('detail_usuario', 100)->nullable();
            $table->timestamp('fecha_escaneo')->useCurrent();
            $table->timestamps();
            
            // // Foreign key to articles table
            // $table->foreign('mocaco')->references('mocaco')->on('articles')->onDelete('cascade');
            
            // Indexes for performance
            $table->index(['n_carton', 'full_barcode']);
            $table->index(['conteneur', 'n_carton']);
            $table->index('fecha_escaneo');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory');
    }
};