<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
// Nota: usamos nombres de clase como string para evitar errores de análisis estático si el paquete no está cargado en tiempo de análisis

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Aliases de middleware (Spatie Permission)
        $middleware->alias([
            'role' => 'Spatie\\Permission\\Middleware\\RoleMiddleware',
            'permission' => 'Spatie\\Permission\\Middleware\\PermissionMiddleware',
            'role_or_permission' => 'Spatie\\Permission\\Middleware\\RoleOrPermissionMiddleware',
            'client.access' => \App\Http\Middleware\EnsureClientAccess::class,
        ]);

        $middleware->appendToGroup('web', \App\Http\Middleware\SetLocale::class);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
