<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RelabelingProduct extends Model
{
    use HasFactory;

    protected $fillable = [
        'proveedor_code',
        'codebar_gnu',
        'description',
        'price_cfa',
    ];

    protected $casts = [
        'price_cfa' => 'decimal:2',
    ];

    /**
     * Scope for filtering by provider code.
     */
    public function scopeByProviderCode($query, string $code)
    {
        return $query->where('proveedor_code', $code);
    }
}