<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ImportProgress extends Model
{
    protected $table = 'import_progress';

    protected $fillable = [
        'container_entry_id',
        'filename',
        'total_rows',
        'processed_rows',
        'failed_rows',
        'imported_rows',
        'skipped_rows',
        'status',
        'started_at',
        'completed_at',
        'error_message',
    ];

    protected $casts = [
        'started_at' => 'datetime',
        'completed_at' => 'datetime',
    ];

    /**
     * Get the container entry that owns the import progress
     */
    public function containerEntry()
    {
        return $this->belongsTo(ContainerEntry::class);
    }

    /**
     * Get progress percentage
     */
    public function getProgressPercentageAttribute()
    {
        if ($this->total_rows == 0) {
            return 0;
        }
        return round(($this->processed_rows / $this->total_rows) * 100, 2);
    }

    /**
     * Check if import is complete
     */
    public function isComplete()
    {
        return $this->status === 'completed';
    }

    /**
     * Check if import failed
     */
    public function isFailed()
    {
        return $this->status === 'failed';
    }

    /**
     * Check if import is processing
     */
    public function isProcessing()
    {
        return $this->status === 'processing';
    }
}
