<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureClientAccess
{
    /**
     * Handle an incoming request.
     * Ensures user has client_id and can only access their own client's data.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();

        // Solo usuarios con rol 'client' o usuarios con client_id
        if (!$user->hasRole('client') && !$user->client_id) {
            abort(403, 'Acceso denegado. Esta área es solo para clientes.');
        }

        // Si tiene client_id, verificar que solo acceda a sus propios datos
        if ($user->client_id) {
            // Verificar acceso a orden específica si hay parámetro order
            if ($request->route('order')) {
                $order = $request->route('order');
                // Si es un modelo, acceder directamente a client_id
                if (is_object($order) && method_exists($order, 'getAttribute')) {
                    if ($order->client_id !== $user->client_id) {
                        abort(403, 'No tienes permiso para acceder a esta orden.');
                    }
                } elseif (is_numeric($order)) {
                    // Si es solo el ID, cargar el modelo
                    $orderModel = \App\Models\Order::find($order);
                    if (!$orderModel || $orderModel->client_id !== $user->client_id) {
                        abort(403, 'No tienes permiso para acceder a esta orden.');
                    }
                }
            }
        }

        return $next($request);
    }
}

