<?php

namespace App\Http\Controllers;

use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class LanguageController extends Controller
{
    protected array $availableLocales = ['es', 'en', 'fr'];

    public function switch(Request $request): RedirectResponse
    {
        $request->validate([
            'locale' => 'required|in:' . implode(',', $this->availableLocales),
        ]);

        session(['app_locale' => $request->locale]);

        return back();
    }
}

