<?php

namespace App\Http\Controllers;

use App\Models\SystemConfig;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ConfigController extends Controller
{
    public function index()
    {
        $configs = SystemConfig::orderBy('key')->paginate(20);
        return view('config.index', compact('configs'));
    }

    public function create()
    {
        return view('config.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'key' => 'required|string|max:150|unique:config,key',
            'value' => 'nullable|string',
        ]);

        $config = SystemConfig::create($validated);

        return redirect()->route('config.index')
            ->with('success', 'Parámetro creado correctamente.');
    }

    public function show(SystemConfig $config)
    {
        return view('config.show', compact('config'));
    }

    public function edit(SystemConfig $config)
    {
        return view('config.edit', compact('config'));
    }

    public function update(Request $request, SystemConfig $config)
    {
        $validated = $request->validate([
            'key' => 'required|string|max:150|unique:config,key,' . $config->id,
            'value' => 'nullable|string',
        ]);

        $config->update($validated);

        return redirect()->route('config.index')
            ->with('success', 'Parámetro actualizado correctamente.');
    }

    public function destroy(SystemConfig $config)
    {
        $config->delete();
        return redirect()->route('config.index')
            ->with('success', 'Parámetro eliminado.');
    }
}


