<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;

class OrderReservationTemplateExport implements FromCollection, WithHeadings, WithTitle
{
    public function collection(): Collection
    {
        return collect([
            [
                'client_id' => 5,
                'cliente' => 'CLIENTE DEMO',
                'n_carton' => 'CAJA001',
                'observacion' => 'Reserva urgente',
                'pedido_id' => '',
            ],
            [
                'client_id' => '',
                'cliente' => 'CLIENTE DEMO 2',
                'n_carton' => 'CAJA002',
                'observacion' => 'Incluye pallet completo',
                'pedido_id' => '',
            ],
            [
                'client_id' => '',
                'cliente' => '',
                'n_carton' => 'CAJA003',
                'observacion' => 'Agregar a pedido existente',
                'pedido_id' => 42,
            ],
        ]);
    }

    public function headings(): array
    {
        return [
            'client_id',
            'cliente',
            'n_carton',
            'observacion',
            'pedido_id',
        ];
    }

    public function title(): string
    {
        return 'Plantilla Reservas';
    }
}

