<?php

namespace App\Exports;

use App\Models\Inventory;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class InventoryByBrandExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
    protected $brand;

    public function __construct($brand = null)
    {
        $this->brand = $brand;
    }

    public function query()
    {
        $query = Inventory::query()
            ->join('articles', 'inventory.mocaco', '=', 'articles.mocaco')
            ->select(
                'inventory.*',
                'articles.cadena',
                'articles.seccion',
                'articles.familia',
                'articles.precio_pvp_maximo_temporada',
                'articles.peso_unitario'
            )
            ->whereIn('inventory.status', ['disponible', 'available']);

        if ($this->brand) {
            $query->where('articles.cadena', $this->brand);
        }

        return $query->orderBy('articles.cadena')->orderBy('inventory.mocaco');
    }

    public function headings(): array
    {
        return [
            'ID',
            'Código de Barras',
            'Mocaco',
            'Marca/Cadena',
            'Sección',
            'Familia',
            'Número de Caja',
            'Contenedor',
            'Ubicación',
            'Cantidad',
            'Precio PVP',
            'Peso Unitario',
            'Fecha Escaneo',
            'Operario',
        ];
    }

    public function map($inventory): array
    {
        return [
            $inventory->id,
            $inventory->full_barcode,
            $inventory->mocaco,
            $inventory->cadena ?? 'N/A',
            $inventory->seccion ?? 'N/A',
            $inventory->familia ?? 'N/A',
            $inventory->n_carton,
            $inventory->conteneur,
            $inventory->ubicacion ?? 'Sin ubicación',
            1, // Cantidad (cada registro es 1 unidad)
            $inventory->precio_pvp_maximo_temporada ?? 'N/A',
            $inventory->peso_unitario ?? 'N/A',
            $inventory->fecha_escaneo,
            $inventory->n_id_operario,
        ];
    }
}
