<?php

namespace App\Exports;

use App\Models\Inventory;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class InventoryAvailableExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    /**
     * Get available inventory items
     */
    public function collection()
    {
        return Inventory::where('reservation_status', 'available')
            ->where('status', '!=', 'dispatched')
            ->orderBy('n_carton')
            ->get();
    }

    /**
     * Map each row
     */
    public function map($inventory): array
    {
        return [
            $inventory->n_carton,
            $inventory->client->client_name ?? 'N/A',
            $inventory->cadena,
            $inventory->seccion,
            $inventory->familia_articulo_description,
            $inventory->cantidad ?? 1,
            $inventory->ubicacion,
            $inventory->conteneur,
            $inventory->fecha_escaneo ? $inventory->fecha_escaneo->format('Y-m-d') : '',
            '', // SELECCIONAR column - empty for user to fill
        ];
    }

    /**
     * Define headings
     */
    public function headings(): array
    {
        return [
            'BOX_NUMBER',
            'CLIENTE_ORIGINAL',
            'MARCA',
            'SECCION',
            'FAMILIA',
            'CANTIDAD',
            'UBICACION',
            'CONTENEDOR',
            'FECHA_ENTRADA',
            'SELECCIONAR', // User fills with X or 1
        ];
    }

    /**
     * Apply styles
     */
    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
